/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.settings;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.groovy.grails.RuntimeHelper;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.netbeans.modules.groovy.support.spi.GroovyOptionsSubpanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class GrailsRuntimePanel
extends JPanel
implements GroovyOptionsSubpanel {
    private final GrailsSettings settings = GrailsSettings.getInstance();
    private JButton chooseDir;
    private JTextField grailsHomeLocation;
    private JLabel jLabel2;
    private JLabel jLabel5;

    public GrailsRuntimePanel() {
        this.initComponents();
    }

    private void displayGrailsHomeWarning() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"LBL_Not_grails_home"), 2));
    }

    private void initComponents() {
        this.grailsHomeLocation = new JTextField();
        this.chooseDir = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.grailsHomeLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsRuntimePanel.this.grailsHomeLocationActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDir, (String)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.chooseDir.text"));
        this.chooseDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GrailsRuntimePanel.this.chooseDirActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.jLabel2.text"));
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GrailsRuntimePanel.this.jLabel2MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GrailsRuntimePanel.this.jLabel2MouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                GrailsRuntimePanel.this.jLabel2MousePressed(evt);
            }
        });
        this.jLabel5.setLabelFor(this.grailsHomeLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GrailsRuntimePanel.class, (String)"GrailsRuntimePanel.jLabel5.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.grailsHomeLocation)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseDir)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap(165, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.grailsHomeLocation, -2, -1, -2).addComponent(this.chooseDir)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2)));
        this.grailsHomeLocation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.grailsHomeLocation.accessibleName"));
        this.grailsHomeLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.grailsHomeLocation.accessibleDescription"));
        this.chooseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.chooseDir.accessibleName"));
        this.chooseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"SupportPanel.chooseDir.accessibleDescription"));
    }

    private void chooseDirActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(GrailsRuntimePanel.class).setDirectoriesOnly(true).setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).setApproveText(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"LBL_Select_Directory")).setTitle(NbBundle.getMessage(GrailsRuntimePanel.class, (String)"LBL_Select_Directory")).showOpenDialog();
        if (file != null && RuntimeHelper.isValidRuntime(file)) {
            this.grailsHomeLocation.setText(file.getAbsolutePath());
        } else if (file != null) {
            this.displayGrailsHomeWarning();
        }
    }

    private void jLabel2MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel2MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jLabel2MousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://www.grails.org"));
        }
        catch (MalformedURLException murle) {
            Exceptions.printStackTrace((Throwable)murle);
        }
    }

    private void grailsHomeLocationActionPerformed(ActionEvent evt) {
        if (!this.valid()) {
            this.displayGrailsHomeWarning();
        }
    }

    public Component getComponent() {
        return this;
    }

    public void load() {
        this.grailsHomeLocation.setText(this.settings.getGrailsBase());
    }

    public void store() {
        this.settings.setGrailsBase(this.grailsHomeLocation.getText());
    }

    public boolean valid() {
        String location = this.grailsHomeLocation.getText();
        if ("".equals(location.trim())) {
            return false;
        }
        return RuntimeHelper.isValidRuntime(new File(location));
    }

    public boolean changed() {
        String grailsBase = this.settings.getGrailsBase();
        return !this.grailsHomeLocation.getText().equals(grailsBase == null ? "" : grailsBase);
    }
}

