/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClusterUpdateProvider
implements UpdateProvider {
    private static File cluster = null;
    private static Logger LOG = Logger.getLogger(ClusterUpdateProvider.class.getName());
    private static final String ELEMENT_MODULE = "module";

    public static void attachCluster(File newCluster) {
        if (newCluster == null) {
            throw new IllegalArgumentException("Cluster cannot be null!");
        }
        cluster = newCluster;
    }

    public String getName() {
        return "ClusterUpdateProvider";
    }

    public String getDisplayName() {
        if (cluster == null) {
            return NbBundle.getMessage(ClusterUpdateProvider.class, (String)"ClusterUpdateProvider_DisplayName_disabled");
        }
        return NbBundle.getMessage(ClusterUpdateProvider.class, (String)"ClusterUpdateProvider_DisplayName", (Object)cluster);
    }

    public String getDescription() {
        return NbBundle.getMessage(ClusterUpdateProvider.class, (String)"ClusterUpdateProvider_Description");
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return UpdateUnitProvider.CATEGORY.STANDARD;
    }

    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        HashMap<String, UpdateItem> res = new HashMap<String, UpdateItem>();
        for (File cf : ClusterUpdateProvider.readModules(cluster)) {
            String cnb = cf.getName().substring(0, cf.getName().length() - ".xml".length()).replaceAll("-", ".");
            HashMap<String, String> attr = new HashMap<String, String>(7);
            ClusterUpdateProvider.readConfigFile(cf, attr);
            String jarName = (String)attr.get("jar");
            if (jarName == null) {
                LOG.info("Can`t get jar file name for " + cnb + ", skip checking.");
                continue;
            }
            File jarFile = new File(cluster, jarName);
            if (!jarFile.exists()) {
                LOG.info("Jar file " + jarFile + " doesn't exists. Skip checking " + cnb);
                continue;
            }
            File updateTrackingFile = new File(cluster, "update_tracking" + File.separator + cf.getName());
            if (!updateTrackingFile.exists()) {
                LOG.info("Update tracking file " + updateTrackingFile + " doesn't exists. Skip checking " + cnb);
                continue;
            }
            Manifest mf = new JarFile(jarFile).getManifest();
            UpdateItem item = UpdateItem.createModule((String)cnb, (String)((String)attr.get("specversion")), null, (String)cluster.getName(), (String)"0", (String)"", (String)"", (String)"", (Manifest)mf, (Boolean)Boolean.valueOf((String)attr.get("eager")), (Boolean)Boolean.valueOf((String)attr.get("autoload")), null, null, (String)"", (UpdateLicense)UpdateLicense.createUpdateLicense((String)"unknown-license", (String)"none"));
            res.put(cnb + '_' + (String)attr.get("specversion"), item);
        }
        return res;
    }

    public boolean refresh(boolean force) throws IOException {
        return true;
    }

    private static Collection<File> readModules(File cluster) {
        if (cluster == null || !cluster.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> res = new HashSet<File>();
        File config = new File(new File(cluster, "config"), "Modules");
        if (config.listFiles() == null) {
            return Collections.emptySet();
        }
        for (File cf : config.listFiles()) {
            if (cf.getName().endsWith(".xml_hidden")) continue;
            if (cf.getName().endsWith(".xml")) {
                if (cf.length() > 0L) {
                    res.add(cf);
                    continue;
                }
                LOG.log(Level.INFO, "Found zero-sized xml file in config/Modules, ignoring: " + cf);
                continue;
            }
            LOG.log(Level.INFO, "Found non-xml file in config/Modules, ignoring: " + cf);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfigFile(File cf, Map<String, String> attr) {
        Document document = null;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(cf));
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
        }
        catch (SAXException saxe) {
            LOG.log(Level.INFO, "Error while reading " + cf);
            LOG.log(Level.INFO, saxe.getLocalizedMessage(), saxe);
            return;
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "Error while reading " + cf);
            LOG.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        assert (document.getDocumentElement() != null) : "File " + cf + " must contain document element.";
        Element element = document.getDocumentElement();
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (1 != n.getNodeType()) continue;
            Element e = (Element)n;
            String name = e.getAttributes().getNamedItem("name").getNodeValue();
            String value = e.getChildNodes().item(0).getNodeValue();
            attr.put(name, value);
        }
    }
}

