/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.performance;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.discovery.performance.AnalyzeStat;
import org.netbeans.modules.cnd.discovery.performance.Bundle;
import org.netbeans.modules.cnd.discovery.performance.NotifyProjectProblem;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class PerformanceIssueDetector
implements PerformanceLogger.PerformanceListener,
CsmProgressListener {
    private final Set<Project> projects = new HashSet<Project>();
    private final Map<String, ReadEntry> readPerformance = new HashMap<String, ReadEntry>();
    private final Map<String, CreateEntry> createPerformance = new HashMap<String, CreateEntry>();
    private final Map<FileObject, PerformanceLogger.PerformanceEvent> createFOTimeOut = new HashMap<FileObject, PerformanceLogger.PerformanceEvent>();
    private final Map<File, PerformanceLogger.PerformanceEvent> createFileTimeOut = new HashMap<File, PerformanceLogger.PerformanceEvent>();
    private final Map<String, PerformanceLogger.PerformanceEvent> createItemTimeOut = new HashMap<String, PerformanceLogger.PerformanceEvent>();
    private final Map<String, ParseEntry> parsePerformance = new HashMap<String, ParseEntry>();
    private final Map<FileObject, PerformanceLogger.PerformanceEvent> parseTimeOut = new HashMap<FileObject, PerformanceLogger.PerformanceEvent>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ScheduledFuture<?> periodicTask;
    private static final int SCHEDULE = 15;
    static final long NANO_TO_SEC = 1000000000L;
    static final long NANO_TO_MILLI = 1000000L;
    static final int CREATION_SPEED_LIMIT = 100;
    static final int CREATION_SPEED_LIMIT_NORMAL = 500;
    static final int READING_SPEED_LIMIT = 100;
    static final int READING_SPEED_LIMIT_NORMAL = 1000;
    static final int PARSING_SPEED_LIMIT = 1000;
    static final int PARSING_SPEED_LIMIT_NORMAL = 10000;
    static final int PARSING_RATIO_LIMIT = 5;
    static final int PARSING_RATIO_LIMIT_NORMAL = 2;
    private boolean slowItemCreation = false;
    private boolean slowFileRead = false;
    private boolean slowParsed = false;
    private final AtomicInteger fullAnalyze = new AtomicInteger(0);
    static final Logger LOG = Logger.getLogger(PerformanceIssueDetector.class.getName());
    static final Level level = Level.FINE;
    private static final Level timeOutLevel = Level.INFO;
    private static PerformanceIssueDetector INSTANCE;

    public PerformanceIssueDetector() {
        this.periodicTask = PerformanceLogger.isProfilingEnabled() ? new RequestProcessor("PerformanceIssueDetector").scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PerformanceIssueDetector.this.analyze();
            }
        }, 15L, 15L, TimeUnit.SECONDS) : null;
        INSTANCE = this;
    }

    public static PerformanceIssueDetector getActiveInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Project project) {
        Set<Project> set = this.projects;
        synchronized (set) {
            this.projects.add(project);
            if (this.projects.size() == 1) {
                CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Project project) {
        Set<Project> set = this.projects;
        synchronized (set) {
            this.projects.remove(project);
            if (this.projects.isEmpty()) {
                CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                this.lock.writeLock().lock();
                try {
                    this.createPerformance.clear();
                    this.createFOTimeOut.clear();
                    this.createFileTimeOut.clear();
                    this.createItemTimeOut.clear();
                    this.readPerformance.clear();
                    this.parsePerformance.clear();
                    this.parseTimeOut.clear();
                    this.slowItemCreation = false;
                    this.slowFileRead = false;
                    this.slowParsed = false;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    public void processEvent(PerformanceLogger.PerformanceEvent event) {
        if ("LS_FOLDER_PERFORMANCE_EVENT".equals(event.getId())) {
            this.processCreateFolder(event);
        } else if ("LS_FOLDER_UTILS_PERFORMANCE_EVENT".equals(event.getId())) {
            this.processCreateFolderIO(event);
        } else if ("CREATE_ITEM_PERFORMANCE_EVENT".equals(event.getId())) {
            this.processCreateItem(event);
        } else if ("GET_ITEM_FILE_OBJECT_PERFORMANCE_EVENT".equals(event.getId())) {
            this.processGetItemFileObject(event);
        } else if ("READ_FILE_PERFORMANCE_EVENT".equals(event.getId())) {
            this.processRead(event);
        } else if ("PARSE_FILE_PERFORMANCE_EVENT".equals(event.getId())) {
            this.processParse(event);
        }
    }

    private boolean isNotNormalized(String path) {
        if (path.endsWith("/.") || path.endsWith("\\.")) {
            return true;
        }
        if (path.contains("/./")) {
            return true;
        }
        if (path.contains("\\.\\")) {
            return true;
        }
        return path.contains("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCreateFolder(PerformanceLogger.PerformanceEvent event) {
        FileObject fo = (FileObject)event.getSource();
        String dirName = fo.getPath();
        long time = event.getTime();
        if (event.getAttrs().length == 0) {
            LOG.log(timeOutLevel, "Timeout {0}s of directory list {1}", new Object[]{time / 1000000000L, dirName});
            this.lock.writeLock().lock();
            try {
                this.createFOTimeOut.put(fo, event);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return;
        }
        if (this.isNotNormalized(dirName)) {
            return;
        }
        long cpu = event.getCpuTime();
        long user = event.getUserTime();
        this.lock.writeLock().lock();
        try {
            this.createFOTimeOut.remove(fo);
            CreateEntry entry = this.createPerformance.get(dirName);
            if (entry == null) {
                entry = new CreateEntry();
                this.createPerformance.put(dirName, entry);
            }
            entry.number++;
            CreateEntry createEntry = entry;
            createEntry.time = createEntry.time + time;
            createEntry = entry;
            createEntry.cpu = createEntry.cpu + cpu;
            createEntry = entry;
            createEntry.user = createEntry.user + user;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCreateFolderIO(PerformanceLogger.PerformanceEvent event) {
        File fo = (File)event.getSource();
        String dirName = fo.getPath();
        long time = event.getTime();
        if (event.getAttrs().length == 0) {
            LOG.log(timeOutLevel, "Timeout {0}s of directory list {1}", new Object[]{time / 1000000000L, dirName});
            this.lock.writeLock().lock();
            try {
                this.createFileTimeOut.put(fo, event);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return;
        }
        if (this.isNotNormalized(dirName)) {
            return;
        }
        long cpu = event.getCpuTime();
        long user = event.getUserTime();
        this.lock.writeLock().lock();
        try {
            this.createFileTimeOut.remove(fo);
            CreateEntry entry = this.createPerformance.get(dirName);
            if (entry == null) {
                entry = new CreateEntry();
                this.createPerformance.put(dirName, entry);
            }
            entry.number++;
            CreateEntry createEntry = entry;
            createEntry.time = createEntry.time + time;
            createEntry = entry;
            createEntry.cpu = createEntry.cpu + cpu;
            createEntry = entry;
            createEntry.user = createEntry.user + user;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCreateItem(PerformanceLogger.PerformanceEvent event) {
        String path;
        if (event.getSource() instanceof FileObject) {
            FileObject fo = (FileObject)event.getSource();
            path = fo.getPath();
        } else {
            path = (String)event.getSource();
        }
        long time = event.getTime();
        if (event.getAttrs().length == 0) {
            LOG.log(timeOutLevel, "Timeout {0}s of create project item {1}", new Object[]{time / 1000000000L, path});
            this.lock.writeLock().lock();
            try {
                this.createItemTimeOut.put(path, event);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return;
        }
        long cpu = event.getCpuTime();
        long user = event.getUserTime();
        this.lock.writeLock().lock();
        try {
            String dirName;
            this.createItemTimeOut.remove(path);
            if (event.getSource() instanceof FileObject) {
                dirName = CndPathUtilities.getDirName((String)path);
            } else {
                Item item = (Item)event.getAttrs()[0];
                dirName = CndPathUtilities.getDirName((String)item.getAbsolutePath());
            }
            if (this.isNotNormalized(dirName)) {
                return;
            }
            CreateEntry entry = this.createPerformance.get(dirName);
            if (entry == null) {
                entry = new CreateEntry();
                this.createPerformance.put(dirName, entry);
            }
            entry.number++;
            CreateEntry createEntry = entry;
            createEntry.time = createEntry.time + time;
            createEntry = entry;
            createEntry.cpu = createEntry.cpu + cpu;
            createEntry = entry;
            createEntry.user = createEntry.user + user;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetItemFileObject(PerformanceLogger.PerformanceEvent event) {
        Item item = (Item)event.getSource();
        long time = event.getTime();
        String path = item.getAbsPath();
        if (event.getAttrs().length == 0) {
            LOG.log(timeOutLevel, "Timeout {0}s of find file object {1}", new Object[]{time / 1000000000L, path});
            return;
        }
        String dirName = CndPathUtilities.getDirName((String)path);
        if (this.isNotNormalized(dirName)) {
            return;
        }
        long cpu = event.getCpuTime();
        long user = event.getUserTime();
        this.lock.writeLock().lock();
        try {
            CreateEntry entry = this.createPerformance.get(dirName);
            if (entry == null) {
                entry = new CreateEntry();
                this.createPerformance.put(dirName, entry);
            }
            entry.number++;
            CreateEntry createEntry = entry;
            createEntry.time = createEntry.time + time;
            createEntry = entry;
            createEntry.cpu = createEntry.cpu + cpu;
            createEntry = entry;
            createEntry.user = createEntry.user + user;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRead(PerformanceLogger.PerformanceEvent event) {
        FileObject fo = (FileObject)event.getSource();
        long time = event.getTime();
        if (event.getAttrs().length == 0) {
            return;
        }
        String dirName = CndPathUtilities.getDirName((String)fo.getPath());
        if (this.isNotNormalized(dirName)) {
            return;
        }
        int readChars = (Integer)event.getAttrs()[0];
        int readLines = (Integer)event.getAttrs()[1];
        long cpu = event.getCpuTime();
        long user = event.getUserTime();
        this.lock.writeLock().lock();
        try {
            ReadEntry entry = this.readPerformance.get(dirName);
            if (entry == null) {
                entry = new ReadEntry();
                this.readPerformance.put(dirName, entry);
            }
            entry.number++;
            ReadEntry readEntry = entry;
            readEntry.read = readEntry.read + (long)readChars;
            readEntry = entry;
            readEntry.lines = readEntry.lines + (long)readLines;
            readEntry = entry;
            readEntry.time = readEntry.time + time;
            readEntry = entry;
            readEntry.cpu = readEntry.cpu + cpu;
            readEntry = entry;
            readEntry.user = readEntry.user + user;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParse(PerformanceLogger.PerformanceEvent event) {
        FileObject fo = (FileObject)event.getSource();
        long time = event.getTime();
        long cpu = event.getCpuTime();
        if (event.getAttrs().length == 0) {
            if (time > cpu && cpu > 0L) {
                if (time / cpu < 5L) {
                    LOG.log(timeOutLevel, "Timeout {0}s of parsing file {1}. The parsing already consumes {2}s CPU time", new Object[]{time / 1000000000L, fo.getPath(), cpu / 1000000000L});
                } else {
                    LOG.log(timeOutLevel, "Timeout {0}s of parsing file {1}. The parsing spends {2}s on waiting resources.", new Object[]{time / 1000000000L, fo.getPath(), (time - cpu) / 1000000000L});
                }
            } else {
                LOG.log(timeOutLevel, "Timeout {0}s of parsing file {1}", new Object[]{time / 1000000000L, fo.getPath()});
            }
            this.lock.writeLock().lock();
            try {
                this.parseTimeOut.put(fo, event);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return;
        }
        String dirName = CndPathUtilities.getDirName((String)fo.getPath());
        if (this.isNotNormalized(dirName)) {
            return;
        }
        int readLines = (Integer)event.getAttrs()[0];
        long user = event.getUserTime();
        this.lock.writeLock().lock();
        try {
            this.parseTimeOut.remove(fo);
            ParseEntry entry = this.parsePerformance.get(dirName);
            if (entry == null) {
                entry = new ParseEntry();
                this.parsePerformance.put(dirName, entry);
            }
            entry.number++;
            ParseEntry parseEntry = entry;
            parseEntry.lines = parseEntry.lines + (long)readLines;
            parseEntry = entry;
            parseEntry.time = parseEntry.time + time;
            parseEntry = entry;
            parseEntry.cpu = parseEntry.cpu + cpu;
            parseEntry = entry;
            parseEntry.user = parseEntry.user + user;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void processParseFinished(Lookup.Provider makeProject) {
        this.lock.writeLock().lock();
        try {
            if (this.fullAnalyze.get() == 0) {
                this.fullAnalyze.set(1);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canNotify() {
        ArrayList<Project> list = new ArrayList<Project>();
        Set<Project> set = this.projects;
        synchronized (set) {
            list.addAll(this.projects);
        }
        if (list.size() > 1) {
            return false;
        }
        for (Project project : list) {
            RemoteProject remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
            if (remoteProject == null) continue;
            ExecutionEnvironment developmentHost = remoteProject.getDevelopmentHost();
            if (developmentHost != null && developmentHost.isRemote()) {
                return false;
            }
            ExecutionEnvironment sourceFileSystemHost = remoteProject.getSourceFileSystemHost();
            if (!sourceFileSystemHost.isRemote()) continue;
            return false;
        }
        return true;
    }

    private boolean alreadyNotified() {
        return this.slowFileRead || this.slowItemCreation || this.slowParsed;
    }

    private void notifyProblem(final int problem, final String details) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyProjectProblem.showNotification(PerformanceIssueDetector.this, problem, details);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze() {
        boolean doFullAnalyze = false;
        TreeMap<String, AnalyzeStat.AgregatedStat> gatherStat = null;
        this.lock.writeLock().lock();
        try {
            if (this.fullAnalyze.get() == 1) {
                doFullAnalyze = true;
                this.fullAnalyze.set(2);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lock.readLock().lock();
        try {
            this.analyzeCreateItems();
            this.analyzeInfiniteCreateFile();
            this.analyzeReadFile();
            this.analyzeParseFile();
            this.analyzeInfiniteParseFile();
            if (doFullAnalyze) {
                gatherStat = this.gatherStat();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (gatherStat != null) {
            AnalyzeStat.upEmptyFolder(gatherStat);
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : AnalyzeStat.getBigUnused(gatherStat)) {
                LOG.log(Level.INFO, "Unused folder {0} contains {1} items and consumes {2}s.", new Object[]{entry.getKey(), PerformanceIssueDetector.format(entry.getValue().itemNumber), PerformanceIssueDetector.format(entry.getValue().itemTime / 1000000000L)});
            }
            AnalyzeStat.groupByReadingSpeed(gatherStat);
            AnalyzeStat.dumpAll(gatherStat);
            int i = 0;
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : AnalyzeStat.getSlowReading(gatherStat)) {
                LOG.log(Level.INFO, "Slow reading files in the folder {0}. Reading {1} lines consumes {2}s.", new Object[]{entry.getKey(), PerformanceIssueDetector.format(entry.getValue().readLines), PerformanceIssueDetector.format(entry.getValue().readTime / 1000000000L)});
                if (++i <= 5) continue;
                break;
            }
        }
    }

    TreeMap<String, AnalyzeStat.AgregatedStat> getStatistic() {
        this.lock.readLock().lock();
        try {
            TreeMap<String, AnalyzeStat.AgregatedStat> treeMap = this.gatherStat();
            return treeMap;
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            TreeMap<String, AnalyzeStat.AgregatedStat> treeMap = null;
            return treeMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    Map<FileObject, PerformanceLogger.PerformanceEvent> getParseTimeout() {
        this.lock.readLock().lock();
        try {
            HashMap<FileObject, PerformanceLogger.PerformanceEvent> hashMap = new HashMap<FileObject, PerformanceLogger.PerformanceEvent>(this.parseTimeOut);
            return hashMap;
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            Map<FileObject, PerformanceLogger.PerformanceEvent> map = null;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private TreeMap<String, AnalyzeStat.AgregatedStat> gatherStat() {
        AnalyzeStat.AgregatedStat state;
        TreeMap<String, AnalyzeStat.AgregatedStat> map = new TreeMap<String, AnalyzeStat.AgregatedStat>();
        for (Map.Entry<String, CreateEntry> entry : this.createPerformance.entrySet()) {
            state = (AnalyzeStat.AgregatedStat)map.get(entry.getKey());
            if (state == null) {
                state = new AnalyzeStat.AgregatedStat();
                map.put(entry.getKey(), state);
            }
            state.itemNumber = entry.getValue().number;
            state.itemTime = entry.getValue().time;
            state.itemCPU = entry.getValue().cpu;
            state.itemUser = entry.getValue().user;
        }
        for (Map.Entry<String, Object> entry : this.readPerformance.entrySet()) {
            state = (AnalyzeStat.AgregatedStat)map.get(entry.getKey());
            if (state == null) {
                state = new AnalyzeStat.AgregatedStat();
                map.put(entry.getKey(), state);
            }
            state.readNumber = ((ReadEntry)entry.getValue()).number;
            state.readBytes = ((ReadEntry)entry.getValue()).read;
            state.readLines = ((ReadEntry)entry.getValue()).lines;
            state.readTime = ((ReadEntry)entry.getValue()).time;
            state.readCPU = ((ReadEntry)entry.getValue()).cpu;
            state.readUser = ((ReadEntry)entry.getValue()).user;
        }
        for (Map.Entry<String, Object> entry : this.parsePerformance.entrySet()) {
            state = map.get(entry.getKey());
            if (state == null) {
                state = new AnalyzeStat.AgregatedStat();
                map.put(entry.getKey(), state);
            }
            state.parseNumber = ((ParseEntry)entry.getValue()).number;
            state.parseLines = ((ParseEntry)entry.getValue()).lines;
            state.parseTime = ((ParseEntry)entry.getValue()).time;
            state.parseCPU = ((ParseEntry)entry.getValue()).cpu;
            state.parseUser = ((ParseEntry)entry.getValue()).user;
        }
        return map;
    }

    private void analyzeCreateItems() {
        long itemCount = 0L;
        long time = 0L;
        long cpu = 0L;
        long user = 0L;
        for (Map.Entry<String, CreateEntry> entry : this.createPerformance.entrySet()) {
            itemCount += (long)entry.getValue().number;
            time += entry.getValue().time;
            cpu += entry.getValue().cpu;
            user += entry.getValue().user;
        }
        if (time <= 0L) {
            return;
        }
        long wallTime = time / 1000000000L;
        long creationSpeed = itemCount * 1000000000L / time;
        if (wallTime > 15L && itemCount > 100L && creationSpeed < 100L && !this.alreadyNotified()) {
            this.slowItemCreation = true;
            String details = Bundle.Details_slow_item_creation(PerformanceIssueDetector.format(wallTime), PerformanceIssueDetector.format(itemCount), PerformanceIssueDetector.format(creationSpeed), PerformanceIssueDetector.format(100L));
            if (!CndUtils.isUnitTestMode() && !CndUtils.isStandalone() && this.canNotify()) {
                this.notifyProblem(1, details);
            }
            details = details.replace("<br>", "").replace("\n", " ");
            LOG.log(Level.INFO, "Slow File System Detected. {0}", details);
        }
        LOG.log(level, "Average item creatoin speed is {0} item/s Created {1} items Time {2} ms CPU {3} ms User {4} ms", new Object[]{PerformanceIssueDetector.format(creationSpeed), PerformanceIssueDetector.format(itemCount), PerformanceIssueDetector.format(time / 1000000L), PerformanceIssueDetector.format(cpu / 1000000L), PerformanceIssueDetector.format(user / 1000000L)});
    }

    private void analyzeInfiniteCreateFile() {
        int INFINITE_CREATE_ITEM_TIMOUT = 30;
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<FileObject, PerformanceLogger.PerformanceEvent>> iterator = this.createFOTimeOut.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FileObject, PerformanceLogger.PerformanceEvent> entry = iterator.next();
            FileObject fo = entry.getKey();
            PerformanceLogger.PerformanceEvent event = entry.getValue();
            long delta = (System.nanoTime() - event.getStartTime()) / 1000000000L;
            if (delta <= (long)INFINITE_CREATE_ITEM_TIMOUT) continue;
            iterator.remove();
            buf.append(Bundle.Details_infinite_item_creation(fo.getPath(), PerformanceIssueDetector.format(delta)));
            LOG.log(Level.INFO, "Too Long File Access Detected. Access to file {0} consumes more than {1}s.", new Object[]{fo.getPath(), PerformanceIssueDetector.format(delta)});
        }
        Iterator<Map.Entry<File, PerformanceLogger.PerformanceEvent>> iterator2 = this.createFileTimeOut.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<File, PerformanceLogger.PerformanceEvent> entry = iterator2.next();
            File fo = entry.getKey();
            PerformanceLogger.PerformanceEvent event = entry.getValue();
            long delta = (System.nanoTime() - event.getStartTime()) / 1000000000L;
            if (delta <= (long)INFINITE_CREATE_ITEM_TIMOUT) continue;
            iterator2.remove();
            buf.append(Bundle.Details_infinite_item_creation(fo.getPath(), PerformanceIssueDetector.format(delta)));
            LOG.log(Level.INFO, "Too Long File Access Detected. Access to file {0} consumes more than {1}s.", new Object[]{fo.getPath(), PerformanceIssueDetector.format(delta)});
        }
        Iterator<Map.Entry<String, PerformanceLogger.PerformanceEvent>> iterator3 = this.createItemTimeOut.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<String, PerformanceLogger.PerformanceEvent> entry = iterator3.next();
            String fo = entry.getKey();
            PerformanceLogger.PerformanceEvent event = entry.getValue();
            long delta = (System.nanoTime() - event.getStartTime()) / 1000000000L;
            if (delta <= (long)INFINITE_CREATE_ITEM_TIMOUT) continue;
            iterator3.remove();
            buf.append(Bundle.Details_infinite_item_creation(fo, PerformanceIssueDetector.format(delta)));
            LOG.log(Level.INFO, "Too Long File Access Detected. Access to file {0} consumes more than {1}s.", new Object[]{fo, PerformanceIssueDetector.format(delta)});
        }
        if (buf.length() > 0 && !this.alreadyNotified()) {
            this.slowItemCreation = true;
            if (!CndUtils.isUnitTestMode() && !CndUtils.isStandalone() && this.canNotify()) {
                this.notifyProblem(2, Bundle.Details_infinite_items_creation(buf.toString()));
            }
        }
    }

    private void analyzeReadFile() {
        long fileCount = 0L;
        long read = 0L;
        long lines = 0L;
        long time = 0L;
        long cpu = 0L;
        long user = 0L;
        for (Map.Entry<String, ReadEntry> entry : this.readPerformance.entrySet()) {
            fileCount += (long)entry.getValue().number;
            read += entry.getValue().read;
            lines += entry.getValue().lines;
            time += entry.getValue().time;
            cpu += entry.getValue().cpu;
            user += entry.getValue().user;
        }
        if (time <= 0L) {
            return;
        }
        long wallTime = time / 1000000000L;
        long readSpeed = read * 1000L * 1000L / time;
        if (wallTime > 100L && fileCount > 100L && readSpeed < 100L && !this.alreadyNotified()) {
            this.slowFileRead = true;
            String details = Bundle.Details_slow_file_read(PerformanceIssueDetector.format(wallTime), PerformanceIssueDetector.format(read / 1000L), PerformanceIssueDetector.format(readSpeed), PerformanceIssueDetector.format(100L));
            if (!CndUtils.isUnitTestMode() && !CndUtils.isStandalone() && this.canNotify()) {
                this.notifyProblem(3, details);
            }
            details = details.replace("<br>", "").replace("\n", " ");
            LOG.log(Level.INFO, "Slow File System Detected. {0}", details);
        }
        LOG.log(level, "Average file reading speed is {0} Kb/s Read {1} Kb Time {2} ms CPU {3} ms User {4} ms", new Object[]{PerformanceIssueDetector.format(readSpeed), PerformanceIssueDetector.format(read / 1000L), PerformanceIssueDetector.format(time / 1000000L), PerformanceIssueDetector.format(cpu / 1000000L), PerformanceIssueDetector.format(user / 1000000L)});
    }

    private void analyzeParseFile() {
        long fileCount = 0L;
        long lines = 0L;
        long time = 0L;
        long cpu = 0L;
        long user = 0L;
        for (Map.Entry<String, ParseEntry> entry : this.parsePerformance.entrySet()) {
            fileCount += (long)entry.getValue().number;
            lines += entry.getValue().lines;
            time += entry.getValue().time;
            cpu += entry.getValue().cpu;
            user += entry.getValue().user;
        }
        if (time <= 0L) {
            return;
        }
        long wallTime = time / 1000000000L;
        long cpuTime = cpu / 1000000000L;
        if (wallTime <= 0L) {
            return;
        }
        long parseSpeed = lines / wallTime;
        if (cpuTime > 1L) {
            long k = time / cpu;
            if (wallTime > 100L && fileCount > 100L && parseSpeed < 1000L && k > 5L && !this.alreadyNotified()) {
                this.slowParsed = true;
                String details = Bundle.Details_slow_file_parse(PerformanceIssueDetector.format(wallTime), PerformanceIssueDetector.format(lines), PerformanceIssueDetector.format(parseSpeed), PerformanceIssueDetector.format(cpuTime), PerformanceIssueDetector.format(k), PerformanceIssueDetector.format(5L));
                if (!CndUtils.isUnitTestMode() && !CndUtils.isStandalone() && this.canNotify()) {
                    this.notifyProblem(4, details);
                }
                details = details.replace("<br>", "").replace("\n", " ");
                LOG.log(Level.INFO, "Slow File System Detected. {0}", details);
            }
        }
        LOG.log(level, "Average parsing speed is {0} Lines/s Lines {1} Time {2} ms CPU {3} ms User {4} ms", new Object[]{PerformanceIssueDetector.format(parseSpeed), PerformanceIssueDetector.format(lines), PerformanceIssueDetector.format(time / 1000000L), PerformanceIssueDetector.format(cpu / 1000000L), PerformanceIssueDetector.format(user / 1000000L)});
    }

    private void analyzeInfiniteParseFile() {
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<FileObject, PerformanceLogger.PerformanceEvent>> iterator = this.parseTimeOut.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FileObject, PerformanceLogger.PerformanceEvent> entry = iterator.next();
            FileObject fo = entry.getKey();
            PerformanceLogger.PerformanceEvent event = entry.getValue();
            long delta = (System.nanoTime() - event.getStartTime()) / 1000000000L;
            if (delta <= 100L) continue;
            iterator.remove();
            long time = event.getTime();
            long cpu = event.getCpuTime();
            if (event.getAttrs().length != 0 || time <= cpu || cpu <= 0L || time / cpu >= 5L) continue;
            buf.append(Bundle.Details_infinite_file_parse(fo.getPath(), PerformanceIssueDetector.format(delta)));
            LOG.log(Level.INFO, "Too long file {0} parsing time {1}s. Probably parser has infinite loop or file is too big", new Object[]{fo.getPath(), PerformanceIssueDetector.format(delta)});
        }
        if (buf.length() > 0 && !CndUtils.isUnitTestMode() && !CndUtils.isStandalone() && this.canNotify()) {
            String details = Bundle.Details_infinite_files_parse(buf.toString());
            this.notifyProblem(5, details);
        }
    }

    static String format(long val) {
        String res = Long.toString(val);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < res.length(); ++i) {
            char c = res.charAt(res.length() - i - 1);
            if (i % 3 == 0 && i > 0) {
                buf.insert(0, ',');
            }
            buf.insert(0, c);
        }
        return buf.toString();
    }

    public void projectParsingStarted(CsmProject project) {
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
    }

    public void projectParsingFinished(CsmProject project) {
        Object platformProject = project.getPlatformProject();
        if (platformProject instanceof NativeProject) {
            Lookup.Provider makeProject = ((NativeProject)platformProject).getProject();
            this.processParseFinished(makeProject);
        }
    }

    public void projectParsingCancelled(CsmProject project) {
    }

    public void projectLoaded(CsmProject project) {
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
    }

    public void fileParsingStarted(CsmFile file) {
    }

    public void fileParsingFinished(CsmFile file) {
    }

    public void parserIdle() {
    }

    public void fileRemoved(CsmFile file) {
    }

    private static final class ParseEntry {
        private int number;
        private long lines;
        private long time;
        private long cpu;
        private long user;

        private ParseEntry() {
        }
    }

    private static final class ReadEntry {
        private int number;
        private long read;
        private long lines;
        private long time;
        private long cpu;
        private long user;

        private ReadEntry() {
        }
    }

    private static final class CreateEntry {
        private int number;
        private long time;
        private long cpu;
        private long user;

        private CreateEntry() {
        }
    }
}

