/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(dvec4(-2.0lf, -1.4285714285714286lf, -0.85714285714285721lf, -0.28571428571428581lf)) => dvec4(-2.0lf, -1.0lf, -0.0lf, -0.0lf)
 * trunc(dvec4(0.28571428571428559lf, 0.85714285714285676lf, 1.4285714285714284lf, 2.0lf)) => dvec4(0.0lf, 0.0lf, 1.0lf, 2.0lf)
 * trunc(dvec4(0.0lf, 45027112.984140001lf, -45027112.984140001lf, 19584198736.473289lf)) => dvec4(0.0lf, 45027112.0lf, -45027112.0lf, 19584198736.0lf)
 * trunc(dvec4(-19584198736.473289lf, 7.5165416231900006e+17lf, -7.5165416231900006e+17lf, 4.5027112340958568e+19lf)) => dvec4(-19584198736.0lf, 7.5165416231900006e+17lf, -7.5165416231900006e+17lf, 4.5027112340958568e+19lf)
 * trunc(dvec4(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf, -8.6541968133854552e+39lf, 6.5496516851365496e+83lf)) => dvec4(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf, -8.6541968133854552e+39lf, 6.5496516851365496e+83lf)
 * trunc(dvec4(-6.5496516851365496e+83lf, -2.0lf, -1.4285714285714286lf, -0.85714285714285721lf)) => dvec4(-6.5496516851365496e+83lf, -2.0lf, -1.0lf, -0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(trunc(dvec4(-2.0lf, -1.4285714285714286lf, -0.85714285714285721lf, -0.28571428571428581lf)), dvec4(-2.0lf, -1.0lf, -0.0lf, -0.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array0;
  double[distance(trunc(dvec4(0.28571428571428559lf, 0.85714285714285676lf, 1.4285714285714284lf, 2.0lf)), dvec4(0.0lf, 0.0lf, 1.0lf, 2.0lf)) <= 2.2360679774997898e-05lf ? 1 : -1] array1;
  double[distance(trunc(dvec4(0.0lf, 45027112.984140001lf, -45027112.984140001lf, 19584198736.473289lf)), dvec4(0.0lf, 45027112.0lf, -45027112.0lf, 19584198736.0lf)) <= 195843.02260044246lf ? 1 : -1] array2;
  double[distance(trunc(dvec4(-19584198736.473289lf, 7.5165416231900006e+17lf, -7.5165416231900006e+17lf, 4.5027112340958568e+19lf)), dvec4(-19584198736.0lf, 7.5165416231900006e+17lf, -7.5165416231900006e+17lf, 4.5027112340958568e+19lf)) <= 450396582327704.5lf ? 1 : -1] array3;
  double[distance(trunc(dvec4(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf, -8.6541968133854552e+39lf, 6.5496516851365496e+83lf)), dvec4(-4.5027112340958568e+19lf, 8.6541968133854552e+39lf, -8.6541968133854552e+39lf, 6.5496516851365496e+83lf)) <= 6.54965168513655e+78lf ? 1 : -1] array4;
  double[distance(trunc(dvec4(-6.5496516851365496e+83lf, -2.0lf, -1.4285714285714286lf, -0.85714285714285721lf)), dvec4(-6.5496516851365496e+83lf, -2.0lf, -1.0lf, -0.0lf)) <= 6.54965168513655e+78lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
