/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * roundEven(-2.0) => -2.0
 * roundEven(-1.8333334) => -2.0
 * roundEven(-1.6666666) => -2.0
 * roundEven(-1.5) => -2.0
 * roundEven(-1.3333334) => -1.0
 * roundEven(-1.1666666) => -1.0
 * roundEven(-1.0) => -1.0
 * roundEven(-0.83333331) => -1.0
 * roundEven(-0.66666669) => -1.0
 * roundEven(-0.5) => -0.0
 * roundEven(-0.33333334) => -0.0
 * roundEven(-0.16666667) => -0.0
 * roundEven(0.0) => 0.0
 * roundEven(0.16666667) => 0.0
 * roundEven(0.33333334) => 0.0
 * roundEven(0.5) => 0.0
 * roundEven(0.66666669) => 1.0
 * roundEven(0.83333331) => 1.0
 * roundEven(1.0) => 1.0
 * roundEven(1.1666666) => 1.0
 * roundEven(1.3333334) => 1.0
 * roundEven(1.5) => 2.0
 * roundEven(1.6666666) => 2.0
 * roundEven(1.8333334) => 2.0
 * roundEven(2.0) => 2.0
 */
#version 130

void main()
{
  float[distance(roundEven(-2.0), -2.0) <= 1.9999999e-05 ? 1 : -1] array0;
  float[distance(roundEven(-1.8333334), -2.0) <= 1.9999999e-05 ? 1 : -1] array1;
  float[distance(roundEven(-1.6666666), -2.0) <= 1.9999999e-05 ? 1 : -1] array2;
  float[distance(roundEven(-1.5), -2.0) <= 1.9999999e-05 ? 1 : -1] array3;
  float[distance(roundEven(-1.3333334), -1.0) <= 9.9999997e-06 ? 1 : -1] array4;
  float[distance(roundEven(-1.1666666), -1.0) <= 9.9999997e-06 ? 1 : -1] array5;
  float[distance(roundEven(-1.0), -1.0) <= 9.9999997e-06 ? 1 : -1] array6;
  float[distance(roundEven(-0.83333331), -1.0) <= 9.9999997e-06 ? 1 : -1] array7;
  float[distance(roundEven(-0.66666669), -1.0) <= 9.9999997e-06 ? 1 : -1] array8;
  float[distance(roundEven(-0.5), -0.0) <= 0.0 ? 1 : -1] array9;
  float[distance(roundEven(-0.33333334), -0.0) <= 0.0 ? 1 : -1] array10;
  float[distance(roundEven(-0.16666667), -0.0) <= 0.0 ? 1 : -1] array11;
  float[distance(roundEven(0.0), 0.0) <= 0.0 ? 1 : -1] array12;
  float[distance(roundEven(0.16666667), 0.0) <= 0.0 ? 1 : -1] array13;
  float[distance(roundEven(0.33333334), 0.0) <= 0.0 ? 1 : -1] array14;
  float[distance(roundEven(0.5), 0.0) <= 0.0 ? 1 : -1] array15;
  float[distance(roundEven(0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array16;
  float[distance(roundEven(0.83333331), 1.0) <= 9.9999997e-06 ? 1 : -1] array17;
  float[distance(roundEven(1.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array18;
  float[distance(roundEven(1.1666666), 1.0) <= 9.9999997e-06 ? 1 : -1] array19;
  float[distance(roundEven(1.3333334), 1.0) <= 9.9999997e-06 ? 1 : -1] array20;
  float[distance(roundEven(1.5), 2.0) <= 1.9999999e-05 ? 1 : -1] array21;
  float[distance(roundEven(1.6666666), 2.0) <= 1.9999999e-05 ? 1 : -1] array22;
  float[distance(roundEven(1.8333334), 2.0) <= 1.9999999e-05 ? 1 : -1] array23;
  float[distance(roundEven(2.0), 2.0) <= 1.9999999e-05 ? 1 : -1] array24;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length());
}
