/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) + 0.0) => vec2(-0.1, -1.2)
 * (vec2(-0.1, -1.2) + -1.33) => vec2(-1.4300001, -2.5300002)
 * (vec2(-0.1, -1.2) + 0.85000002) => vec2(0.75, -0.35000002)
 * (vec2(-0.41999999, 0.47999999) + 0.0) => vec2(-0.41999999, 0.47999999)
 * (vec2(-0.41999999, 0.47999999) + -1.33) => vec2(-1.75, -0.85000002)
 * (vec2(-0.41999999, 0.47999999) + 0.85000002) => vec2(0.43000004, 1.33)
 */
#version 150

void main()
{
  float[distance((vec2(-0.1, -1.2) + 0.0), vec2(-0.1, -1.2)) <= 1.2041595e-05 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) + -1.33), vec2(-1.4300001, -2.5300002)) <= 2.9061659e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.1, -1.2) + 0.85000002), vec2(0.75, -0.35000002)) <= 8.2764727e-06 ? 1 : -1] array2;
  float[distance((vec2(-0.41999999, 0.47999999) + 0.0), vec2(-0.41999999, 0.47999999)) <= 6.3780872e-06 ? 1 : -1] array3;
  float[distance((vec2(-0.41999999, 0.47999999) + -1.33), vec2(-1.75, -0.85000002)) <= 1.9455078e-05 ? 1 : -1] array4;
  float[distance((vec2(-0.41999999, 0.47999999) + 0.85000002), vec2(0.43000004, 1.33)) <= 1.3977839e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
