/*
 * Decompiled with CFR 0.152.
 */
package com.projity.algorithm;

import com.projity.algorithm.IntervalGenerator;
import com.projity.util.DateTime;
import java.util.GregorianCalendar;

public class RangeIntervalGenerator
implements IntervalGenerator {
    long start;
    long end;
    long step;
    int calendarStepUnit;
    int calendarStepAmount = 1;
    long currentEnd;
    long nextEnd;
    GregorianCalendar stepCal = null;

    private RangeIntervalGenerator() {
        this(0L, Long.MAX_VALUE);
    }

    private RangeIntervalGenerator(long l, long l2) {
        this.start = l;
        this.end = l2;
        this.currentEnd = l2;
        this.step = l2;
        this.nextEnd = l2 + this.step;
    }

    private RangeIntervalGenerator(long l, long l2, int n) {
        this.start = l;
        this.end = l2;
        this.calendarStepUnit = n;
        this.stepCal = new GregorianCalendar();
        this.stepCal.setTimeInMillis(l);
        this.stepCal.add(n, this.calendarStepAmount);
        this.currentEnd = this.stepCal.getTimeInMillis();
        if (this.currentEnd > l2) {
            this.currentEnd = l2;
        }
        this.stepCal.add(n, this.calendarStepAmount);
        this.nextEnd = this.stepCal.getTimeInMillis();
    }

    public static RangeIntervalGenerator betweenInstance(long l, long l2) {
        RangeIntervalGenerator rangeIntervalGenerator = RangeIntervalGenerator.getInstance(l, l2);
        rangeIntervalGenerator.currentEnd = l;
        return rangeIntervalGenerator;
    }

    public Object current() {
        return null;
    }

    public long currentEnd() {
        return this.currentEnd;
    }

    public long currentStart() {
        return this.start;
    }

    public boolean evaluate(Object object) {
        this.start = this.currentEnd;
        this.currentEnd = this.nextEnd;
        if (this.currentEnd > this.end) {
            this.currentEnd = this.end;
        }
        if (this.stepCal != null) {
            this.stepCal.add(this.calendarStepUnit, this.calendarStepAmount);
            this.nextEnd = this.stepCal.getTimeInMillis();
        } else {
            this.nextEnd += this.step;
        }
        return this.start < this.end;
    }

    public int compareTo(Object object) {
        return 0;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public static RangeIntervalGenerator continuous() {
        return RangeIntervalGenerator.getInstance(0L, DateTime.getMaxCalendar().getTimeInMillis());
    }

    public static RangeIntervalGenerator empty() {
        return RangeIntervalGenerator.getInstance(0L, 0L);
    }

    public static RangeIntervalGenerator getInstance() {
        return new RangeIntervalGenerator();
    }

    public static RangeIntervalGenerator getInstance(long l, long l2) {
        return new RangeIntervalGenerator(l, l2);
    }

    public static RangeIntervalGenerator getInstance(long l, long l2, int n) {
        return new RangeIntervalGenerator(l, l2, n);
    }

    public boolean isCurrentActive() {
        return true;
    }

    public boolean hasNext() {
        return this.nextEnd < this.end;
    }

    public boolean canBeShared() {
        return true;
    }
}

