/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.field.Field;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public final class FieldAliasDialog
extends AbstractDialog {
    JLabel defaultName;
    JLabel oldName;
    JTextField newName;
    Field field;
    String result = null;

    public static boolean doRename(Field field) {
        String string = FieldAliasDialog.getValue(field);
        if (string != null) {
            field.setAlias(string);
        }
        return true;
    }

    public static String getValue(Field field) {
        FieldAliasDialog fieldAliasDialog = FieldAliasDialog.getInstance(field);
        if (fieldAliasDialog.doModal()) {
            return fieldAliasDialog.getResult();
        }
        return null;
    }

    public static FieldAliasDialog getInstance(Field field) {
        return new FieldAliasDialog(field);
    }

    public final String getResult() {
        return this.result;
    }

    private FieldAliasDialog(Field field) {
        super(GraphicManager.getFrameInstance(), Messages.getString("RenameDialog.Rename"), true);
        this.field = field;
        this.defaultName = new JLabel();
        this.oldName = new JLabel();
        this.newName = new JTextField();
    }

    protected void initControls() {
        this.bind(true);
    }

    protected boolean bind(boolean bl) {
        if (bl) {
            this.defaultName.setText(this.field.getDefaultName());
            this.oldName.setText(this.field.getName());
            this.newName.setText(this.field.getName());
        } else {
            this.result = this.newName.getText().trim();
            if (this.result.equals(this.oldName)) {
                return true;
            }
            if (this.result.length() == 0) {
                Alert.warn(Messages.getString("RenameDialog.TheNameCannotBeEmpty"), this);
                return false;
            }
        }
        return true;
    }

    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("default, 3dlu, 120dlu:grow", "p, 3dlu,p,3dlu,p,3dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.append(Messages.getString("Field.name"), (Component)this.defaultName);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("RenameDialog.CurrentName"), (Component)this.oldName);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("RenameDialog.NewName"), (Component)this.newName);
        return defaultFormBuilder.getPanel();
    }
}

