/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.configuration.FieldDictionary;
import com.projity.dialog.InformationDialog;
import com.projity.dialog.util.FieldComponentMap;
import com.projity.document.ObjectEvent;
import com.projity.pm.graphic.frames.DocumentSelectedEvent;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projity.pm.resource.Resource;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.awt.Component;
import java.awt.Frame;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class ProjectInformationDialog
extends InformationDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;

    public static ProjectInformationDialog getInstance(Frame frame, Project project) {
        return new ProjectInformationDialog(frame, project);
    }

    private ProjectInformationDialog(Frame frame, Project project) {
        super(frame, Messages.getString("ProjectInformationDialog.ProjectInformation"));
        this.setObjectClass(Project.class);
        this.setObject(project);
        this.addDocHelp("Project_Information_Dialog");
    }

    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("350dlu:grow", "fill:250dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Messages.getString("ProjectInformationDialog.General"), this.createGeneralPanel());
        this.tabbedPane.addTab(Messages.getString("ProjectInformationDialog.Statistics"), this.createStatisticsPanel());
        this.tabbedPane.addTab(Messages.getString("ProjectInformationDialog.Notes"), this.createNotesPanel());
        defaultFormBuilder.add(this.tabbedPane);
        this.mainComponent = this.tabbedPane;
        return defaultFormBuilder.getPanel();
    }

    private JComponent createGeneralPanel() {
        LinkedList linkedList;
        JComponent jComponent;
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("max(50dlu;pref), 3dlu, 90dlu, 10dlu, p, 3dlu,max(90dlu;pref),60dlu", "p,3dlu,p, 3dlu,p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu,p,3dlu,p,3dlu,p, 3dlu,p,3dlu,p, 6dlu, fill:50dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 8));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.manager");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendSometimesReadOnly(defaultFormBuilder, "Field.startDate");
        fieldComponentMap.append(defaultFormBuilder, "Field.currentDate");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendSometimesReadOnly(defaultFormBuilder, "Field.finishDate");
        fieldComponentMap.append(defaultFormBuilder, "Field.statusDate");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.forward");
        defaultFormBuilder.nextColumn(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.baseCalendar");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.priority");
        fieldComponentMap.append(defaultFormBuilder, "Field.projectStatus");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.projectType");
        fieldComponentMap.append(defaultFormBuilder, "Field.expenseType");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.projectDivision");
        fieldComponentMap.append(defaultFormBuilder, "Field.projectGroup");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.netPresentValue");
        fieldComponentMap.append(defaultFormBuilder, "Field.benefit");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.append(defaultFormBuilder, "Field.risk");
        defaultFormBuilder.nextLine(2);
        if (!Environment.getStandAlone()) {
            fieldComponentMap.append(defaultFormBuilder, "Field.accessControlPolicy", 3);
            defaultFormBuilder.nextLine(2);
        }
        if ((jComponent = this.createFieldsPanel(fieldComponentMap, linkedList = FieldDictionary.extractExtraFields(FieldDictionary.getInstance().getProjectFields(), false))) != null) {
            defaultFormBuilder.add((Component)jComponent, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 7));
        }
        return defaultFormBuilder.getPanel();
    }

    private JComponent createStatisticsPanel() {
        FieldComponentMap fieldComponentMap = this.createMap();
        FormLayout formLayout = new FormLayout("p, 3dlu, 50dlu, 20dlu, p, 3dlu, 50dlu:grow", "p, 3dlu, p, 3dlu,p, 3dlu, p, 10dlu, p,3dlu,p, 10dlu, p, 3dlu, p, 10dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.add((Component)this.createHeaderFieldsPanel(fieldComponentMap), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 7));
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.startDate");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.finishDate");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.baselineStart");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.baselineFinish");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.actualStart");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.actualFinish");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.duration");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.baselineDuration");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.actualDuration");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.remainingDuration");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.work");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.baselineWork");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.actualWork");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.remainingWork");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.cost");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.baselineCost");
        defaultFormBuilder.nextLine(2);
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.actualCost");
        fieldComponentMap.appendReadOnly(defaultFormBuilder, "Field.remainingCost");
        return defaultFormBuilder.getPanel();
    }

    protected JComponent createHeaderFieldsPanel(FieldComponentMap fieldComponentMap) {
        FormLayout formLayout = new FormLayout("p, 3dlu, 300dlu", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        fieldComponentMap.append(defaultFormBuilder, "Field.name");
        return defaultFormBuilder.getPanel();
    }

    public void documentSelected(DocumentSelectedEvent documentSelectedEvent) {
        this.setObject(documentSelectedEvent.getCurrent().getProject());
        this.updateAll();
    }

    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
    }

    public void objectChanged(ObjectEvent objectEvent) {
        if (!this.isVisible()) {
            return;
        }
        Object object = objectEvent.getObject();
        Project project = (Project)this.getObject();
        boolean bl = false;
        if (object == this.getObject()) {
            bl = true;
        } else if (object instanceof Task) {
            if (((Task)object).getProject() == project) {
                bl = true;
            }
        } else if (object instanceof Resource && ((Resource)object).getDocument() == project.getResourcePool()) {
            bl = true;
        }
        if (bl) {
            this.updateAll();
        }
    }

    public void setObject(Object object) {
        super.setObject(object);
        if (object != null) {
            this.updateAll();
        }
    }
}

