/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.configuration.Configuration;
import com.projity.field.Field;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.pm.graphic.spreadsheet.editor.MoneyEditor;
import com.projity.pm.graphic.spreadsheet.editor.RateEditor;
import com.projity.pm.graphic.spreadsheet.editor.SimpleComboBoxEditor;
import com.projity.pm.graphic.spreadsheet.editor.SimpleEditor;
import com.projity.pm.graphic.spreadsheet.editor.SpinEditor;
import com.projity.pm.graphic.spreadsheet.editor.SpreadSheetCellEditorAdapter;
import com.projity.pm.graphic.spreadsheet.renderer.DateRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.IndicatorsRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.LookupRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.OfflineCapableBooleanRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.PercentRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.RateRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.SimpleRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.SpreadSheetCellRendererAdapter;
import com.projity.pm.graphic.spreadsheet.renderer.SpreadSheetColumnHeaderRenderer;
import com.projity.pm.graphic.spreadsheet.renderer.SpreadSheetNameCellRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadSheetColumnModel
extends DefaultTableColumnModel {
    int columnIndex = 0;
    int colWidth = 0;
    private ArrayList fieldArray;
    private ArrayList originalFieldArray;
    private Map<String, Integer> colWidthMap;
    boolean svg;

    public SpreadSheetColumnModel(ArrayList arrayList) {
        this(arrayList, null);
    }

    public SpreadSheetColumnModel(ArrayList arrayList, List<Integer> list) {
        this.setFieldArray(arrayList);
        this.colWidthMap = new HashMap<String, Integer>();
        if (arrayList instanceof SpreadSheetFieldArray) {
            SpreadSheetFieldArray spreadSheetFieldArray = (SpreadSheetFieldArray)arrayList;
            if (list == null && spreadSheetFieldArray != null && spreadSheetFieldArray.getWidths() != null && spreadSheetFieldArray.getWidths().size() > 0) {
                list = spreadSheetFieldArray.getWidths();
            }
            if (list == null) {
                return;
            }
            Iterator iterator = spreadSheetFieldArray.iterator();
            Iterator<Integer> iterator2 = list.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                String string = ((Field)iterator.next()).getId();
                int n = iterator2.next();
                if (this.colWidthMap.containsKey(string)) continue;
                this.colWidthMap.put(string, n);
            }
        }
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        tableColumn.setHeaderRenderer(new SpreadSheetColumnHeaderRenderer());
        if (this.columnIndex == 0) {
            Field field = (Field)this.originalFieldArray.get(this.columnIndex);
            tableColumn.setIdentifier(field);
            tableColumn.setPreferredWidth(0);
            this.colWidth = 0;
        } else {
            super.addColumn(tableColumn);
            Field field = (Field)this.originalFieldArray.get(this.columnIndex);
            tableColumn.setIdentifier(field);
            if (field.isNameField()) {
                tableColumn.setPreferredWidth(this.svg ? 170 : 150);
                tableColumn.setCellRenderer(new SpreadSheetNameCellRenderer());
                tableColumn.setCellEditor(new SpreadSheetCellEditorAdapter(new SimpleEditor(String.class)));
            } else if (field == Configuration.getFieldFromId("Field.indicators")) {
                tableColumn.setPreferredWidth(50);
                tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new IndicatorsRenderer()));
                tableColumn.setHeaderRenderer(new SpreadSheetColumnHeaderRenderer(IndicatorsRenderer.getCellHeader()));
            } else if (field.getLookupTypes() != null) {
                tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new LookupRenderer()));
            } else {
                tableColumn.setPreferredWidth(150);
                if (field.hasOptions()) {
                    tableColumn.setPreferredWidth(150);
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new SimpleRenderer()));
                    tableColumn.setCellEditor(new SpreadSheetCellEditorAdapter(new SimpleComboBoxEditor(new DefaultComboBoxModel<Object>(field.getOptions(null)))));
                } else if (field.getRange() != null) {
                    if (field.isPercent()) {
                        tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new PercentRenderer()));
                    } else {
                        tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new SimpleRenderer()));
                    }
                    tableColumn.setCellEditor(new SpreadSheetCellEditorAdapter(new SpinEditor(field)));
                } else if (field.isRate()) {
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new RateRenderer()));
                    tableColumn.setCellEditor(new SpreadSheetCellEditorAdapter(new RateEditor(null, field.isMoney(), field.isPercent(), true)));
                } else if (field.isMoney()) {
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new SimpleRenderer()));
                    tableColumn.setCellEditor(new SpreadSheetCellEditorAdapter(new MoneyEditor()));
                } else if (field.isPercent()) {
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new PercentRenderer()));
                } else if (field.isDate()) {
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new DateRenderer()));
                } else if (field.isBoolean()) {
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new OfflineCapableBooleanRenderer()));
                } else {
                    tableColumn.setCellRenderer(new SpreadSheetCellRendererAdapter(new SimpleRenderer()));
                    tableColumn.setPreferredWidth(field.getColumnWidth(this.svg));
                }
            }
            Integer n = this.colWidthMap.get(field.getId());
            if (n == null || n <= 0) {
                this.colWidthMap.put(field.getId(), tableColumn.getPreferredWidth());
            } else {
                tableColumn.setPreferredWidth(n);
            }
            this.colWidth += tableColumn.getPreferredWidth();
        }
        ++this.columnIndex;
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        --this.columnIndex;
        super.removeColumn(tableColumn);
        if (this.columnIndex == 1) {
            this.columnIndex = 0;
        }
    }

    @Override
    public void moveColumn(int n, int n2) {
        if (n2 != -1) {
            super.moveColumn(n, n2);
        }
        if (n == n2) {
            return;
        }
        SpreadSheetFieldArray spreadSheetFieldArray = (SpreadSheetFieldArray)this.getFieldArray();
        this.fieldArray = spreadSheetFieldArray.move(n + 1, n2 + 1);
    }

    public ArrayList getFieldArray() {
        return this.fieldArray;
    }

    public void setFieldArray(ArrayList arrayList) {
        this.fieldArray = arrayList;
        this.originalFieldArray = (ArrayList)arrayList.clone();
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public boolean isSvg() {
        return this.svg;
    }

    public void setSvg(boolean bl) {
        this.svg = bl;
    }

    public Field getFieldInNonTranslatedColumn(int n) {
        return (Field)this.fieldArray.get(n);
    }

    public Field getFieldInColumn(int n) {
        return (Field)this.originalFieldArray.get(n);
    }

    public int findFieldColumn(Field field) {
        return this.originalFieldArray.indexOf(field);
    }

    public int getFieldColumnCount() {
        return this.getFieldArray().size();
    }
}

