/*
 * Decompiled with CFR 0.152.
 */
package com.projity.reports.adapter;

import com.projity.configuration.ReportColumns;
import com.projity.configuration.ReportDefinition;
import com.projity.field.Field;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ReportAdapter {
    private static String GroupName = "group";
    private ReportDefinition reportDefinition;
    private JRDesignReportFont boldFont;
    private JRDesignReportFont italicFont;
    private JRDesignReportFont normalFont;
    private boolean hasAggregableField = false;
    private JasperDesign jasperDesign = new JasperDesign();

    public ReportAdapter(ReportDefinition reportDefinition) {
        this.reportDefinition = reportDefinition;
    }

    private boolean isAggregable(Field field) {
        return 3 == field.getSummaryForGroup();
    }

    private int neededWidth(SpreadSheetFieldArray spreadSheetFieldArray) {
        int n = 0;
        for (Field field : spreadSheetFieldArray) {
            n += field.getColumnWidth();
        }
        return n;
    }

    private void generateBaseDesign() throws JRException {
        if (this.reportDefinition.isTimeBased()) {
            this.jasperDesign.setProperty("timeBased", "true");
        }
        this.jasperDesign.setProperty("collectionType", new Integer(this.reportDefinition.getCollectionType()).toString());
        this.jasperDesign.setName(this.reportDefinition.getName());
        this.jasperDesign.setPageWidth(1008);
        this.jasperDesign.setPageHeight(612);
        this.jasperDesign.setColumnWidth(968);
        this.jasperDesign.setColumnSpacing(0);
        this.jasperDesign.setLeftMargin(20);
        this.jasperDesign.setRightMargin(20);
        this.jasperDesign.setTopMargin(30);
        this.jasperDesign.setBottomMargin(30);
        this.normalFont = new JRDesignReportFont();
        this.normalFont.setName("Arial_Normal");
        this.normalFont.setDefault(true);
        this.normalFont.setFontName("Arial");
        this.normalFont.setSize(10);
        this.normalFont.setPdfFontName("Helvetica");
        this.normalFont.setPdfEncoding("Cp1252");
        this.normalFont.setPdfEmbedded(false);
        this.jasperDesign.addFont((JRReportFont)this.normalFont);
        this.boldFont = new JRDesignReportFont();
        this.boldFont.setName("Arial_Bold");
        this.boldFont.setDefault(false);
        this.boldFont.setFontName("Arial");
        this.boldFont.setSize(12);
        this.boldFont.setBold(true);
        this.boldFont.setPdfFontName("Helvetica-Bold");
        this.boldFont.setPdfEncoding("Cp1252");
        this.boldFont.setPdfEmbedded(false);
        this.jasperDesign.addFont((JRReportFont)this.boldFont);
        this.italicFont = new JRDesignReportFont();
        this.italicFont.setName("Arial_Italic");
        this.italicFont.setDefault(false);
        this.italicFont.setFontName("Arial");
        this.italicFont.setSize(12);
        this.italicFont.setItalic(true);
        this.italicFont.setPdfFontName("Helvetica-Oblique");
        this.italicFont.setPdfEncoding("Cp1252");
        this.italicFont.setPdfEmbedded(false);
        this.jasperDesign.addFont((JRReportFont)this.italicFont);
        JRDesignBand jRDesignBand = new JRDesignBand();
        jRDesignBand.setHeight(50);
        JRDesignLine jRDesignLine = new JRDesignLine();
        jRDesignLine.setX(0);
        jRDesignLine.setY(0);
        jRDesignLine.setWidth(968);
        jRDesignLine.setHeight(0);
        jRDesignBand.addElement((JRDesignElement)jRDesignLine);
        JRDesignStaticText jRDesignStaticText = new JRDesignStaticText();
        jRDesignStaticText.setX(0);
        jRDesignStaticText.setY(10);
        jRDesignStaticText.setWidth(968);
        jRDesignStaticText.setHeight(30);
        jRDesignStaticText.setTextAlignment((byte)2);
        JRDesignReportFont jRDesignReportFont = new JRDesignReportFont();
        jRDesignReportFont.setName("Arial_Normal");
        jRDesignReportFont.setDefault(true);
        jRDesignReportFont.setFontName("Arial");
        jRDesignReportFont.setSize(22);
        jRDesignReportFont.setPdfFontName("Helvetica");
        jRDesignReportFont.setPdfEncoding("Cp1252");
        jRDesignReportFont.setPdfEmbedded(false);
        jRDesignStaticText.setFont((JRFont)jRDesignReportFont);
        jRDesignStaticText.setText(this.reportDefinition.getName());
        jRDesignBand.addElement((JRDesignElement)jRDesignStaticText);
        this.jasperDesign.setTitle((JRBand)jRDesignBand);
    }

    public JRDesignTextField getPageFooter() {
        JRDesignTextField jRDesignTextField = new JRDesignTextField();
        jRDesignTextField.setX(0);
        jRDesignTextField.setY(10);
        jRDesignTextField.setWidth(968);
        jRDesignTextField.setHeight(15);
        jRDesignTextField.setTextAlignment((byte)2);
        jRDesignTextField.setFont((JRFont)this.normalFont);
        JRDesignExpression jRDesignExpression = new JRDesignExpression();
        jRDesignExpression.setValueClass(String.class);
        jRDesignExpression.setText("\"Page \" + String.valueOf($V{PAGE_NUMBER})");
        jRDesignTextField.setExpression((JRExpression)jRDesignExpression);
        return jRDesignTextField;
    }

    private String getFieldName(Field field, boolean bl) {
        String string = field.getId();
        String string2 = "";
        String string3 = "";
        string = string.substring(new String("Field.").length());
        if (!field.isMoney() && !bl) {
            string3 = "MODText" + string3;
            string3 = string3 + "FIELD";
        }
        string2 = string3 + string;
        return string2;
    }

    private Class getFieldClass(Field field, boolean bl) {
        if (field.isMoney()) {
            return Double.class;
        }
        if (field.isDurationOrWork() && bl) {
            return Long.class;
        }
        return String.class;
    }

    private String getFieldPattern(Field field) {
        if (field.isMoney()) {
            return "$ #,##0.00";
        }
        return null;
    }

    private void addFields(ArrayList arrayList) throws JRException {
        for (Field field : arrayList) {
            JRDesignField jRDesignField = new JRDesignField();
            jRDesignField.setName(this.getFieldName(field, false));
            jRDesignField.setValueClass(this.getFieldClass(field, false));
            try {
                this.jasperDesign.addField((JRField)jRDesignField);
                if (!this.isAggregable(field)) continue;
                this.hasAggregableField = true;
                if (!field.isDurationOrWork()) continue;
                jRDesignField = new JRDesignField();
                jRDesignField.setName(this.getFieldName(field, true));
                jRDesignField.setValueClass(this.getFieldClass(field, true));
                this.jasperDesign.addField((JRField)jRDesignField);
            }
            catch (JRException jRException) {
                System.out.println(jRException.getMessage());
            }
        }
    }

    private void addAggregableFields(ArrayList arrayList, JRDesignGroup jRDesignGroup) throws JRException {
        for (Field field : arrayList) {
            if (!this.isAggregable(field)) continue;
            String string = this.getFieldName(field, true);
            JRDesignVariable jRDesignVariable = new JRDesignVariable();
            jRDesignVariable.setName(string + "Sum");
            jRDesignVariable.setValueClass(this.getFieldClass(field, true));
            jRDesignVariable.setCalculation((byte)2);
            if (jRDesignGroup == null) {
                jRDesignVariable.setResetType((byte)1);
            } else {
                jRDesignVariable.setResetType((byte)4);
                jRDesignVariable.setResetGroup((JRGroup)jRDesignGroup);
            }
            JRDesignExpression jRDesignExpression = new JRDesignExpression();
            jRDesignExpression.setValueClass(this.getFieldClass(field, true));
            jRDesignExpression.setText("$F{" + string + "}");
            jRDesignVariable.setExpression((JRExpression)jRDesignExpression);
            this.jasperDesign.addVariable(jRDesignVariable);
        }
    }

    private JRDesignBand addFieldsHeader(JRDesignBand jRDesignBand, SpreadSheetFieldArray spreadSheetFieldArray, boolean bl) {
        Iterator iterator = spreadSheetFieldArray.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            JRDesignStaticText jRDesignStaticText = new JRDesignStaticText();
            jRDesignStaticText.setX(n);
            if (bl) {
                jRDesignStaticText.setY(20);
            } else {
                jRDesignStaticText.setY(5);
            }
            jRDesignStaticText.setWidth(field.getColumnWidth());
            jRDesignStaticText.setHeight(15);
            jRDesignStaticText.setForecolor(Color.white);
            if (bl) {
                jRDesignStaticText.setBackcolor(new Color(153, 153, 153));
            } else {
                jRDesignStaticText.setBackcolor(new Color(51, 51, 51));
            }
            jRDesignStaticText.setMode((byte)1);
            jRDesignStaticText.setTextAlignment((byte)3);
            jRDesignStaticText.setFont((JRFont)this.boldFont);
            jRDesignStaticText.setText(field.getName());
            jRDesignBand.addElement((JRDesignElement)jRDesignStaticText);
            n += field.getColumnWidth();
        }
        return jRDesignBand;
    }

    private JRDesignBand getFieldsHeader(SpreadSheetFieldArray spreadSheetFieldArray, boolean bl) throws JRException {
        JRDesignBand jRDesignBand = new JRDesignBand();
        jRDesignBand.setHeight(20);
        return this.addFieldsHeader(jRDesignBand, spreadSheetFieldArray, bl);
    }

    private JRDesignBand addDetail(JRDesignBand jRDesignBand, SpreadSheetFieldArray spreadSheetFieldArray, JRGroup jRGroup) throws JRException {
        Iterator iterator = spreadSheetFieldArray.iterator();
        int n = 0;
        if (null != jRGroup) {
            jRDesignBand.setHeight(40);
        } else {
            jRDesignBand.setHeight(15);
        }
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            JRDesignTextField jRDesignTextField = new JRDesignTextField();
            if (null != jRGroup) {
                jRDesignTextField.setEvaluationTime((byte)5);
                jRDesignTextField.setEvaluationGroup(jRGroup);
                jRDesignTextField.setY(5);
                jRDesignTextField.setFont((JRFont)this.boldFont);
                jRDesignTextField.setHeight(15);
            } else {
                jRDesignTextField.setY(0);
                jRDesignTextField.setFont((JRFont)this.normalFont);
                jRDesignTextField.setHeight(12);
            }
            jRDesignTextField.setX(n);
            jRDesignTextField.setWidth(field.getColumnWidth());
            jRDesignTextField.setTextAlignment((byte)3);
            String string = this.getFieldName(field, false);
            if (field.isMoney()) {
                jRDesignTextField.setPattern(this.getFieldPattern(field));
            }
            JRDesignExpression jRDesignExpression = new JRDesignExpression();
            jRDesignExpression.setValueClass(this.getFieldClass(field, false));
            jRDesignExpression.setText("$F{" + string + "}");
            jRDesignTextField.setExpression((JRExpression)jRDesignExpression);
            jRDesignBand.addElement((JRDesignElement)jRDesignTextField);
            n += field.getColumnWidth();
        }
        return jRDesignBand;
    }

    private JRDesignBand getDetail(SpreadSheetFieldArray spreadSheetFieldArray, JRGroup jRGroup) throws JRException {
        JRDesignBand jRDesignBand = new JRDesignBand();
        return this.addDetail(jRDesignBand, spreadSheetFieldArray, jRGroup);
    }

    private JRDesignBand getAggregatableFooter(SpreadSheetFieldArray spreadSheetFieldArray) throws JRException {
        JRDesignBand jRDesignBand = new JRDesignBand();
        jRDesignBand.setHeight(40);
        Iterator iterator = spreadSheetFieldArray.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (this.isAggregable(field)) {
                JRDesignLine jRDesignLine = new JRDesignLine();
                jRDesignLine.setX(n);
                jRDesignLine.setY(0);
                jRDesignLine.setWidth(field.getColumnWidth());
                jRDesignLine.setHeight(0);
                jRDesignBand.addElement((JRDesignElement)jRDesignLine);
                jRDesignLine.setY(2);
                jRDesignBand.addElement((JRDesignElement)jRDesignLine);
                JRDesignTextField jRDesignTextField = new JRDesignTextField();
                jRDesignTextField.setX(n);
                jRDesignTextField.setY(4);
                jRDesignTextField.setWidth(field.getColumnWidth());
                jRDesignTextField.setHeight(12);
                jRDesignTextField.setTextAlignment((byte)3);
                jRDesignTextField.setFont((JRFont)this.normalFont);
                JRDesignExpression jRDesignExpression = new JRDesignExpression();
                if (field.isMoney()) {
                    jRDesignExpression.setValueClass(this.getFieldClass(field, true));
                    jRDesignTextField.setPattern(this.getFieldPattern(field));
                    jRDesignExpression.setText("$V{" + this.getFieldName(field, true) + "Sum}");
                } else if (field.isWork()) {
                    jRDesignExpression.setValueClass(String.class);
                    jRDesignExpression.setText("com.projity.datatype.DurationFormat.formatWork($V{" + this.getFieldName(field, true) + "Sum})");
                } else if (field.isDuration()) {
                    jRDesignExpression.setValueClass(String.class);
                    jRDesignExpression.setText("com.projity.datatype.DurationFormat.format($V{" + this.getFieldName(field, true) + "Sum})");
                }
                jRDesignTextField.setExpression((JRExpression)jRDesignExpression);
                jRDesignBand.addElement((JRDesignElement)jRDesignTextField);
            }
            n += field.getColumnWidth();
        }
        return jRDesignBand;
    }

    private void addLastPageFooter(SpreadSheetFieldArray spreadSheetFieldArray) throws JRException {
        JRDesignBand jRDesignBand = this.getAggregatableFooter(spreadSheetFieldArray);
        jRDesignBand.addElement((JRDesignElement)this.getPageFooter());
        this.jasperDesign.setLastPageFooter((JRBand)jRDesignBand);
    }

    private void addPageFooter() throws JRException {
        JRDesignBand jRDesignBand = new JRDesignBand();
        jRDesignBand.setHeight(30);
        JRDesignLine jRDesignLine = new JRDesignLine();
        jRDesignLine.setX(0);
        jRDesignLine.setY(0);
        jRDesignLine.setWidth(968);
        jRDesignLine.setHeight(0);
        jRDesignBand.addElement((JRDesignElement)jRDesignLine);
        jRDesignBand.addElement((JRDesignElement)this.getPageFooter());
        this.jasperDesign.setPageFooter((JRBand)jRDesignBand);
    }

    public void generateDesign(SpreadSheetFieldArray spreadSheetFieldArray) throws JRException {
        this.hasAggregableField = false;
        this.generateBaseDesign();
        ArrayList arrayList = this.reportDefinition.getColumnsList();
        if (arrayList.size() == 1) {
            SpreadSheetFieldArray spreadSheetFieldArray2;
            if (spreadSheetFieldArray != null) {
                spreadSheetFieldArray2 = spreadSheetFieldArray;
            } else {
                ReportColumns reportColumns = (ReportColumns)arrayList.get(0);
                spreadSheetFieldArray2 = reportColumns.getFieldArray();
            }
            this.addFields(spreadSheetFieldArray2);
            if (this.hasAggregableField) {
                this.addAggregableFields(spreadSheetFieldArray2, null);
            }
            this.jasperDesign.setPageHeader((JRBand)this.getFieldsHeader(spreadSheetFieldArray2, false));
            this.jasperDesign.setDetail((JRBand)this.getDetail(spreadSheetFieldArray2, null));
            this.addPageFooter();
            if (this.hasAggregableField) {
                this.addLastPageFooter(spreadSheetFieldArray2);
            }
        } else if (arrayList.size() == 2) {
            Field field2;
            ReportColumns reportColumns = (ReportColumns)arrayList.get(0);
            String string = reportColumns.getGroupbyField();
            SpreadSheetFieldArray spreadSheetFieldArray3 = reportColumns.getFieldArray();
            reportColumns = (ReportColumns)arrayList.get(1);
            SpreadSheetFieldArray spreadSheetFieldArray4 = spreadSheetFieldArray != null ? spreadSheetFieldArray : reportColumns.getFieldArray();
            this.addFields(spreadSheetFieldArray3);
            this.addFields(spreadSheetFieldArray4);
            JRDesignGroup jRDesignGroup = new JRDesignGroup();
            if (this.hasAggregableField) {
                this.addAggregableFields(spreadSheetFieldArray4, jRDesignGroup);
            }
            jRDesignGroup.setName(GroupName);
            jRDesignGroup.setStartNewColumn(false);
            jRDesignGroup.setStartNewPage(false);
            JRDesignExpression jRDesignExpression = new JRDesignExpression();
            for (Field field2 : spreadSheetFieldArray3) {
                if (!string.equals(field2.getId())) continue;
                jRDesignExpression.setText("$F{" + this.getFieldName(field2, false) + "}");
                jRDesignExpression.setValueClass(this.getFieldClass(field2, false));
                jRDesignGroup.setExpression((JRExpression)jRDesignExpression);
                break;
            }
            field2 = this.getDetail(spreadSheetFieldArray3, (JRGroup)jRDesignGroup);
            field2 = this.addFieldsHeader((JRDesignBand)field2, spreadSheetFieldArray4, true);
            jRDesignGroup.setGroupHeader((JRBand)field2);
            if (this.hasAggregableField) {
                jRDesignGroup.setGroupFooter((JRBand)this.getAggregatableFooter(spreadSheetFieldArray4));
            }
            this.jasperDesign.addGroup(jRDesignGroup);
            this.jasperDesign.setPageHeader((JRBand)this.getFieldsHeader(spreadSheetFieldArray3, false));
            this.jasperDesign.setDetail((JRBand)this.getDetail(spreadSheetFieldArray4, null));
            this.addPageFooter();
        } else {
            throw new JRException("report definition must contain either one or two columns (see view.xml)");
        }
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }
}

