/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFieldValueReader12
extends CustomFieldValueReader {
    public CustomFieldValueReader12(ProjectProperties projectProperties, CustomFieldContainer customFieldContainer, VarMeta varMeta, Var2Data var2Data, FixedData fixedData, FixedData fixedData2, Props props) {
        super(projectProperties, customFieldContainer, varMeta, var2Data, fixedData, fixedData2, props);
    }

    @Override
    public void process() {
        Integer[] integerArray = this.m_outlineCodeVarMeta.getUniqueIdentifierArray();
        Map<UUID, FieldType> map = this.populateCustomFieldMap();
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n = integerArray[i];
            CustomFieldValueItem customFieldValueItem = new CustomFieldValueItem(n);
            byte[] byArray = this.m_outlineCodeVarData.getByteArray(n, VALUE_LIST_VALUE);
            customFieldValueItem.setDescription(this.m_outlineCodeVarData.getUnicodeString(n, VALUE_LIST_DESCRIPTION));
            customFieldValueItem.setUnknown(this.m_outlineCodeVarData.getByteArray(n, VALUE_LIST_UNKNOWN));
            byte[] byArray2 = this.m_outlineCodeFixedData.getByteArrayValue(i + 3);
            if (byArray2 != null) {
                customFieldValueItem.setParent(MPPUtility.getShort(byArray2, 8));
            }
            byte[] byArray3 = this.m_outlineCodeFixedData2.getByteArrayValue(i + 3);
            customFieldValueItem.setGuid(MPPUtility.getGUID(byArray3, 0));
            UUID uUID = MPPUtility.getGUID(byArray3, 32);
            int n2 = MPPUtility.getShort(byArray3, 48);
            customFieldValueItem.setValue(this.getTypedValue(n2, byArray));
            FieldType fieldType = map.get(uUID);
            this.m_container.getCustomField(fieldType).getLookupTable().add(customFieldValueItem);
        }
    }

    private Map<UUID, FieldType> populateCustomFieldMap() {
        byte[] byArray = this.m_taskProps.getByteArray(Props.CUSTOM_FIELDS);
        HashMap<UUID, FieldType> hashMap = new HashMap<UUID, FieldType>();
        int n = 44;
        int n2 = MPPUtility.getInt(byArray, n);
        n += 4;
        n += 8 * n2;
        while (n + 200 <= byArray.length) {
            FieldType fieldType = FieldTypeHelper.getInstance(MPPUtility.getInt(byArray, n + 4));
            UUID uUID = MPPUtility.getGUID(byArray, n + 160);
            hashMap.put(uUID, fieldType);
            n += 200;
        }
        return hashMap;
    }
}

