/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class FilteredResizableIcon
implements ResizableIcon {
    protected Map<String, BufferedImage> cachedImages;
    protected ResizableIcon delegate;
    protected BufferedImageOp operation;

    public FilteredResizableIcon(ResizableIcon resizableIcon, BufferedImageOp bufferedImageOp) {
        this.delegate = resizableIcon;
        this.operation = bufferedImageOp;
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> entry) {
                return this.size() > 5;
            }
        };
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension dimension) {
        this.delegate.setDimension(dimension);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        String string = this.getIconWidth() + ":" + this.getIconHeight();
        if (!this.cachedImages.containsKey(string)) {
            Object object;
            if (this.delegate instanceof AsynchronousLoading && (object = (AsynchronousLoading)((Object)this.delegate)).isLoading()) {
                return;
            }
            object = FlamingoUtilities.getBlankImage(this.getIconWidth(), this.getIconHeight());
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            this.delegate.paintIcon(component, graphics2D, 0, 0);
            graphics2D.dispose();
            BufferedImage bufferedImage = this.operation.filter((BufferedImage)object, null);
            this.cachedImages.put(string, bufferedImage);
        }
        graphics.drawImage(this.cachedImages.get(string), n, n2, null);
    }
}

