/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRootData
extends AbstractExternalEntityData {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<ExternalSystemSourceType, Collection<SourceRoot>> myData;
    @NotNull
    private final String myRootPath;

    public ContentRootData(@NotNull ProjectSystemId owner, @NotNull String rootPath) {
        if (owner == null) {
            ContentRootData.$$$reportNull$$$0(0);
        }
        if (rootPath == null) {
            ContentRootData.$$$reportNull$$$0(1);
        }
        super(owner);
        this.myData = ContainerUtilRt.newHashMap();
        this.myRootPath = ExternalSystemApiUtil.toCanonicalPath(rootPath);
    }

    @NotNull
    public Collection<SourceRoot> getPaths(@NotNull ExternalSystemSourceType type) {
        Collection<SourceRoot> result;
        if (type == null) {
            ContentRootData.$$$reportNull$$$0(2);
        }
        Collection<Object> collection = (result = this.myData.get(type)) == null ? Collections.emptyList() : result;
        if (collection == null) {
            ContentRootData.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void storePath(@NotNull ExternalSystemSourceType type, @NotNull String path2) throws IllegalArgumentException {
        if (type == null) {
            ContentRootData.$$$reportNull$$$0(4);
        }
        if (path2 == null) {
            ContentRootData.$$$reportNull$$$0(5);
        }
        this.storePath(type, path2, null);
    }

    public void storePath(@NotNull ExternalSystemSourceType type, @NotNull String path2, @Nullable String packagePrefix) throws IllegalArgumentException {
        if (type == null) {
            ContentRootData.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            ContentRootData.$$$reportNull$$$0(7);
        }
        if (FileUtil.isAncestor((File)new File(this.getRootPath()), (File)new File(path2), (boolean)false)) {
            Collection<SourceRoot> paths = this.myData.get(type);
            if (paths == null) {
                paths = new TreeSet<SourceRoot>(SourceRootComparator.INSTANCE);
                this.myData.put(type, paths);
            }
            paths.add(new SourceRoot(ExternalSystemApiUtil.toCanonicalPath(path2), StringUtil.nullize((String)packagePrefix, (boolean)true)));
            return;
        }
        if (!ExternalSystemSourceType.EXCLUDED.equals((Object)type)) {
            throw new IllegalArgumentException(String.format("Can't register given path of type '%s' because it's out of content root.%nContent root: '%s'%nGiven path: '%s'", type, this.getRootPath(), new File(path2).getAbsolutePath()));
        }
    }

    @NotNull
    public String getRootPath() {
        String string = this.myRootPath;
        if (string == null) {
            ContentRootData.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("content root:");
        for (Map.Entry<ExternalSystemSourceType, Collection<SourceRoot>> entry : this.myData.entrySet()) {
            buffer.append(entry.getKey().toString().toLowerCase(Locale.ENGLISH)).append("=").append(entry.getValue()).append("|");
        }
        if (!this.myData.isEmpty()) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/ContentRootData";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/ContentRootData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "storePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SourceRootComparator
    implements Comparator<SourceRoot>,
    Serializable {
        private static final SourceRootComparator INSTANCE = new SourceRootComparator();

        private SourceRootComparator() {
        }

        @Override
        public int compare(@NotNull SourceRoot o1, @NotNull SourceRoot o2) {
            if (o1 == null) {
                SourceRootComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                SourceRootComparator.$$$reportNull$$$0(1);
            }
            return StringUtil.naturalCompare((String)o1.myPath, (String)o2.myPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRootComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SourceRoot
    implements Serializable {
        @NotNull
        private final String myPath;
        @Nullable
        private final String myPackagePrefix;

        public SourceRoot(@NotNull String path2, @Nullable String prefix) {
            if (path2 == null) {
                SourceRoot.$$$reportNull$$$0(0);
            }
            this.myPath = path2;
            this.myPackagePrefix = prefix;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                SourceRoot.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getPackagePrefix() {
            return this.myPackagePrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceRoot)) {
                return false;
            }
            SourceRoot root = (SourceRoot)o;
            if (this.myPackagePrefix != null ? !this.myPackagePrefix.equals(root.myPackagePrefix) : root.myPackagePrefix != null) {
                return false;
            }
            return this.myPath.equals(root.myPath);
        }

        public int hashCode() {
            int result = this.myPath.hashCode();
            result = 31 * result + (this.myPackagePrefix != null ? this.myPackagePrefix.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("source_root(");
            buffer.append(this.myPath);
            if (this.myPackagePrefix != null) {
                buffer.append(", ").append(this.myPackagePrefix);
            }
            buffer.append(")");
            return buffer.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

