/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.keywordSubstitution;

import com.intellij.CvsBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;

public class KeywordSubstitutionWrapper {
    private final KeywordSubstitution myKeywordSubstitution;
    private final String myDisplayName;
    public static final KeywordSubstitutionWrapper KEYWORD_EXPANSION = new KeywordSubstitutionWrapper(KeywordSubstitution.KEYWORD_EXPANSION, CvsBundle.message((String)"keyword.substitution.expansion", (Object[])new Object[0]));
    public static final KeywordSubstitutionWrapper KEYWORD_EXPANSION_LOCKER = new KeywordSubstitutionWrapper(KeywordSubstitution.KEYWORD_EXPANSION_LOCKER, CvsBundle.message((String)"keyword.substitution.expansion.locker", (Object[])new Object[0]));
    public static final KeywordSubstitutionWrapper KEYWORD_COMPRESSION = new KeywordSubstitutionWrapper(KeywordSubstitution.KEYWORD_COMPRESSION, CvsBundle.message((String)"keyword.substitution.compression", (Object[])new Object[0]));
    public static final KeywordSubstitutionWrapper NO_SUBSTITUTION = new KeywordSubstitutionWrapper(KeywordSubstitution.NO_SUBSTITUTION, CvsBundle.message((String)"keyword.substitution.no.substitution", (Object[])new Object[0]));
    public static final KeywordSubstitutionWrapper BINARY = new KeywordSubstitutionWrapper(KeywordSubstitution.BINARY, CvsBundle.message((String)"keyword.substitution.binary", (Object[])new Object[0]));
    public static final KeywordSubstitutionWrapper KEYWORD_REPLACEMENT = new KeywordSubstitutionWrapper(KeywordSubstitution.KEYWORD_REPLACEMENT, CvsBundle.message((String)"keyword.substitution.replacement", (Object[])new Object[0]));
    private static List<KeywordSubstitutionWrapper> values = null;

    private KeywordSubstitutionWrapper(KeywordSubstitution keywordSubstitution, String displayName) {
        this.myKeywordSubstitution = keywordSubstitution;
        this.myDisplayName = displayName;
    }

    public KeywordSubstitution getSubstitution() {
        return this.myKeywordSubstitution;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public static KeywordSubstitutionWrapper getValue(String substitution) {
        KeywordSubstitution keywordSubstitution = KeywordSubstitution.getValue((String)substitution);
        return KeywordSubstitutionWrapper.getValue(keywordSubstitution);
    }

    public static KeywordSubstitutionWrapper getValue(KeywordSubstitution substitution) {
        if (substitution == KeywordSubstitution.BINARY) {
            return BINARY;
        }
        if (substitution == KeywordSubstitution.KEYWORD_COMPRESSION) {
            return KEYWORD_COMPRESSION;
        }
        if (substitution == KeywordSubstitution.KEYWORD_EXPANSION) {
            return KEYWORD_EXPANSION;
        }
        if (substitution == KeywordSubstitution.KEYWORD_EXPANSION_LOCKER) {
            return KEYWORD_EXPANSION_LOCKER;
        }
        if (substitution == KeywordSubstitution.NO_SUBSTITUTION) {
            return NO_SUBSTITUTION;
        }
        if (substitution == KeywordSubstitution.KEYWORD_REPLACEMENT) {
            return KEYWORD_REPLACEMENT;
        }
        return null;
    }

    public static void fillComboBox(JComboBox comboBox, KeywordSubstitution defaultSubstitution) {
        for (KeywordSubstitutionWrapper value : KeywordSubstitutionWrapper.values()) {
            comboBox.addItem(value);
        }
        if (defaultSubstitution != null) {
            comboBox.setSelectedItem(KeywordSubstitutionWrapper.getValue(defaultSubstitution));
        }
    }

    public static List<KeywordSubstitutionWrapper> values() {
        if (values == null) {
            ArrayList<KeywordSubstitutionWrapper> list = new ArrayList<KeywordSubstitutionWrapper>();
            list.add(KEYWORD_EXPANSION);
            list.add(KEYWORD_EXPANSION_LOCKER);
            list.add(KEYWORD_COMPRESSION);
            list.add(NO_SUBSTITUTION);
            list.add(BINARY);
            list.add(KEYWORD_REPLACEMENT);
            values = Collections.unmodifiableList(list);
        }
        return values;
    }
}

