/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;

public class XmlCDATAContentSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof CompositePsiElement && ((CompositePsiElement)e).getElementType() == XmlElementType.XML_CDATA;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result2 = super.select(e, editorText, cursorOffset, editor);
        PsiElement[] children2 = e.getChildren();
        PsiElement first = null;
        PsiElement last = null;
        for (PsiElement child : children2) {
            if (!(child instanceof XmlToken)) continue;
            XmlToken token = (XmlToken)child;
            if (token.getTokenType() == XmlTokenType.XML_CDATA_START) {
                first = token.getNextSibling();
            }
            if (token.getTokenType() != XmlTokenType.XML_CDATA_END) continue;
            last = token.getPrevSibling();
            break;
        }
        if (first != null && last != null) {
            result2.addAll(XmlCDATAContentSelectioner.expandToWholeLine(editorText, new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset()), false));
        }
        return result2;
    }
}

