/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoreProjectJdkTable
extends ProjectJdkTable {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sdk findJdk(String name) {
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            for (Sdk jdk : this.mySdks) {
                if (!Comparing.strEqual((String)name, (String)jdk.getName())) continue;
                return jdk;
            }
        }
        return null;
    }

    public Sdk findJdk(String name, String type) {
        return this.findJdk(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Sdk[] getAllJdks() {
        List<Sdk> list2 = this.mySdks;
        // MONITORENTER : list2
        Sdk[] sdkArray = this.mySdks.toArray(new Sdk[this.mySdks.size()]);
        // MONITOREXIT : list2
        if (sdkArray != null) return sdkArray;
        CoreProjectJdkTable.$$$reportNull$$$0(0);
        return sdkArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type) {
        if (type == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(1);
        }
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            for (Sdk sdk : this.mySdks) {
                if (sdk.getSdkType() != type) continue;
                result2.add(sdk);
            }
        }
        ArrayList<Sdk> arrayList = result2;
        if (arrayList == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(3);
        }
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            this.mySdks.add(jdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(4);
        }
        List<Sdk> list2 = this.mySdks;
        synchronized (list2) {
            this.mySdks.remove(jdk);
        }
    }

    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        if (originalJdk == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(5);
        }
        if (modifiedJdk == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    public void addListener(@NotNull ProjectJdkTable.Listener listener2) {
        if (listener2 == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(7);
        }
    }

    public void removeListener(@NotNull ProjectJdkTable.Listener listener2) {
        if (listener2 == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        CoreSdkType coreSdkType = CoreSdkType.INSTANCE;
        if (coreSdkType == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(9);
        }
        return coreSdkType;
    }

    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String name) {
        if (name == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(10);
        }
        CoreSdkType coreSdkType = CoreSdkType.INSTANCE;
        if (coreSdkType == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(11);
        }
        return coreSdkType;
    }

    @NotNull
    public Sdk createSdk(@NotNull String name, @NotNull SdkTypeId sdkType) {
        if (name == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(12);
        }
        if (sdkType == null) {
            CoreProjectJdkTable.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreProjectJdkTable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalJdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedJdk";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJdks";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreProjectJdkTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdksOfType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSdkType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSdksOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addJdk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeJdk";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateJdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSdkTypeByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

