/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.InjectedCaret;
import com.intellij.injected.editor.ListenerWrapperMap;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelWindow
implements CaretModel {
    private final CaretModel myDelegate;
    private final EditorEx myHostEditor;
    private final EditorWindow myEditorWindow;
    private final Map<Caret, InjectedCaret> myInjectedCaretMap = new WeakHashMap<Caret, InjectedCaret>();
    private final ListenerWrapperMap<CaretListener> myCaretListeners = new ListenerWrapperMap();

    public CaretModelWindow(CaretModel delegate, EditorWindow editorWindow) {
        this.myDelegate = delegate;
        this.myHostEditor = (EditorEx)editorWindow.getDelegate();
        this.myEditorWindow = editorWindow;
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.myDelegate.moveCaretRelatively(columnShift, lineShift, withSelection, blockSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(0);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(1);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int hostOffset = this.myEditorWindow.getDocument().injectedToHost(offset);
        this.myDelegate.moveToOffset(hostOffset, locateBeforeSoftWrap);
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition hostPos = this.myDelegate.getLogicalPosition();
        LogicalPosition logicalPosition = this.myEditorWindow.hostToInjected(hostPos);
        if (logicalPosition == null) {
            CaretModelWindow.$$$reportNull$$$0(2);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition logicalPosition = this.getLogicalPosition();
        VisualPosition visualPosition = this.myEditorWindow.logicalToVisualPosition(logicalPosition);
        if (visualPosition == null) {
            CaretModelWindow.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getOffset());
    }

    public boolean isUpToDate() {
        return this.myDelegate.isUpToDate();
    }

    public void addCaretListener(final @NotNull CaretListener listener2) {
        if (listener2 == null) {
            CaretModelWindow.$$$reportNull$$$0(4);
        }
        CaretListener wrapper2 = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                if (!CaretModelWindow.this.myEditorWindow.getDocument().isValid()) {
                    return;
                }
                CaretEvent event = new CaretEvent((Editor)CaretModelWindow.this.myEditorWindow, (Caret)CaretModelWindow.this.createInjectedCaret(e.getCaret()), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getOldPosition()), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getNewPosition()));
                listener2.caretPositionChanged(event);
            }
        };
        this.myCaretListeners.registerWrapper(listener2, wrapper2);
        this.myDelegate.addCaretListener(wrapper2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        CaretListener wrapper2;
        if (listener2 == null) {
            CaretModelWindow.$$$reportNull$$$0(5);
        }
        if ((wrapper2 = this.myCaretListeners.removeWrapper(listener2)) != null) {
            this.myDelegate.removeCaretListener(wrapper2);
        }
    }

    public void disposeModel() {
        for (CaretListener wrapper2 : this.myCaretListeners.wrappers()) {
            this.myDelegate.removeCaretListener(wrapper2);
        }
        this.myCaretListeners.clear();
    }

    public int getVisualLineStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineStart());
    }

    public int getVisualLineEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineEnd());
    }

    public TextAttributes getTextAttributes() {
        return this.myDelegate.getTextAttributes();
    }

    public boolean supportsMultipleCarets() {
        return this.myDelegate.supportsMultipleCarets();
    }

    @NotNull
    public Caret getCurrentCaret() {
        InjectedCaret injectedCaret = this.createInjectedCaret(this.myDelegate.getCurrentCaret());
        if (injectedCaret == null) {
            CaretModelWindow.$$$reportNull$$$0(6);
        }
        return injectedCaret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        InjectedCaret injectedCaret = this.createInjectedCaret(this.myDelegate.getPrimaryCaret());
        if (injectedCaret == null) {
            CaretModelWindow.$$$reportNull$$$0(7);
        }
        return injectedCaret;
    }

    public int getCaretCount() {
        return this.myDelegate.getCaretCount();
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List hostCarets = this.myDelegate.getAllCarets();
        ArrayList<Caret> carets = new ArrayList<Caret>(hostCarets.size());
        for (Caret hostCaret : hostCarets) {
            carets.add(this.createInjectedCaret(hostCaret));
        }
        ArrayList<Caret> arrayList = carets;
        if (arrayList == null) {
            CaretModelWindow.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(9);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        Caret caret = this.myDelegate.getCaretAt(this.myHostEditor.logicalToVisualPosition(hostPos));
        return this.createInjectedCaret(caret);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(10);
        }
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(11);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        Caret caret = this.myDelegate.addCaret(this.myHostEditor.logicalToVisualPosition(hostPos));
        return this.createInjectedCaret(caret);
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelWindow.$$$reportNull$$$0(12);
        }
        if (caret instanceof InjectedCaret) {
            caret = ((InjectedCaret)caret).myDelegate;
        }
        return this.myDelegate.removeCaret(caret);
    }

    public void removeSecondaryCarets() {
        this.myDelegate.removeSecondaryCarets();
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        if (caretStates == null) {
            CaretModelWindow.$$$reportNull$$$0(13);
        }
        List<CaretState> convertedStates = this.convertCaretStates(caretStates);
        this.myDelegate.setCaretsAndSelections(convertedStates);
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            CaretModelWindow.$$$reportNull$$$0(14);
        }
        List<CaretState> convertedStates = this.convertCaretStates(caretStates);
        this.myDelegate.setCaretsAndSelections(convertedStates, updateSystemSelection);
    }

    private List<CaretState> convertCaretStates(List<CaretState> caretStates) {
        ArrayList<CaretState> convertedStates = new ArrayList<CaretState>(caretStates.size());
        for (CaretState state2 : caretStates) {
            convertedStates.add(new CaretState(this.injectedToHost(state2.getCaretPosition()), this.injectedToHost(state2.getSelectionStart()), this.injectedToHost(state2.getSelectionEnd())));
        }
        return convertedStates;
    }

    private LogicalPosition injectedToHost(@Nullable LogicalPosition position) {
        return position == null ? null : this.myEditorWindow.injectedToHost(position);
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        List caretsAndSelections = this.myDelegate.getCaretsAndSelections();
        ArrayList<CaretState> convertedStates = new ArrayList<CaretState>(caretsAndSelections.size());
        for (CaretState state2 : caretsAndSelections) {
            convertedStates.add(new CaretState(this.hostToInjected(state2.getCaretPosition()), this.hostToInjected(state2.getSelectionStart()), this.hostToInjected(state2.getSelectionEnd())));
        }
        ArrayList<CaretState> arrayList = convertedStates;
        if (arrayList == null) {
            CaretModelWindow.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private LogicalPosition hostToInjected(@Nullable LogicalPosition position) {
        return position == null ? null : this.myEditorWindow.hostToInjected(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectedCaret createInjectedCaret(Caret caret) {
        if (caret == null) {
            return null;
        }
        Map<Caret, InjectedCaret> map2 = this.myInjectedCaretMap;
        synchronized (map2) {
            InjectedCaret injectedCaret = this.myInjectedCaretMap.get(caret);
            if (injectedCaret == null) {
                injectedCaret = new InjectedCaret(this.myEditorWindow, caret);
                this.myInjectedCaretMap.put(caret, injectedCaret);
            }
            return injectedCaret;
        }
    }

    public void runForEachCaret(final @NotNull CaretAction action) {
        if (action == null) {
            CaretModelWindow.$$$reportNull$$$0(16);
        }
        this.myDelegate.runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                action.perform((Caret)CaretModelWindow.this.createInjectedCaret(caret));
            }
        });
    }

    public void runForEachCaret(final @NotNull CaretAction action, boolean reverseOrder) {
        if (action == null) {
            CaretModelWindow.$$$reportNull$$$0(17);
        }
        this.myDelegate.runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                action.perform((Caret)CaretModelWindow.this.createInjectedCaret(caret));
            }
        }, reverseOrder);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CaretModelWindow.$$$reportNull$$$0(18);
        }
        this.myDelegate.runBatchCaretOperation(runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/injected/editor/CaretModelWindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/injected/editor/CaretModelWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

