/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TriggerAdditionOrDeletion {
    private final Collection<FilePath> myExisting;
    private final Collection<FilePath> myDeleted;
    private final Set<FilePath> myAffected;
    private final Project myProject;
    private final boolean mySilentAddDelete;
    private final ProjectLevelVcsManager myVcsManager;
    private final AbstractVcsHelper myVcsHelper;
    private static final Logger LOG = Logger.getInstance(TriggerAdditionOrDeletion.class);
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    private MultiMap<VcsRoot, FilePath> myPreparedAddition;
    private MultiMap<VcsRoot, FilePath> myPreparedDeletion;

    public TriggerAdditionOrDeletion(Project project) {
        this.myProject = project;
        this.mySilentAddDelete = Registry.is((String)"vcs.add.remove.silent");
        this.myExisting = new HashSet<FilePath>();
        this.myDeleted = new HashSet<FilePath>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)this.myProject);
        this.myAffected = new HashSet<FilePath>();
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
    }

    public void addExisting(Collection<FilePath> files) {
        this.myExisting.addAll(files);
    }

    public void addDeleted(Collection<FilePath> files) {
        this.myDeleted.addAll(files);
    }

    public void prepare() {
        if (this.myExisting.isEmpty() && this.myDeleted.isEmpty()) {
            return;
        }
        if (!this.myExisting.isEmpty()) {
            this.processAddition();
        }
        if (!this.myDeleted.isEmpty()) {
            this.processDeletion();
        }
    }

    public void processIt() {
        if (this.myPreparedDeletion != null) {
            for (Map.Entry entry : this.myPreparedDeletion.entrySet()) {
                VcsRoot vcsRoot = (VcsRoot)entry.getKey();
                AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)vcsRoot.getVcs());
                CheckinEnvironment localChangesProvider = vcs.getCheckinEnvironment();
                if (localChangesProvider == null) continue;
                Collection filePaths = (Collection)entry.getValue();
                if (vcs.fileListenerIsSynchronous()) {
                    this.myAffected.addAll(filePaths);
                    continue;
                }
                this.askUserIfNeeded(vcsRoot.getVcs(), (List)filePaths, VcsConfiguration.StandardConfirmation.REMOVE);
                this.myAffected.addAll(filePaths);
                localChangesProvider.scheduleMissingFileForDeletion((List)filePaths);
            }
        }
        if (this.myPreparedAddition != null) {
            ArrayList<FilePath> incorrectFilePath = new ArrayList<FilePath>();
            for (Map.Entry entry : this.myPreparedAddition.entrySet()) {
                VcsRoot vcsRoot = (VcsRoot)entry.getKey();
                AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)vcsRoot.getVcs());
                CheckinEnvironment localChangesProvider = vcs.getCheckinEnvironment();
                if (localChangesProvider == null) continue;
                Collection filePaths = (Collection)entry.getValue();
                if (vcs.fileListenerIsSynchronous()) {
                    this.myAffected.addAll(filePaths);
                    continue;
                }
                this.askUserIfNeeded(vcsRoot.getVcs(), (List)filePaths, VcsConfiguration.StandardConfirmation.ADD);
                this.myAffected.addAll(filePaths);
                ArrayList virtualFiles = new ArrayList();
                ContainerUtil.process((Iterable)filePaths, path -> {
                    VirtualFile vf = path.getVirtualFile();
                    if (vf == null) {
                        incorrectFilePath.add((FilePath)path);
                    } else {
                        virtualFiles.add(vf);
                    }
                    return true;
                });
                localChangesProvider.scheduleUnversionedFilesForAddition(virtualFiles);
            }
            if (!incorrectFilePath.isEmpty()) {
                this.notifyAndLogFiles("Apply new files error", incorrectFilePath);
            }
        }
    }

    private void notifyAndLogFiles(@NotNull String topic, @NotNull List<FilePath> incorrectFilePath) {
        if (topic == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(0);
        }
        if (incorrectFilePath == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(1);
        }
        String message = "The following " + StringUtil.pluralize((String)"file", (int)incorrectFilePath.size()) + " may be processed incorrectly by VCS.\nPlease check it manually: " + incorrectFilePath;
        LOG.warn(message);
        VcsNotifier.getInstance(this.myProject).notifyImportantWarning(topic, message);
    }

    public Set<FilePath> getAffected() {
        return this.myAffected;
    }

    private void processDeletion() {
        Map map2 = VcsUtil.groupByRoots((Project)this.myProject, this.myDeleted, (Function)Functions.identity());
        this.myPreparedDeletion = new MultiMap();
        for (VcsRoot vcsRoot : map2.keySet()) {
            CheckinEnvironment localChangesProvider;
            if (vcsRoot == null || vcsRoot.getVcs() == null || (localChangesProvider = vcsRoot.getVcs().getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcsRoot.getVcs().areDirectoriesVersionedItems();
            Collection files = (Collection)map2.get(vcsRoot);
            LinkedList<FilePath> toBeDeleted = new LinkedList<FilePath>();
            for (FilePath file2 : files) {
                FilePath parent = file2.getParentPath();
                if (!takeDirs && file2.isDirectory() || parent == null || !parent.getIOFile().exists()) continue;
                toBeDeleted.add(file2);
            }
            if (toBeDeleted.isEmpty()) {
                return;
            }
            if (!vcsRoot.getVcs().fileListenerIsSynchronous()) {
                for (FilePath filePath : toBeDeleted) {
                    this.myVcsFileListenerContextHelper.ignoreDeleted(filePath);
                }
            }
            this.myPreparedDeletion.put((Object)vcsRoot, toBeDeleted);
        }
    }

    private void processAddition() {
        Map map2 = VcsUtil.groupByRoots((Project)this.myProject, this.myExisting, (Function)Functions.identity());
        this.myPreparedAddition = new MultiMap();
        for (VcsRoot vcsRoot : map2.keySet()) {
            List<Object> toBeAdded;
            CheckinEnvironment localChangesProvider;
            if (vcsRoot == null || vcsRoot.getVcs() == null || (localChangesProvider = vcsRoot.getVcs().getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcsRoot.getVcs().areDirectoriesVersionedItems();
            Collection files = (Collection)map2.get(vcsRoot);
            if (takeDirs) {
                RecursiveCheckAdder adder = new RecursiveCheckAdder(vcsRoot.getPath());
                for (FilePath file2 : files) {
                    adder.process(file2);
                }
                toBeAdded = adder.getToBeAdded();
            } else {
                toBeAdded = new LinkedList();
                for (FilePath filePath : files) {
                    if (filePath.isDirectory()) continue;
                    toBeAdded.add(filePath);
                }
            }
            if (toBeAdded.isEmpty()) {
                return;
            }
            Collections.sort(toBeAdded, FilePathByPathComparator.getInstance());
            if (!vcsRoot.getVcs().fileListenerIsSynchronous()) {
                for (FilePath filePath : toBeAdded) {
                    this.myVcsFileListenerContextHelper.ignoreAdded(filePath.getVirtualFile());
                }
            }
            this.myPreparedAddition.put((Object)vcsRoot, toBeAdded);
        }
    }

    private void askUserIfNeeded(AbstractVcs vcs, @NotNull List<FilePath> filePaths, @NotNull VcsConfiguration.StandardConfirmation type) {
        if (filePaths == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(2);
        }
        if (type == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(3);
        }
        if (this.mySilentAddDelete) {
            return;
        }
        VcsShowConfirmationOption confirmationOption = this.myVcsManager.getStandardConfirmation(type, vcs);
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)confirmationOption.getValue())) {
            filePaths.clear();
        } else if (VcsShowConfirmationOption.Value.SHOW_CONFIRMATION.equals((Object)confirmationOption.getValue())) {
            String operation = type == VcsConfiguration.StandardConfirmation.ADD ? "addition" : "deletion";
            String preposition = type == VcsConfiguration.StandardConfirmation.ADD ? " to " : " from ";
            Collection files = this.myVcsHelper.selectFilePathsToProcess(filePaths, "Select files to " + StringUtil.decapitalize((String)type.getId()) + preposition + vcs.getDisplayName(), null, "Schedule for " + operation, "Do you want to schedule the following file for " + operation + preposition + vcs.getDisplayName() + "\n{0}", confirmationOption);
            if (files == null) {
                filePaths.clear();
            } else {
                filePaths.retainAll(files);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incorrectFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/TriggerAdditionOrDeletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyAndLogFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "askUserIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RecursiveCheckAdder {
        private final Set<FilePath> myToBeAdded;
        private final VirtualFile myRoot;

        private RecursiveCheckAdder(VirtualFile root) {
            this.myRoot = root;
            this.myToBeAdded = new HashSet<FilePath>();
        }

        public void process(FilePath path) {
            for (FilePath current = path; current != null; current = current.getParentPath()) {
                VirtualFile vf = current.getVirtualFile();
                if (vf == null) {
                    vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(current.getPath());
                }
                if (vf == null) {
                    return;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)this.myRoot, (VirtualFile)vf, (boolean)true)) {
                    return;
                }
                this.myToBeAdded.add(current);
            }
        }

        public List<FilePath> getToBeAdded() {
            return new ArrayList<FilePath>(this.myToBeAdded);
        }
    }
}

