/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFactoryImpl
extends EditorFactory
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFactoryImpl");
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);
    private final List<Editor> myEditors = ContainerUtil.createLockFreeCopyOnWriteList();

    public EditorFactoryImpl(EditorActionManager editorActionManager) {
        Application application = ApplicationManager.getApplication();
        MessageBus bus = application.getMessageBus();
        MessageBusConnection connect = bus.connect();
        connect.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void beforeProjectLoaded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                Disposer.register((Disposable)project, () -> {
                    Project[] openProjects;
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    boolean isLastProjectClosed = (openProjects = ProjectManager.getInstance().getOpenProjects()).length == 0;
                    EditorFactoryImpl.this.validateEditorsAreReleased(project, isLastProjectClosed);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFactoryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeProjectLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$beforeProjectLoaded$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                EditorFactoryImpl.this.refreshAllEditors();
            }
        });
        TypedAction typedAction = editorActionManager.getTypedAction();
        TypedActionHandler originalHandler = typedAction.getRawHandler();
        typedAction.setupRawHandler((TypedActionHandler)new MyTypedHandler(originalHandler));
    }

    public void initComponent() {
        ModalityStateListener myModalityStateListener = entering -> {
            for (Editor editor : this.myEditors) {
                ((EditorImpl)editor).beforeModalityStateChanged();
            }
        };
        LaterInvocator.addModalityStateListener(myModalityStateListener, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateEditorsAreReleased(Project project, boolean isLastProjectClosed) {
        for (Editor editor : this.myEditors) {
            if (editor.getProject() != project && (editor.getProject() != null || !isLastProjectClosed)) continue;
            try {
                EditorFactoryImpl.throwNotReleasedError(editor);
            }
            finally {
                this.releaseEditor(editor);
            }
        }
    }

    @NonNls
    public static void throwNotReleasedError(@NotNull Editor editor) {
        if (editor == null) {
            EditorFactoryImpl.$$$reportNull$$$0(0);
        }
        if (!(editor instanceof EditorImpl)) {
            throw new RuntimeException("Editor of " + editor.getClass() + " and the following text hasn't been released:\n" + editor.getDocument().getText());
        }
        ((EditorImpl)editor).throwEditorNotDisposedError("Editor of " + editor.getClass() + " hasn't been released:");
    }

    @NotNull
    public Document createDocument(@NotNull char[] text) {
        if (text == null) {
            EditorFactoryImpl.$$$reportNull$$$0(1);
        }
        Document document = this.createDocument((CharSequence)new CharArrayCharSequence(text));
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(2);
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text) {
        if (text == null) {
            EditorFactoryImpl.$$$reportNull$$$0(3);
        }
        DocumentImpl document = new DocumentImpl(text);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(4);
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl("", allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(5);
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text, boolean acceptsSlashR, boolean allowUpdatesWithoutWriteAction) {
        if (text == null) {
            EditorFactoryImpl.$$$reportNull$$$0(6);
        }
        DocumentImpl document = new DocumentImpl(text, acceptsSlashR, allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(7);
        }
        return documentImpl;
    }

    public void refreshAllEditors() {
        for (Editor editor : this.myEditors) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public Editor createEditor(@NotNull Document document) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(8);
        }
        return this.createEditor(document, false, null, EditorKind.UNTYPED);
    }

    public Editor createViewer(@NotNull Document document) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(9);
        }
        return this.createEditor(document, true, null, EditorKind.UNTYPED);
    }

    public Editor createEditor(@NotNull Document document, Project project) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(10);
        }
        return this.createEditor(document, false, project, EditorKind.UNTYPED);
    }

    public Editor createEditor(@NotNull Document document, @Nullable Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(11);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(12);
        }
        return this.createEditor(document, false, project, kind);
    }

    public Editor createViewer(@NotNull Document document, Project project) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(13);
        }
        return this.createEditor(document, true, project, EditorKind.UNTYPED);
    }

    public Editor createViewer(@NotNull Document document, @Nullable Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(15);
        }
        return this.createEditor(document, true, project, kind);
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull FileType fileType, boolean isViewer) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            EditorFactoryImpl.$$$reportNull$$$0(17);
        }
        Editor editor = this.createEditor(document, isViewer, project, EditorKind.UNTYPED);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file2, boolean isViewer) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(19);
        }
        Editor editor = this.createEditor(document, isViewer, project, EditorKind.UNTYPED);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file2, boolean isViewer, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(21);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(22);
        }
        Editor editor = this.createEditor(document, isViewer, project, kind);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2));
        return editor;
    }

    private Editor createEditor(@NotNull Document document, boolean isViewer, Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(24);
        }
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor = new EditorImpl(hostDocument, isViewer, project, kind);
        this.myEditors.add(editor);
        this.myEditorEventMulticaster.registerEditor(editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(new EditorFactoryEvent((EditorFactory)this, (Editor)editor));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editors after create: " + this.myEditors.size());
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEditor(@NotNull Editor editor) {
        if (editor == null) {
            EditorFactoryImpl.$$$reportNull$$$0(25);
        }
        try {
            ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(new EditorFactoryEvent((EditorFactory)this, editor));
        }
        finally {
            try {
                ((EditorImpl)editor).release();
            }
            finally {
                this.myEditors.remove(editor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("number of Editors after release: " + this.myEditors.size());
                }
            }
        }
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document, Project project) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(26);
        }
        List list2 = null;
        for (Editor editor : this.myEditors) {
            Project project1 = editor.getProject();
            if (!editor.getDocument().equals(document) || project != null && project1 != null && !project1.equals(project)) continue;
            if (list2 == null) {
                list2 = new SmartList();
            }
            list2.add(editor);
        }
        Editor[] editorArray = list2 == null ? Editor.EMPTY_ARRAY : list2.toArray(new Editor[list2.size()]);
        if (editorArray == null) {
            EditorFactoryImpl.$$$reportNull$$$0(27);
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(28);
        }
        Editor[] editorArray = this.getEditors(document, null);
        if (editorArray == null) {
            EditorFactoryImpl.$$$reportNull$$$0(29);
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getAllEditors() {
        Editor[] editorArray = (Editor[])ArrayUtil.stripTrailingNulls((Object[])this.myEditors.toArray(new Editor[this.myEditors.size()]));
        if (editorArray == null) {
            EditorFactoryImpl.$$$reportNull$$$0(30);
        }
        return editorArray;
    }

    @Deprecated
    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(31);
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2);
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(32);
        }
        if (parentDisposable == null) {
            EditorFactoryImpl.$$$reportNull$$$0(33);
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Deprecated
    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(34);
        }
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        EditorEventMulticasterImpl editorEventMulticasterImpl = this.myEditorEventMulticaster;
        if (editorEventMulticasterImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(35);
        }
        return editorEventMulticasterImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 27: 
            case 29: 
            case 30: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 27: 
            case 29: 
            case 30: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 27: 
            case 29: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorFactoryImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: 
            case 15: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFactoryImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMulticaster";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "throwNotReleasedError";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 27: 
            case 29: 
            case 30: 
            case 35: {
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createViewer";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "releaseEditor";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addEditorFactoryListener";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorFactoryListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 27: 
            case 29: 
            case 30: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTypedHandler
    implements TypedActionHandlerEx {
        private final TypedActionHandler myDelegate;

        private MyTypedHandler(TypedActionHandler delegate) {
            this.myDelegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                MyTypedHandler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyTypedHandler.$$$reportNull$$$0(1);
            }
            editor.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, (Object)Boolean.TRUE);
            try {
                this.myDelegate.execute(editor, charTyped, dataContext);
            }
            finally {
                editor.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, null);
            }
        }

        public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
            if (editor == null) {
                MyTypedHandler.$$$reportNull$$$0(2);
            }
            if (context == null) {
                MyTypedHandler.$$$reportNull$$$0(3);
            }
            if (plan == null) {
                MyTypedHandler.$$$reportNull$$$0(4);
            }
            if (this.myDelegate instanceof TypedActionHandlerEx) {
                ((TypedActionHandlerEx)this.myDelegate).beforeExecute(editor, c, context, plan);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plan";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyTypedHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

