/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CacheOneStepIterator;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowDiffFromAnnotation
extends DumbAwareAction
implements UpToDateLineNumberListener {
    private final FileAnnotation myFileAnnotation;
    private final AbstractVcs myVcs;
    private final VirtualFile myFile;
    private int currentLine;
    private boolean myEnabled;
    private static final int ourVicinity = 5;

    ShowDiffFromAnnotation(FileAnnotation fileAnnotation, AbstractVcs vcs, VirtualFile file2) {
        ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
        this.myFileAnnotation = fileAnnotation;
        this.myVcs = vcs;
        this.myFile = file2;
        this.currentLine = -1;
        this.myEnabled = ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).getVcsFor(this.myFile) != null;
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    public void update(AnActionEvent e) {
        int number = this.currentLine;
        e.getPresentation().setVisible(this.myEnabled);
        e.getPresentation().setEnabled(this.myEnabled && number >= 0 && number < this.myFileAnnotation.getLineCount());
    }

    public void actionPerformed(AnActionEvent e) {
        final int actualNumber = this.currentLine;
        if (actualNumber < 0) {
            return;
        }
        final VcsRevisionNumber revisionNumber = this.myFileAnnotation.getLineRevisionNumber(actualNumber);
        if (revisionNumber != null) {
            final VcsException[] exc = new VcsException[1];
            final LinkedList changes = new LinkedList();
            final FilePath[] targetPath = new FilePath[1];
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myVcs.getProject(), "Loading revision " + revisionNumber.asString() + " contents", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CommittedChangesProvider provider = ShowDiffFromAnnotation.this.myVcs.getCommittedChangesProvider();
                    try {
                        Pair pair = provider.getOneList(ShowDiffFromAnnotation.this.myFile, revisionNumber);
                        if (pair == null || pair.getFirst() == null) {
                            VcsBalloonProblemNotifier.showOverChangesView(ShowDiffFromAnnotation.this.myVcs.getProject(), "Can not load data for show diff", MessageType.ERROR, new NamedRunnable[0]);
                            return;
                        }
                        targetPath[0] = pair.getSecond() == null ? VcsUtil.getFilePath((VirtualFile)ShowDiffFromAnnotation.this.myFile) : (FilePath)pair.getSecond();
                        CommittedChangeList cl = (CommittedChangeList)pair.getFirst();
                        changes.addAll(cl.getChanges());
                        Collections.sort(changes, ChangesComparator.getInstance(true));
                    }
                    catch (VcsException e1) {
                        exc[0] = e1;
                    }
                }

                public void onSuccess() {
                    if (exc[0] != null) {
                        VcsBalloonProblemNotifier.showOverChangesView(ShowDiffFromAnnotation.this.myVcs.getProject(), "Can not show diff: " + exc[0].getMessage(), MessageType.ERROR, new NamedRunnable[0]);
                    } else if (!changes.isEmpty()) {
                        int idx = ShowDiffFromAnnotation.findSelfInList(changes, targetPath[0]);
                        ShowDiffContext context = new ShowDiffContext(DiffDialogHints.FRAME);
                        if (idx != -1) {
                            context.putChangeContext((Change)changes.get(idx), DiffUserDataKeysEx.NAVIGATION_CONTEXT, ShowDiffFromAnnotation.this.createDiffNavigationContext(actualNumber));
                        }
                        if (ChangeListManager.getInstance((Project)ShowDiffFromAnnotation.this.myVcs.getProject()).isFreezedWithNotification(null)) {
                            return;
                        }
                        ShowDiffAction.showDiffForChange(ShowDiffFromAnnotation.this.myVcs.getProject(), (Iterable<Change>)changes, idx, context);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$1", "run"));
                }
            });
        }
    }

    private static int findSelfInList(@NotNull List<Change> changes, @NotNull FilePath filePath) {
        if (changes == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(1);
        }
        int idx = -1;
        for (int i = 0; i < changes.size(); ++i) {
            Change change = changes.get(i);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().equals(filePath)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            return idx;
        }
        idx = 0;
        String name = filePath.getName();
        for (int i = 0; i < changes.size(); ++i) {
            Change change = changes.get(i);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().getName().equals(name)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Nullable
    private DiffNavigationContext createDiffNavigationContext(int actualLine) {
        String annotatedContent = this.myFileAnnotation.getAnnotatedContent();
        if (StringUtil.isEmptyOrSpaces((String)annotatedContent)) {
            return null;
        }
        final String[] contentsLines = LineTokenizer.tokenize((CharSequence)annotatedContent, (boolean)false, (boolean)false);
        if (contentsLines.length <= actualLine) {
            return null;
        }
        final int correctedLine = this.correctActualLineIfTextEmpty(contentsLines, actualLine);
        return new DiffNavigationContext((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new CacheOneStepIterator((Iterator)new ContextLineIterator(contentsLines, ShowDiffFromAnnotation.this.myFileAnnotation, correctedLine));
            }
        }, contentsLines[correctedLine]);
    }

    private int correctActualLineIfTextEmpty(@NotNull String[] contentsLines, int actualLine) {
        VcsRevisionNumber revision;
        if (contentsLines == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(2);
        }
        if ((revision = this.myFileAnnotation.getLineRevisionNumber(actualLine)) == null) {
            return actualLine;
        }
        if (!StringUtil.isEmptyOrSpaces((String)contentsLines[actualLine])) {
            return actualLine;
        }
        int upperBound = Math.min(actualLine + 5, contentsLines.length);
        for (int i = actualLine + 1; i < upperBound; ++i) {
            if (!revision.equals(this.myFileAnnotation.getLineRevisionNumber(i)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i])) continue;
            return i;
        }
        int lowerBound = Math.max(actualLine - 5, 0);
        for (int i = actualLine - 1; i >= lowerBound; --i) {
            if (!revision.equals(this.myFileAnnotation.getLineRevisionNumber(i)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i])) continue;
            return i;
        }
        return actualLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsLines";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSelfInList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "correctActualLineIfTextEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContextLineIterator
    implements Iterator<String> {
        @NotNull
        private final String[] myContentsLines;
        private final VcsRevisionNumber myRevisionNumber;
        @NotNull
        private final FileAnnotation myAnnotation;
        private final int myStopAtLine;
        private int myCurrentLine;

        private ContextLineIterator(@NotNull String[] contentLines, @NotNull FileAnnotation annotation, int stopAtLine) {
            if (contentLines == null) {
                ContextLineIterator.$$$reportNull$$$0(0);
            }
            if (annotation == null) {
                ContextLineIterator.$$$reportNull$$$0(1);
            }
            this.myAnnotation = annotation;
            this.myRevisionNumber = this.myAnnotation.originalRevision(stopAtLine);
            this.myStopAtLine = stopAtLine;
            this.myContentsLines = contentLines;
        }

        @Override
        public boolean hasNext() {
            return this.myRevisionNumber != null && this.lineNumberInBounds();
        }

        private boolean lineNumberInBounds() {
            return this.myCurrentLine < this.myContentsLines.length && this.myCurrentLine < this.myStopAtLine;
        }

        @Override
        public String next() {
            while (this.lineNumberInBounds()) {
                VcsRevisionNumber vcsRevisionNumber = this.myAnnotation.originalRevision(this.myCurrentLine);
                String text = this.myContentsLines[this.myCurrentLine];
                ++this.myCurrentLine;
                if (!this.myRevisionNumber.equals(vcsRevisionNumber) || StringUtil.isEmptyOrSpaces((String)text)) continue;
                return text;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contentLines";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$ContextLineIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

