/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public ReformatBeforeCheckinHandler(Project project, CheckinProjectPanel panel2) {
        this.myProject = project;
        this.myPanel = panel2;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        NonFocusableCheckBox reformatBox = new NonFocusableCheckBox(VcsBundle.message((String)"checkbox.checkin.options.reformat.code", (Object[])new Object[0]));
        CheckinHandlerUtil.disableWhenDumb(this.myProject, (JCheckBox)reformatBox, "Impossible until indices are up-to-date");
        return new RefreshableOnComponent((JCheckBox)reformatBox){
            final /* synthetic */ JCheckBox val$reformatBox;
            {
                this.val$reformatBox = jCheckBox;
            }

            public JComponent getComponent() {
                JPanel panel2 = new JPanel(new GridLayout(1, 0));
                panel2.add(this.val$reformatBox);
                return panel2;
            }

            public void refresh() {
            }

            public void saveState() {
                ReformatBeforeCheckinHandler.this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT = this.val$reformatBox.isSelected();
            }

            public void restoreState() {
                this.val$reformatBox.setSelected(ReformatBeforeCheckinHandler.this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(@NotNull Runnable finishAction) {
        if (finishAction == null) {
            ReformatBeforeCheckinHandler.$$$reportNull$$$0(0);
        }
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        Collection files = this.myPanel.getVirtualFiles();
        Runnable performCheckoutAction = () -> {
            if (finishAction == null) {
                ReformatBeforeCheckinHandler.$$$reportNull$$$0(1);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            finishAction.run();
        };
        if (configuration.REFORMAT_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
            new ReformatCodeProcessor(this.myProject, CheckinHandlerUtil.getPsiFiles(this.myProject, files), FormatterUtil.REFORMAT_BEFORE_COMMIT_COMMAND_NAME, performCheckoutAction, true).run();
        } else {
            performCheckoutAction.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "finishAction";
        objectArray2[1] = "com/intellij/openapi/vcs/checkin/ReformatBeforeCheckinHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runCheckinHandlers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runCheckinHandlers$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

