/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackLineStatusAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (tracker == null || !tracker.isValid() || !tracker.isAvailableAt(editor)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!RollbackLineStatusAction.isSomeChangeSelected(editor, tracker)) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        assert (tracker != null);
        RollbackLineStatusAction.rollback(tracker, editor, null);
    }

    protected static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTracker tracker) {
        List carets;
        if (editor == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(0);
        }
        if (tracker == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(1);
        }
        if ((carets = editor.getCaretModel().getAllCarets()).size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        if (caret.getOffset() == editor.getDocument().getTextLength() && tracker.getRangeForLine(editor.getDocument().getLineCount()) != null) {
            return true;
        }
        return tracker.getRangeForLine(caret.getLogicalPosition().line) != null;
    }

    protected static void rollback(@NotNull LineStatusTracker tracker, @Nullable Editor editor, @Nullable Range range) {
        if (tracker == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(2);
        }
        assert (editor != null || range != null);
        if (range != null) {
            if (editor != null) {
                DiffUtil.moveCaretToLineRangeIfNeeded(editor, range.getLine1(), range.getLine2());
            }
            RollbackLineStatusAction.doRollback(tracker, range);
            return;
        }
        RollbackLineStatusAction.doRollback(tracker, DiffUtil.getSelectedLines(editor));
    }

    private static void doRollback(@NotNull LineStatusTracker tracker, @NotNull Range range) {
        if (tracker == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(3);
        }
        if (range == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(4);
        }
        RollbackLineStatusAction.execute(tracker, () -> {
            if (tracker == null) {
                RollbackLineStatusAction.$$$reportNull$$$0(11);
            }
            if (range == null) {
                RollbackLineStatusAction.$$$reportNull$$$0(12);
            }
            tracker.rollbackChanges(range);
        });
    }

    private static void doRollback(@NotNull LineStatusTracker tracker, @NotNull BitSet lines2) {
        if (tracker == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(5);
        }
        if (lines2 == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(6);
        }
        RollbackLineStatusAction.execute(tracker, () -> {
            if (tracker == null) {
                RollbackLineStatusAction.$$$reportNull$$$0(9);
            }
            if (lines2 == null) {
                RollbackLineStatusAction.$$$reportNull$$$0(10);
            }
            tracker.rollbackChanges(lines2);
        });
    }

    private static void execute(@NotNull LineStatusTracker tracker, @NotNull Runnable task2) {
        if (tracker == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(7);
        }
        if (task2 == null) {
            RollbackLineStatusAction.$$$reportNull$$$0(8);
        }
        DiffUtil.executeWriteCommand(tracker.getDocument(), tracker.getProject(), VcsBundle.message((String)"command.name.rollback.change", (Object[])new Object[0]), task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/ex/RollbackLineStatusAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSomeChangeSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rollback";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doRollback";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRollback$1";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doRollback$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

