/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.psi.PyDocStringOwner;
import org.jetbrains.annotations.NotNull;

public class PythonSpaceHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            PythonSpaceHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PythonSpaceHandler.$$$reportNull$$$0(1);
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (c == ' ' && codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            PyDocStringOwner docOwner;
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset);
            if (element == null && offset > 1) {
                element = file2.findElementAt(offset - 2);
            }
            if (element == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            int expectedStringStart = offset - 4;
            Document document = editor.getDocument();
            if (PythonEnterHandler.canGenerateDocstring(element, expectedStringStart, document) == PythonEnterHandler.DocstringState.INCOMPLETE && (docOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class)) != null) {
                String quotes = document.getText(TextRange.from((int)expectedStringStart, (int)3));
                String docString = PyDocstringGenerator.forDocStringOwner(docOwner).forceNewMode().withInferredParameters(true).withQuotes(quotes).buildDocString();
                document.insertString(offset, (CharSequence)docString.substring(3));
                if (!StringUtil.isEmptyOrSpaces((String)docString.substring(3, docString.length() - 3))) {
                    editor.getCaretModel().moveCaretRelatively(100, 1, false, false, false);
                }
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/editor/PythonSpaceHandler";
        objectArray[2] = "charTyped";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

