/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyCreatePropertyQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.toolbox.Maybe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyPropertyAccessInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.property.access", new Object[0]);
        if (string == null) {
            PyPropertyAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyPropertyAccessInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyPropertyAccessInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyPropertyAccessInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPropertyAccessInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPropertyAccessInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private final HashMap<Pair<PyClass, String>, Property> myPropertyCache;

        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session2) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
            this.myPropertyCache = new HashMap();
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            super.visitPyReferenceExpression(node);
            this.checkPropertyExpression(node);
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            this.checkPropertyExpression(node);
        }

        private void checkPropertyExpression(PyQualifiedExpression node) {
            PyType type;
            PyExpression qualifier = node.getQualifier();
            if (qualifier != null && (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType) {
                PyClass cls = ((PyClassType)type).getPyClass();
                String name = node.getName();
                if (name != null) {
                    Pair key = Pair.create((Object)cls, (Object)name);
                    Property property = this.myPropertyCache.containsKey((Object)key) ? (Property)this.myPropertyCache.get((Object)key) : cls.findProperty(name, true, this.myTypeEvalContext);
                    this.myPropertyCache.put((Object)key, (Object)property);
                    if (property != null) {
                        PsiElement parent;
                        AccessDirection dir = AccessDirection.of(node);
                        this.checkAccessor(node, name, dir, property);
                        if (dir == AccessDirection.READ && (parent = node.getParent()) instanceof PyAugAssignmentStatement && ((PyAugAssignmentStatement)parent).getTarget() == node) {
                            this.checkAccessor(node, name, AccessDirection.WRITE, property);
                        }
                    }
                }
            }
        }

        private void checkAccessor(PyExpression node, String name, AccessDirection dir, Property property) {
            Maybe<PyCallable> accessor = property.getByDirection(dir);
            if (accessor.isDefined() && accessor.value() == null) {
                String message = dir == AccessDirection.WRITE ? PyBundle.message("INSP.property.$0.cant.be.set", name) : (dir == AccessDirection.DELETE ? PyBundle.message("INSP.property.$0.cant.be.deleted", name) : PyBundle.message("INSP.property.$0.cant.be.read", name));
                this.registerProblem((PsiElement)node, message, new PyCreatePropertyQuickFix(dir));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPropertyAccessInspection$Visitor", "<init>"));
        }
    }
}

