/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyMembersRefactoringBaseProcessor;
import com.jetbrains.python.refactoring.classes.pushDown.PyPushDownHandler;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPushDownProcessor
extends PyMembersRefactoringBaseProcessor {
    private static final String HEADER = RefactoringBundle.message((String)"push.down.members.elements.header", (Object[])new Object[]{""});

    public PyPushDownProcessor(@NotNull Project project, @NotNull Collection<PyMemberInfo<PyElement>> membersToMove, @NotNull PyClass from) {
        if (project == null) {
            PyPushDownProcessor.$$$reportNull$$$0(0);
        }
        if (membersToMove == null) {
            PyPushDownProcessor.$$$reportNull$$$0(1);
        }
        if (from == null) {
            PyPushDownProcessor.$$$reportNull$$$0(2);
        }
        super(project, membersToMove, from, PyPushDownProcessor.getChildren(from));
    }

    @NotNull
    private static PyClass[] getChildren(@NotNull PyClass from) {
        if (from == null) {
            PyPushDownProcessor.$$$reportNull$$$0(3);
        }
        Collection<PyClass> all = PyPushDownProcessor.getInheritors(from);
        PyClass[] pyClassArray = all.toArray(new PyClass[all.size()]);
        if (pyClassArray == null) {
            PyPushDownProcessor.$$$reportNull$$$0(4);
        }
        return pyClassArray;
    }

    @NotNull
    static Collection<PyClass> getInheritors(@NotNull PyClass from) {
        if (from == null) {
            PyPushDownProcessor.$$$reportNull$$$0(5);
        }
        Collection collection = PyClassInheritorsSearch.search(from, false).findAll();
        if (collection == null) {
            PyPushDownProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public String getProcessedElementsHeader() {
        return HEADER;
    }

    public String getCodeReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"classes.to.push.down.members.to", (Object[])new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)});
    }

    @Nullable
    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return null;
    }

    @Override
    protected String getCommandName() {
        return PyPushDownHandler.REFACTORING_NAME;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.python.push.down";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/pushDown/PyPushDownProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInheritors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

