/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.extenstions.NameAndElement;
import com.jetbrains.extenstions.QNameResolveContext;
import com.jetbrains.extenstions.QualifiedNameExtKt;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.ConfigField;
import com.jetbrains.python.testing.ConfigurationTarget$WhenMappings;
import com.jetbrains.python.testing.PyAbstractTestConfiguration;
import com.jetbrains.python.testing.PyQNameResolveAndSplitUtilsKt;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.python.testing.QualifiedNameParts;
import com.jetbrains.python.testing.TestTargetType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0000J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010%\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R$\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/jetbrains/python/testing/ConfigurationTarget;", "", "target", "", "targetType", "Lcom/jetbrains/python/testing/TestTargetType;", "(Ljava/lang/String;Lcom/jetbrains/python/testing/TestTargetType;)V", "target$annotations", "()V", "getTarget", "()Ljava/lang/String;", "setTarget", "(Ljava/lang/String;)V", "targetType$annotations", "getTargetType", "()Lcom/jetbrains/python/testing/TestTargetType;", "setTargetType", "(Lcom/jetbrains/python/testing/TestTargetType;)V", "asPsiElement", "Lcom/intellij/psi/PsiElement;", "configuration", "Lcom/jetbrains/python/testing/PyAbstractTestConfiguration;", "asVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkValid", "", "component1", "component2", "copy", "copyTo", "dst", "equals", "", "other", "generateArgumentsLine", "", "getArgumentsForPythonTarget", "getElementDirectory", "hashCode", "", "toString", "python-community"})
public final class ConfigurationTarget {
    @NotNull
    private String target;
    @NotNull
    private TestTargetType targetType;

    public final void copyTo(@NotNull ConfigurationTarget dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        dst.target = this.target;
        dst.targetType = this.targetType;
    }

    public final void checkValid() {
        CharSequence charSequence;
        if (Intrinsics.areEqual((Object)((Object)this.targetType), (Object)((Object)TestTargetType.CUSTOM)) ^ true && (charSequence = (CharSequence)this.target).length() == 0) {
            throw (Throwable)new RuntimeConfigurationWarning("Target not provided");
        }
        if (Intrinsics.areEqual((Object)((Object)this.targetType), (Object)((Object)TestTargetType.PYTHON)) && !new Regex("^[a-zA-Z0-9._]+[a-zA-Z0-9_]$").matches((CharSequence)this.target)) {
            throw (Throwable)new RuntimeConfigurationWarning("Provide a qualified name of function, class or a module");
        }
    }

    @Nullable
    public final PsiElement asPsiElement(@NotNull PyAbstractTestConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        if (Intrinsics.areEqual((Object)((Object)this.targetType), (Object)((Object)TestTargetType.PYTHON))) {
            Module module2 = configuration.getModule();
            if (module2 == null) {
                return null;
            }
            Module module3 = module2;
            TypeEvalContext context = TypeEvalContext.userInitiated(configuration.getProject(), null);
            VirtualFile workDir = configuration.getWorkingDirectoryAsVirtual$python_community();
            QualifiedName name = QualifiedName.fromDottedString((String)this.target);
            Module module4 = module3;
            Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
            Sdk sdk = configuration.getSdk();
            TypeEvalContext typeEvalContext = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"context");
            return QualifiedNameExtKt.resolveToElement$default(name, new QNameResolveContext(module4, sdk, typeEvalContext, workDir, true), false, 2, null);
        }
        return null;
    }

    @Nullable
    public final VirtualFile asVirtualFile() {
        if (Intrinsics.areEqual((Object)((Object)this.targetType), (Object)((Object)TestTargetType.PATH))) {
            return LocalFileSystem.getInstance().findFileByPath(this.target);
        }
        return null;
    }

    @NotNull
    public final List<String> generateArgumentsLine(@NotNull PyAbstractTestConfiguration configuration) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        switch (ConfigurationTarget$WhenMappings.$EnumSwitchMapping$0[this.targetType.ordinal()]) {
            case 1: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list2 = this.getArgumentsForPythonTarget(configuration);
                break;
            }
            case 3: {
                String string;
                Object[] objectArray = new String[2];
                objectArray[0] = "--path";
                String string2 = this.target;
                int n = 1;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                objectArray2[n] = string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                list2 = CollectionsKt.listOf((Object[])objectArray3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<String> getArgumentsForPythonTarget(PyAbstractTestConfiguration configuration) {
        String fileSystemPartOfTarget;
        String string;
        PsiElement psiElement = this.asPsiElement(configuration);
        if (psiElement == null) {
            throw (Throwable)new ExecutionException("Can't resolve " + this.target + ". Try to remove configuration and generate it again");
        }
        PsiElement element = psiElement;
        if (element instanceof PsiDirectory) {
            Object[] objectArray = new String[2];
            objectArray[0] = "--path";
            String string2 = ((PsiDirectory)element).getVirtualFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.virtualFile.path");
            objectArray[1] = string2;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(configuration.getProject(), null);
        Module module2 = configuration.getModule();
        if (module2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"configuration.module!!");
        TypeEvalContext typeEvalContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"context");
        QNameResolveContext qNameResolveContext = new QNameResolveContext(module2, null, typeEvalContext, LocalFileSystem.getInstance().findFileByPath(configuration.getWorkingDirectorySafe()), true, 2, null);
        String string3 = string = this.target;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        QualifiedNameParts qualifiedNameParts = PyQNameResolveAndSplitUtilsKt.tryResolveAndSplit(QualifiedName.fromDottedString((String)((Object)StringsKt.trim((CharSequence)string3)).toString()), qNameResolveContext);
        if (qualifiedNameParts == null) {
            throw (Throwable)new ExecutionException("Can't find file where " + this.target + " declared. " + "Make sure it is in project root");
        }
        QualifiedNameParts qualifiedNameParts2 = qualifiedNameParts;
        if (!configuration.shouldSeparateTargetPath$python_community()) {
            PyFile pyFile;
            QualifiedName qNameInsideOfDirectory = QualifiedNameParts.getElementNamePrependingFile$default(qualifiedNameParts2, null, 1, null);
            NameAndElement elementAndName = QualifiedNameExtKt.getElementAndResolvableName$default(qNameInsideOfDirectory, QNameResolveContext.copy$default(qNameResolveContext, null, null, null, null, false, 15, null), false, 2, null);
            if (elementAndName != null) {
                Object[] objectArray = new String[2];
                objectArray[0] = "--target";
                String string4 = elementAndName.getName().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"elementAndName.name.toString()");
                objectArray[1] = string4;
                return CollectionsKt.listOf((Object[])objectArray);
            }
            PsiFile psiFile = element.getContainingFile();
            if (!(psiFile instanceof PyFile)) {
                psiFile = null;
            }
            if ((pyFile = (PyFile)psiFile) == null || (pyFile = PsiFileSystemItemExtKt.getQName((PsiFileSystemItem)pyFile)) == null || (pyFile = pyFile.append(qualifiedNameParts2.getElementName())) == null) {
                throw (Throwable)new ExecutionException("Can't get importable name for " + element.getContainingFile() + ". Is it a python file in project?");
            }
            PyFile name = pyFile;
            Object[] objectArray = new String[2];
            objectArray[0] = "--target";
            String string5 = name.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"name.toString()");
            objectArray[1] = string5;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        QualifiedName pyTarget = qualifiedNameParts2.getElementName();
        VirtualFile elementFile = element.getContainingFile().getVirtualFile();
        VirtualFile workingDir = elementFile.getFileSystem().findFileByPath(configuration.getWorkingDirectorySafe());
        String string6 = workingDir != null ? VfsUtil.getRelativePath((VirtualFile)elementFile, (VirtualFile)workingDir) : null;
        if (string6 == null) {
            string6 = fileSystemPartOfTarget = elementFile.getPath();
        }
        if (pyTarget.getComponentCount() == 0) {
            Object[] objectArray = new String[2];
            objectArray[0] = "--path";
            String string7 = fileSystemPartOfTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"fileSystemPartOfTarget");
            objectArray[1] = string7;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        return CollectionsKt.listOf((Object[])new String[]{"--target", "" + fileSystemPartOfTarget + "::" + pyTarget});
    }

    @Nullable
    public final VirtualFile getElementDirectory(@NotNull PyAbstractTestConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        if (Intrinsics.areEqual((Object)this.target, (Object)PyTestsSharedKt.access$getDEFAULT_PATH$p())) {
            return null;
        }
        Object object = this.asVirtualFile();
        if (object == null) {
            PsiElement psiElement = this.asPsiElement(configuration);
            object = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
        }
        if (object == null) {
            return null;
        }
        VirtualFile fileOrDir = object;
        return fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
    }

    @ConfigField
    public static /* synthetic */ void target$annotations() {
    }

    @NotNull
    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.target = string;
    }

    @ConfigField
    public static /* synthetic */ void targetType$annotations() {
    }

    @NotNull
    public final TestTargetType getTargetType() {
        return this.targetType;
    }

    public final void setTargetType(@NotNull TestTargetType testTargetType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)testTargetType), (String)"<set-?>");
        this.targetType = testTargetType;
    }

    public ConfigurationTarget(@NotNull String target2, @NotNull TestTargetType targetType) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetType), (String)"targetType");
        this.target = target2;
        this.targetType = targetType;
    }

    @NotNull
    public final String component1() {
        return this.target;
    }

    @NotNull
    public final TestTargetType component2() {
        return this.targetType;
    }

    @NotNull
    public final ConfigurationTarget copy(@NotNull String target2, @NotNull TestTargetType targetType) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetType), (String)"targetType");
        return new ConfigurationTarget(target2, targetType);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ConfigurationTarget copy$default(ConfigurationTarget configurationTarget, String string, TestTargetType testTargetType, int n, Object object) {
        if ((n & 1) != 0) {
            string = configurationTarget.target;
        }
        if ((n & 2) != 0) {
            testTargetType = configurationTarget.targetType;
        }
        return configurationTarget.copy(string, testTargetType);
    }

    public String toString() {
        return "ConfigurationTarget(target=" + this.target + ", targetType=" + (Object)((Object)this.targetType) + ")";
    }

    public int hashCode() {
        String string = this.target;
        TestTargetType testTargetType = this.targetType;
        return (string != null ? string.hashCode() : 0) * 31 + (testTargetType != null ? ((Object)((Object)testTargetType)).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ConfigurationTarget)) break block3;
                ConfigurationTarget configurationTarget = (ConfigurationTarget)object;
                if (!Intrinsics.areEqual((Object)this.target, (Object)configurationTarget.target) || !Intrinsics.areEqual((Object)((Object)this.targetType), (Object)((Object)configurationTarget.targetType))) break block3;
            }
            return true;
        }
        return false;
    }
}

