/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.validation.PyAnnotator;

public class AssignTargetAnnotator
extends PyAnnotator {
    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        for (PyExpression expression : node.getRawTargets()) {
            expression.accept(new ExprVisitor(Operation.Assign));
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
        node.getTarget().accept(new ExprVisitor(Operation.AugAssign));
    }

    @Override
    public void visitPyDelStatement(PyDelStatement node) {
        ExprVisitor visitor2 = new ExprVisitor(Operation.Delete);
        for (PyExpression expr : node.getTargets()) {
            expr.accept(visitor2);
        }
    }

    @Override
    public void visitPyExceptBlock(PyExceptPart node) {
        PyExpression target2 = node.getTarget();
        if (target2 != null) {
            target2.accept(new ExprVisitor(Operation.Except));
        }
    }

    @Override
    public void visitPyForStatement(PyForStatement node) {
        PyExpression target2 = node.getForPart().getTarget();
        if (target2 != null) {
            target2.accept(new ExprVisitor(Operation.For));
        }
    }

    @Override
    public void visitPyWithItem(PyWithItem node) {
        PyExpression target2 = node.getTarget();
        if (target2 != null) {
            target2.accept(new ExprVisitor(Operation.With));
        }
    }

    private class ExprVisitor
    extends PyElementVisitor {
        private final Operation myOp;
        private final String DELETING_NONE = PyBundle.message("ANN.deleting.none", new Object[0]);
        private final String ASSIGNMENT_TO_NONE = PyBundle.message("ANN.assign.to.none", new Object[0]);
        private final String CANT_ASSIGN_TO_FUNCTION_CALL = PyBundle.message("ANN.cant.assign.to.call", new Object[0]);
        private final String CANT_DELETE_FUNCTION_CALL = PyBundle.message("ANN.cant.delete.call", new Object[0]);

        public ExprVisitor(Operation op) {
            this.myOp = op;
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            String referencedName = node.getReferencedName();
            if ("None".equals(referencedName)) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, this.myOp == Operation.Delete ? this.DELETING_NONE : this.ASSIGNMENT_TO_NONE);
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            VirtualFile vfile;
            String targetName = node.getName();
            if ("None".equals(targetName) && (vfile = node.getContainingFile().getVirtualFile()) != null && !vfile.getUrl().contains("/python_stubs/")) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, this.myOp == Operation.Delete ? this.DELETING_NONE : this.ASSIGNMENT_TO_NONE);
            }
            if ("__debug__".equals(targetName)) {
                if (LanguageLevel.forElement(node).isPy3K()) {
                    AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, "assignment to keyword");
                } else {
                    AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, "cannot assign to __debug__");
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, this.myOp == Operation.Delete ? this.CANT_DELETE_FUNCTION_CALL : this.CANT_ASSIGN_TO_FUNCTION_CALL);
        }

        @Override
        public void visitPyGeneratorExpression(PyGeneratorExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.generator" : "ANN.cant.assign.to.generator", new Object[0]));
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.operator", new Object[0]));
        }

        @Override
        public void visitPyTupleExpression(PyTupleExpression node) {
            if (node.isEmpty()) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.parens", new Object[0]));
            } else if (this.myOp == Operation.AugAssign) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.aug.assign.to.tuple.or.generator", new Object[0]));
            } else {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression node) {
            if (this.myOp == Operation.AugAssign) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.aug.assign.to.tuple.or.generator", new Object[0]));
            } else {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyListLiteralExpression(PyListLiteralExpression node) {
            if (node.isEmpty()) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.brackets", new Object[0]));
            } else if (this.myOp == Operation.AugAssign) {
                AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.aug.assign.to.list.or.comprh", new Object[0]));
            } else {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyListCompExpression(PyListCompExpression node) {
            AssignTargetAnnotator.this.markError(node, PyBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.comprh" : "ANN.cant.assign.to.comprh", new Object[0]));
        }

        @Override
        public void visitPyDictCompExpression(PyDictCompExpression node) {
            AssignTargetAnnotator.this.markError(node, PyBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.dict.comprh" : "ANN.cant.assign.to.dict.comprh", new Object[0]));
        }

        @Override
        public void visitPySetCompExpression(PySetCompExpression node) {
            AssignTargetAnnotator.this.markError(node, PyBundle.message(this.myOp == Operation.AugAssign ? "ANN.cant.aug.assign.to.set.comprh" : "ANN.cant.assign.to.set.comprh", new Object[0]));
        }

        @Override
        public void visitPyStarExpression(PyStarExpression node) {
            super.visitPyStarExpression(node);
            if (!(node.getParent() instanceof PySequenceExpression)) {
                AssignTargetAnnotator.this.markError((PsiElement)node, "starred assignment target must be in a list or tuple");
            }
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression node) {
            this.checkLiteral(node);
        }

        @Override
        public void visitPySetLiteralExpression(PySetLiteralExpression node) {
            this.checkLiteral(node);
        }

        @Override
        public void visitPyNumericLiteralExpression(PyNumericLiteralExpression node) {
            this.checkLiteral(node);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.checkLiteral(node);
        }

        private void checkLiteral(PyExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message(this.myOp == Operation.Delete ? "ANN.cant.delete.literal" : "ANN.cant.assign.to.literal", new Object[0]));
        }

        @Override
        public void visitPyLambdaExpression(PyLambdaExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.assign.to.lambda", new Object[0]));
        }

        @Override
        public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, "assignment to keyword");
        }

        @Override
        public void visitPyBoolLiteralExpression(PyBoolLiteralExpression node) {
            AssignTargetAnnotator.this.getHolder().createErrorAnnotation((PsiElement)node, "assignment to keyword");
        }
    }

    private static enum Operation {
        Assign,
        AugAssign,
        Delete,
        Except,
        For,
        With;

    }
}

