/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.ui.GithubCreateGistPanel;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubCreateGistDialog
extends DialogWrapper {
    private final GithubCreateGistPanel myGithubCreateGistPanel;

    public GithubCreateGistDialog(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile[] files, @Nullable VirtualFile file) {
        if (project == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myGithubCreateGistPanel = new GithubCreateGistPanel();
        GithubSettings settings = GithubSettings.getInstance();
        this.myGithubCreateGistPanel.setAnonymous(settings.isAnonymousGist());
        this.myGithubCreateGistPanel.setSecret(settings.isPrivateGist());
        this.myGithubCreateGistPanel.setOpenInBrowser(settings.isOpenInBrowserGist());
        if (editor != null) {
            if (file != null) {
                this.myGithubCreateGistPanel.showFileNameField(file.getName());
            } else {
                this.myGithubCreateGistPanel.showFileNameField("");
            }
        } else if (files != null) {
            if (files.length == 1 && !files[0].isDirectory()) {
                this.myGithubCreateGistPanel.showFileNameField(files[0].getName());
            }
        } else if (file != null && !file.isDirectory()) {
            this.myGithubCreateGistPanel.showFileNameField(file.getName());
        }
        this.setTitle("Create Gist");
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myGithubCreateGistPanel.getPanel();
    }

    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    protected void doOKAction() {
        GithubSettings settings = GithubSettings.getInstance();
        settings.setAnonymousGist(this.myGithubCreateGistPanel.isAnonymous());
        settings.setOpenInBrowserGist(this.myGithubCreateGistPanel.isOpenInBrowser());
        settings.setPrivateGist(this.myGithubCreateGistPanel.isSecret());
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGithubCreateGistPanel.getDescriptionTextArea();
    }

    public boolean isSecret() {
        return this.myGithubCreateGistPanel.isSecret();
    }

    public boolean isAnonymous() {
        return this.myGithubCreateGistPanel.isAnonymous();
    }

    @NotNull
    public String getDescription() {
        String string = this.myGithubCreateGistPanel.getDescriptionTextArea().getText();
        if (string == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getFileName() {
        return this.myGithubCreateGistPanel.getFileNameField().getText();
    }

    public boolean isOpenInBrowser() {
        return this.myGithubCreateGistPanel.isOpenInBrowser();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/ui/GithubCreateGistDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/ui/GithubCreateGistDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

