/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitHistoryUtils;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileHistory {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitFileHistory");
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VcsRevisionNumber myStartingRevision;
    @NotNull
    private final GitVersion myVersion;

    private GitFileHistory(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @NotNull VcsRevisionNumber revision) {
        if (project == null) {
            GitFileHistory.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitFileHistory.$$$reportNull$$$0(1);
        }
        if (path == null) {
            GitFileHistory.$$$reportNull$$$0(2);
        }
        if (revision == null) {
            GitFileHistory.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myPath = GitHistoryUtils.getLastCommitName(this.myProject, path);
        this.myStartingRevision = revision;
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        this.myVersion = vcs != null ? vcs.getVersion() : GitVersion.NULL;
    }

    private void load(@NotNull Consumer<GitFileRevision> consumer, @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        if (consumer == null) {
            GitFileHistory.$$$reportNull$$$0(4);
        }
        if (exceptionConsumer == null) {
            GitFileHistory.$$$reportNull$$$0(5);
        }
        GitLogParser logParser = new GitLogParser(this.myProject, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        GitLogRecordConsumer recordConsumer = new GitLogRecordConsumer(consumer, exceptionConsumer);
        String firstCommitParent = this.myStartingRevision.asString();
        FilePath currentPath = this.myPath;
        while (currentPath != null && firstCommitParent != null) {
            recordConsumer.reset(currentPath);
            GitLineHandler handler = this.createLogHandler(logParser, currentPath, firstCommitParent, parameters);
            MyGitLineHandlerAdapter lineListener = new MyGitLineHandlerAdapter(handler, logParser, recordConsumer, exceptionConsumer);
            lineListener.runAndWait();
            if (lineListener.hasCriticalFailure()) {
                return;
            }
            try {
                String firstCommit = recordConsumer.getFirstCommit();
                if (firstCommit == null) {
                    return;
                }
                Pair<String, FilePath> firstCommitParentAndPath = this.getFirstCommitParentAndPathIfRename(firstCommit, currentPath);
                if (firstCommitParentAndPath == null) {
                    return;
                }
                currentPath = (FilePath)firstCommitParentAndPath.second;
                firstCommitParent = (String)firstCommitParentAndPath.first;
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    @Nullable
    private Pair<String, FilePath> getFirstCommitParentAndPathIfRename(@NotNull String commit, @NotNull FilePath filePath) throws VcsException {
        if (commit == null) {
            GitFileHistory.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            GitFileHistory.$$$reportNull$$$0(7);
        }
        GitSimpleHandler h = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(this.myProject, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit);
        if (!GitVersionSpecialty.FOLLOW_IS_BUGGY_IN_THE_LOG.existsIn(this.myVersion)) {
            h.addParameters("--follow");
            h.endOptions();
            h.addRelativePaths(filePath);
        } else {
            h.endOptions();
        }
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        GitLogRecord record = records.get(0);
        List<Change> changes = record.parseChanges(this.myProject, this.myRoot);
        for (Change change : changes) {
            if (!change.isMoved() && !change.isRenamed() || !filePath.equals(((ContentRevision)ObjectUtils.notNull((Object)change.getAfterRevision())).getFile())) continue;
            String[] parents = record.getParentsHashes();
            String parent = parents.length > 0 ? parents[0] : null;
            return Pair.create((Object)parent, (Object)((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getFile());
        }
        return null;
    }

    @NotNull
    private GitLineHandler createLogHandler(@NotNull GitLogParser parser, @NotNull FilePath path, @NotNull String lastCommit, String ... parameters) {
        if (parser == null) {
            GitFileHistory.$$$reportNull$$$0(8);
        }
        if (path == null) {
            GitFileHistory.$$$reportNull$$$0(9);
        }
        if (lastCommit == null) {
            GitFileHistory.$$$reportNull$$$0(10);
        }
        GitLineHandler h = new GitLineHandler(this.myProject, this.myRoot, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.myVersion) && Registry.is((String)"git.file.history.full")) {
            h.addParameters("--full-history", "--simplify-merges");
        }
        if (parameters != null && parameters.length > 0) {
            h.addParameters(parameters);
        }
        h.endOptions();
        h.addRelativePaths(path);
        GitLineHandler gitLineHandler = h;
        if (gitLineHandler == null) {
            GitFileHistory.$$$reportNull$$$0(11);
        }
        return gitLineHandler;
    }

    public static void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<GitFileRevision> consumer, @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        VirtualFile repositoryRoot;
        if (project == null) {
            GitFileHistory.$$$reportNull$$$0(12);
        }
        if (path == null) {
            GitFileHistory.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            GitFileHistory.$$$reportNull$$$0(14);
        }
        if (exceptionConsumer == null) {
            GitFileHistory.$$$reportNull$$$0(15);
        }
        VirtualFile virtualFile = repositoryRoot = root == null ? ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(path) : root;
        if (repositoryRoot == null) {
            exceptionConsumer.consume((Object)new VcsException("The file " + path + " is not under vcs."));
            return;
        }
        GitRevisionNumber revision = startingFrom == null ? GitRevisionNumber.HEAD : startingFrom;
        new GitFileHistory(project, repositoryRoot, path, (VcsRevisionNumber)revision).load(consumer, exceptionConsumer, parameters);
    }

    @NotNull
    public static List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        if (project == null) {
            GitFileHistory.$$$reportNull$$$0(16);
        }
        if (path == null) {
            GitFileHistory.$$$reportNull$$$0(17);
        }
        if (startingFrom == null) {
            GitFileHistory.$$$reportNull$$$0(18);
        }
        ArrayList<VcsFileRevision> revisions = new ArrayList<VcsFileRevision>();
        ArrayList exceptions = new ArrayList();
        GitFileHistory.loadHistory(project, path, null, startingFrom, (Consumer<GitFileRevision>)((Consumer)revisions::add), (Consumer<VcsException>)((Consumer)exceptions::add), parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        ArrayList<VcsFileRevision> arrayList = revisions;
        if (arrayList == null) {
            GitFileHistory.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public static List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        if (project == null) {
            GitFileHistory.$$$reportNull$$$0(20);
        }
        if (path == null) {
            GitFileHistory.$$$reportNull$$$0(21);
        }
        List<VcsFileRevision> list = GitFileHistory.collectHistoryForRevision(project, path, (VcsRevisionNumber)GitRevisionNumber.HEAD, parameters);
        if (list == null) {
            GitFileHistory.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionConsumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommit";
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitFileHistory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitFileHistory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogHandler";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectHistoryForRevision";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectHistory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFirstCommitParentAndPathIfRename";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLogHandler";
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadHistory";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectHistoryForRevision";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectHistory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class GitLogRecordConsumer
    implements Consumer<GitLogRecord> {
        @NotNull
        private final AtomicBoolean mySkipFurtherOutput;
        @NotNull
        private final AtomicReference<String> myFirstCommit;
        @NotNull
        private final AtomicReference<FilePath> myCurrentPath;
        @NotNull
        private final Consumer<VcsException> myExceptionConsumer;
        @NotNull
        private final Consumer<GitFileRevision> myRevisionConsumer;

        public GitLogRecordConsumer(@NotNull Consumer<GitFileRevision> revisionConsumer, Consumer<VcsException> exceptionConsumer) {
            if (revisionConsumer == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(0);
            }
            if (exceptionConsumer == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(1);
            }
            this.mySkipFurtherOutput = new AtomicBoolean();
            this.myFirstCommit = new AtomicReference();
            this.myCurrentPath = new AtomicReference();
            this.myExceptionConsumer = exceptionConsumer;
            this.myRevisionConsumer = revisionConsumer;
        }

        public void reset(@NotNull FilePath path) {
            if (path == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(2);
            }
            this.myCurrentPath.set(path);
            this.mySkipFurtherOutput.set(false);
        }

        public void consume(@NotNull GitLogRecord record) {
            if (record == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(3);
            }
            if (this.mySkipFurtherOutput.get()) {
                return;
            }
            this.myFirstCommit.set(record.getHash());
            try {
                this.myRevisionConsumer.consume((Object)this.createGitFileRevision(record));
                List<GitLogStatusInfo> statusInfos = record.getStatusInfos();
                if (statusInfos.isEmpty()) {
                    return;
                }
                if (statusInfos.get(0).getType() == GitChangeType.ADDED && !GitFileHistory.this.myPath.isDirectory()) {
                    this.mySkipFurtherOutput.set(true);
                }
            }
            catch (VcsException e) {
                this.myExceptionConsumer.consume((Object)e);
            }
        }

        @NotNull
        private GitFileRevision createGitFileRevision(@NotNull GitLogRecord record) throws VcsException {
            if (record == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(4);
            }
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            FilePath revisionPath = this.getRevisionPath(record);
            Couple authorPair = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
            Couple committerPair = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
            List<String> parents = Arrays.asList(record.getParentsHashes());
            GitFileRevision gitFileRevision = new GitFileRevision(GitFileHistory.this.myProject, GitFileHistory.this.myRoot, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents);
            if (gitFileRevision == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(5);
            }
            return gitFileRevision;
        }

        @NotNull
        private FilePath getRevisionPath(@NotNull GitLogRecord record) throws VcsException {
            List<FilePath> paths;
            if (record == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(6);
            }
            if ((paths = record.getFilePaths(GitFileHistory.this.myRoot)).size() > 0) {
                FilePath filePath = paths.get(0);
                if (filePath == null) {
                    GitLogRecordConsumer.$$$reportNull$$$0(7);
                }
                return filePath;
            }
            FilePath filePath = this.myCurrentPath.get();
            if (filePath == null) {
                GitLogRecordConsumer.$$$reportNull$$$0(8);
            }
            return filePath;
        }

        @Nullable
        public String getFirstCommit() {
            return this.myFirstCommit.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisionConsumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitFileHistory$GitLogRecordConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitFileHistory$GitLogRecordConsumer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGitFileRevision";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "consume";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createGitFileRevision";
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getRevisionPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyGitLineHandlerAdapter
    extends GitLineHandlerAdapter {
        @NotNull
        private final AtomicBoolean myCriticalFailure;
        @NotNull
        private final Semaphore mySemaphore;
        @NotNull
        private final GitLineHandler myHandler;
        @NotNull
        private final MyTokenAccumulator myAccumulator;
        @NotNull
        private final Consumer<GitLogRecord> myRecordConsumer;
        @NotNull
        private final Consumer<VcsException> myExceptionConsumer;

        public MyGitLineHandlerAdapter(@NotNull GitLineHandler handler, @NotNull GitLogParser logParser, @NotNull Consumer<GitLogRecord> recordConsumer, @NotNull Consumer<VcsException> exceptionConsumer) {
            if (handler == null) {
                MyGitLineHandlerAdapter.$$$reportNull$$$0(0);
            }
            if (logParser == null) {
                MyGitLineHandlerAdapter.$$$reportNull$$$0(1);
            }
            if (recordConsumer == null) {
                MyGitLineHandlerAdapter.$$$reportNull$$$0(2);
            }
            if (exceptionConsumer == null) {
                MyGitLineHandlerAdapter.$$$reportNull$$$0(3);
            }
            this.myCriticalFailure = new AtomicBoolean();
            this.mySemaphore = new Semaphore();
            this.myHandler = handler;
            this.myRecordConsumer = recordConsumer;
            this.myExceptionConsumer = exceptionConsumer;
            this.myAccumulator = new MyTokenAccumulator(logParser);
            this.myHandler.addLineListener(this);
        }

        public void runAndWait() {
            this.mySemaphore.down();
            this.myHandler.start();
            this.mySemaphore.waitFor();
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            GitLogRecord record = this.myAccumulator.acceptLine(line);
            if (record != null) {
                record.setUsedHandler(this.myHandler);
                this.myRecordConsumer.consume((Object)record);
            }
        }

        @Override
        public void startFailed(Throwable exception) {
            try {
                this.myExceptionConsumer.consume((Object)new VcsException(exception));
            }
            finally {
                this.myCriticalFailure.set(true);
                this.mySemaphore.up();
            }
        }

        @Override
        public void processTerminated(int exitCode) {
            try {
                super.processTerminated(exitCode);
                GitLogRecord record = this.myAccumulator.processLast();
                if (record != null) {
                    record.setUsedHandler(this.myHandler);
                    this.myRecordConsumer.consume((Object)record);
                }
            }
            catch (ProcessCanceledException record) {
            }
            catch (Throwable t) {
                LOG.error(t);
                this.myExceptionConsumer.consume((Object)new VcsException("Internal error " + t.getMessage(), t));
                this.myCriticalFailure.set(true);
            }
            finally {
                this.mySemaphore.up();
            }
        }

        public boolean hasCriticalFailure() {
            return this.myCriticalFailure.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordConsumer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptionConsumer";
                    break;
                }
            }
            objectArray[1] = "git4idea/history/GitFileHistory$MyGitLineHandlerAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTokenAccumulator {
        @NotNull
        private final StringBuilder myBuffer;
        @NotNull
        private final GitLogParser myParser;
        private boolean myNotStarted;

        public MyTokenAccumulator(@NotNull GitLogParser parser) {
            if (parser == null) {
                MyTokenAccumulator.$$$reportNull$$$0(0);
            }
            this.myBuffer = new StringBuilder();
            this.myNotStarted = true;
            this.myParser = parser;
        }

        @Nullable
        public GitLogRecord acceptLine(String s) {
            boolean recordStart = s.startsWith("\u0001\u0001");
            if (recordStart) {
                s = s.substring("\u0001\u0001".length());
            }
            if (this.myNotStarted) {
                this.myBuffer.append(s);
                this.myBuffer.append("\n");
                this.myNotStarted = false;
                return null;
            }
            if (recordStart) {
                String line = this.myBuffer.toString();
                this.myBuffer.setLength(0);
                this.myBuffer.append(s);
                this.myBuffer.append("\n");
                return this.processResult(line);
            }
            this.myBuffer.append(s);
            this.myBuffer.append("\n");
            return null;
        }

        @Nullable
        public GitLogRecord processLast() {
            return this.processResult(this.myBuffer.toString());
        }

        @Nullable
        private GitLogRecord processResult(@NotNull String line) {
            if (line == null) {
                MyTokenAccumulator.$$$reportNull$$$0(1);
            }
            return this.myParser.parseOneRecord(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "git4idea/history/GitFileHistory$MyTokenAccumulator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processResult";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

