/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.util.BekUtil;
import git4idea.log.GitLogProvider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBekParentFixer {
    @NotNull
    private static final String MAGIC_TEXT = "Merge remote";
    @NotNull
    private static final VcsLogFilterCollection MAGIC_FILTER = GitBekParentFixer.createVcsLogFilterCollection();
    @NotNull
    private final Set<Hash> myWrongCommits;

    private GitBekParentFixer(@NotNull Set<Hash> wrongCommits) {
        if (wrongCommits == null) {
            GitBekParentFixer.$$$reportNull$$$0(0);
        }
        this.myWrongCommits = wrongCommits;
    }

    @NotNull
    static GitBekParentFixer prepare(@NotNull VirtualFile root, @NotNull GitLogProvider provider) throws VcsException {
        if (root == null) {
            GitBekParentFixer.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            GitBekParentFixer.$$$reportNull$$$0(2);
        }
        if (!BekUtil.isBekEnabled()) {
            GitBekParentFixer gitBekParentFixer = new GitBekParentFixer(Collections.emptySet());
            if (gitBekParentFixer == null) {
                GitBekParentFixer.$$$reportNull$$$0(3);
            }
            return gitBekParentFixer;
        }
        GitBekParentFixer gitBekParentFixer = new GitBekParentFixer(GitBekParentFixer.getWrongCommits(provider, root));
        if (gitBekParentFixer == null) {
            GitBekParentFixer.$$$reportNull$$$0(4);
        }
        return gitBekParentFixer;
    }

    @NotNull
    TimedVcsCommit fixCommit(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            GitBekParentFixer.$$$reportNull$$$0(5);
        }
        if (!this.myWrongCommits.contains(commit.getId())) {
            TimedVcsCommit timedVcsCommit = commit;
            if (timedVcsCommit == null) {
                GitBekParentFixer.$$$reportNull$$$0(6);
            }
            return timedVcsCommit;
        }
        TimedVcsCommit timedVcsCommit = GitBekParentFixer.reverseParents(commit);
        if (timedVcsCommit == null) {
            GitBekParentFixer.$$$reportNull$$$0(7);
        }
        return timedVcsCommit;
    }

    @NotNull
    private static Set<Hash> getWrongCommits(@NotNull GitLogProvider provider, @NotNull VirtualFile root) throws VcsException {
        if (provider == null) {
            GitBekParentFixer.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitBekParentFixer.$$$reportNull$$$0(9);
        }
        List<TimedVcsCommit> commitsMatchingFilter = provider.getCommitsMatchingFilter(root, MAGIC_FILTER, -1);
        Set set = ContainerUtil.map2Set(commitsMatchingFilter, timedVcsCommit -> (Hash)timedVcsCommit.getId());
        if (set == null) {
            GitBekParentFixer.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static TimedVcsCommit reverseParents(final @NotNull TimedVcsCommit commit) {
        if (commit == null) {
            GitBekParentFixer.$$$reportNull$$$0(11);
        }
        TimedVcsCommit timedVcsCommit = new TimedVcsCommit(){

            public long getTimestamp() {
                return commit.getTimestamp();
            }

            @NotNull
            public Hash getId() {
                Hash hash = (Hash)commit.getId();
                if (hash == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hash;
            }

            @NotNull
            public List<Hash> getParents() {
                List list = ContainerUtil.reverse((List)commit.getParents());
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "git4idea/log/GitBekParentFixer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParents";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (timedVcsCommit == null) {
            GitBekParentFixer.$$$reportNull$$$0(12);
        }
        return timedVcsCommit;
    }

    private static VcsLogFilterCollection createVcsLogFilterCollection() {
        final VcsLogTextFilter textFilter = new VcsLogTextFilter(){

            public boolean matchesCase() {
                return false;
            }

            public boolean isRegex() {
                return false;
            }

            @NotNull
            public String getText() {
                if (GitBekParentFixer.MAGIC_TEXT == null) {
                    2.$$$reportNull$$$0(0);
                }
                return GitBekParentFixer.MAGIC_TEXT;
            }

            public boolean matches(@NotNull VcsCommitMetadata details) {
                if (details == null) {
                    2.$$$reportNull$$$0(1);
                }
                return details.getFullMessage().contains(GitBekParentFixer.MAGIC_TEXT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/log/GitBekParentFixer$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "details";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/log/GitBekParentFixer$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "matches";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        return new VcsLogFilterCollection(){

            @Nullable
            public VcsLogBranchFilter getBranchFilter() {
                return null;
            }

            @Nullable
            public VcsLogUserFilter getUserFilter() {
                return null;
            }

            @Nullable
            public VcsLogDateFilter getDateFilter() {
                return null;
            }

            @Nullable
            public VcsLogTextFilter getTextFilter() {
                return textFilter;
            }

            @Nullable
            public VcsLogHashFilter getHashFilter() {
                return null;
            }

            @Nullable
            public VcsLogStructureFilter getStructureFilter() {
                return null;
            }

            @Nullable
            public VcsLogRootFilter getRootFilter() {
                return null;
            }

            public boolean isEmpty() {
                return false;
            }

            @NotNull
            public List<VcsLogDetailsFilter> getDetailsFilters() {
                List<VcsLogTextFilter> list = Collections.singletonList(textFilter);
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitBekParentFixer$3", "getDetailsFilters"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrongCommits";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitBekParentFixer";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitBekParentFixer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCommit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrongCommits";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fixCommit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWrongCommits";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reverseParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

