/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.ProgressManagerQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfiguration;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.branchConfig.SvnBranchMapperManager;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.branchConfig.UrlSerializationHelper;

@State(name="SvnBranchConfigurationManager")
public class SvnBranchConfigurationManager
implements PersistentStateComponent<ConfigurationBean> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager");
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final SvnLoadedBranchesStorage myStorage;
    private final ProgressManagerQueue myBranchesLoader;
    private boolean myIsInitialized;
    private ConfigurationBean myConfigurationBean = new ConfigurationBean();
    @NotNull
    private final NewRootBunch myBunch;

    public SvnBranchConfigurationManager(Project project, ProjectLevelVcsManager vcsManager, SvnLoadedBranchesStorage storage) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myStorage = storage;
        this.myBranchesLoader = new ProgressManagerQueue(this.myProject, "Subversion Branches Preloader");
        ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.BRANCHES, () -> ApplicationManager.getApplication().runReadAction(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myBranchesLoader.start();
        }));
        this.myBunch = new NewRootBunch(project, this.myBranchesLoader);
    }

    public static SvnBranchConfigurationManager getInstance(@NotNull Project project) {
        SvnBranchConfigurationManager result;
        if (project == null) {
            SvnBranchConfigurationManager.$$$reportNull$$$0(0);
        }
        if ((result = (SvnBranchConfigurationManager)PeriodicalTasksCloser.getInstance().safeGetService(project, SvnBranchConfigurationManager.class)) != null) {
            result.initialize();
        }
        return result;
    }

    public Long getSupportValue() {
        return this.myConfigurationBean.myVersion;
    }

    @NotNull
    public SvnBranchConfigurationNew get(@NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            SvnBranchConfigurationManager.$$$reportNull$$$0(1);
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = this.myBunch.getConfig(vcsRoot);
        if (svnBranchConfigurationNew == null) {
            SvnBranchConfigurationManager.$$$reportNull$$$0(2);
        }
        return svnBranchConfigurationNew;
    }

    @NotNull
    public NewRootBunch getSvnBranchConfigManager() {
        NewRootBunch newRootBunch = this.myBunch;
        if (newRootBunch == null) {
            SvnBranchConfigurationManager.$$$reportNull$$$0(3);
        }
        return newRootBunch;
    }

    public void setConfiguration(VirtualFile vcsRoot, SvnBranchConfigurationNew configuration) {
        this.myBunch.updateForRoot(vcsRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.setByUser), true);
        SvnBranchMapperManager.getInstance().notifyBranchesChanged(this.myProject, vcsRoot, configuration);
        ((VcsConfigurationChangeListener.Notification)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsConfigurationChangeListener.BRANCHES_CHANGED)).execute(this.myProject, vcsRoot);
    }

    public ConfigurationBean getState() {
        ConfigurationBean result = new ConfigurationBean();
        result.myVersion = this.myConfigurationBean.myVersion;
        UrlSerializationHelper helper = new UrlSerializationHelper(SvnVcs.getInstance(this.myProject));
        for (VirtualFile root : this.myBunch.getMapCopy().keySet()) {
            String key = root.getPath();
            SvnBranchConfigurationNew configOrig = this.myBunch.getConfig(root);
            SvnBranchConfiguration configuration = new SvnBranchConfiguration(configOrig.getTrunkUrl(), configOrig.getBranchUrls(), configOrig.isUserinfoInUrl());
            result.myConfigurationMap.put(key, helper.prepareForSerialization(configuration));
        }
        result.mySupportsUserInfoFilter = true;
        return result;
    }

    public void loadState(ConfigurationBean object) {
        this.myConfigurationBean = object;
    }

    private synchronized void initialize() {
        if (!this.myIsInitialized) {
            this.myIsInitialized = true;
            this.preloadBranches(this.resolveAllBranchPoints());
        }
    }

    @NotNull
    private Set<Pair<VirtualFile, SvnBranchConfigurationNew>> resolveAllBranchPoints() {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        UrlSerializationHelper helper = new UrlSerializationHelper(SvnVcs.getInstance(this.myProject));
        HashSet branchPointsToLoad = ContainerUtil.newHashSet();
        for (Map.Entry<String, SvnBranchConfiguration> entry : this.myConfigurationBean.myConfigurationMap.entrySet()) {
            SvnBranchConfiguration configuration = entry.getValue();
            VirtualFile root = lfs.refreshAndFindFileByIoFile(new File(entry.getKey()));
            if (root == null) {
                LOG.info("root not found: " + entry.getKey());
                continue;
            }
            SvnBranchConfiguration configToConvert = !this.myConfigurationBean.mySupportsUserInfoFilter || configuration.isUserinfoInUrl() ? helper.afterDeserialization(entry.getKey(), configuration) : configuration;
            SvnBranchConfigurationNew newConfig = new SvnBranchConfigurationNew();
            newConfig.setTrunkUrl(configToConvert.getTrunkUrl());
            newConfig.setUserinfoInUrl(configToConvert.isUserinfoInUrl());
            for (String branchUrl : configToConvert.getBranchUrls()) {
                List<SvnBranchItem> stored = this.getStored(branchUrl);
                if (stored != null && !stored.isEmpty()) {
                    newConfig.addBranches(branchUrl, new InfoStorage<List<SvnBranchItem>>(stored, InfoReliability.setByUser));
                    continue;
                }
                branchPointsToLoad.add(Pair.create((Object)root, (Object)newConfig));
                newConfig.addBranches(branchUrl, new InfoStorage<List<SvnBranchItem>>(new ArrayList(), InfoReliability.empty));
            }
            this.myBunch.updateForRoot(root, new InfoStorage<SvnBranchConfigurationNew>(newConfig, InfoReliability.setByUser), false);
        }
        HashSet hashSet = branchPointsToLoad;
        if (hashSet == null) {
            SvnBranchConfigurationManager.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private void preloadBranches(@NotNull Collection<Pair<VirtualFile, SvnBranchConfigurationNew>> branchPoints) {
        if (branchPoints == null) {
            SvnBranchConfigurationManager.$$$reportNull$$$0(5);
        }
        ((ProjectLevelVcsManagerImpl)this.myVcsManager).addInitializationRequest(VcsInitObject.BRANCHES, () -> {
            if (branchPoints == null) {
                SvnBranchConfigurationManager.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (branchPoints == null) {
                    SvnBranchConfigurationManager.$$$reportNull$$$0(7);
                }
                try {
                    for (Pair pair : branchPoints) {
                        this.myBunch.reloadBranches((VirtualFile)pair.getFirst(), null, (SvnBranchConfigurationNew)pair.getSecond());
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            });
        });
    }

    private List<SvnBranchItem> getStored(String branchUrl) {
        Collection<SvnBranchItem> collection = this.myStorage.get(branchUrl);
        if (collection == null) {
            return null;
        }
        ArrayList<SvnBranchItem> items = new ArrayList<SvnBranchItem>(collection);
        Collections.sort(items);
        return items;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnBranchConfigManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAllBranchPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preloadBranches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$preloadBranches$3";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigurationBean {
        public Map<String, SvnBranchConfiguration> myConfigurationMap = new TreeMap<String, SvnBranchConfiguration>();
        public Long myVersion;
        public boolean mySupportsUserInfoFilter;
    }
}

