/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.importcmd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public final class ImportCommand
extends Command {
    private final Map<SimpleStringPattern, KeywordSubstitution> wrapperMap = new HashMap<SimpleStringPattern, KeywordSubstitution>();
    private String logMessage;
    private String module;
    private String releaseTag;
    private String vendorBranch;
    private String vendorTag;
    private KeywordSubstitution keywordSubstitutionOption;

    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        BugLog.getInstance().assertNotNull(this.getModule());
        BugLog.getInstance().assertNotNull(this.getReleaseTag());
        BugLog.getInstance().assertNotNull(this.getVendorTag());
        Requests requests = new Requests(CommandRequest.IMPORT, clientEnvironment);
        requests.addArgumentRequest(this.getVendorBranchNotNull(), "-b");
        requests.addMessageRequests(CommandUtils.getMessageNotNull(this.getLogMessage()));
        requests.addArgumentRequest(this.getKeywordSubstitutionOption(), "-k");
        ImportCommand.addWrapperRequests(requests, this.wrapperMap);
        requests.addArgumentRequest(this.getModule());
        requests.addArgumentRequest(this.getVendorTag());
        requests.addArgumentRequest(this.getReleaseTag());
        File rootDirectory = clientEnvironment.getCvsFileSystem().getLocalFileSystem().getRootDirectory();
        this.addFileRequests(rootDirectory, requests, requestProcessor, clientEnvironment);
        requests.addRequest(new DirectoryRequest(".", this.getRepositoryRoot(clientEnvironment)));
        return requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setLogMessage(null);
        this.setModule(null);
        this.setReleaseTag(null);
        this.setVendorTag(null);
        this.setVendorBranch(null);
        this.setKeywordSubstitutionOption(null);
        if (this.wrapperMap != null) {
            this.wrapperMap.clear();
        }
    }

    @Override
    public String getCvsCommandLine() {
        StringBuilder cvsArguments = new StringBuilder("import ");
        cvsArguments.append(this.getCvsArguments());
        cvsArguments.append(' ');
        cvsArguments.append(this.getModule());
        cvsArguments.append(' ');
        cvsArguments.append(this.getVendorTag());
        cvsArguments.append(' ');
        cvsArguments.append(this.getReleaseTag());
        return cvsArguments.toString();
    }

    public void addWrapper(String filenamePattern, KeywordSubstitution keywordSubstitutionOptions) {
        BugLog.getInstance().assertNotNull(keywordSubstitutionOptions);
        this.wrapperMap.put(new SimpleStringPattern(filenamePattern), keywordSubstitutionOptions);
    }

    private KeywordSubstitution getKeywordSubstitutionOption() {
        return this.keywordSubstitutionOption;
    }

    public void setKeywordSubstitutionOption(KeywordSubstitution keywordSubstitutionOption) {
        this.keywordSubstitutionOption = keywordSubstitutionOption;
    }

    private String getReleaseTag() {
        return this.releaseTag;
    }

    public void setReleaseTag(String releaseTag) {
        this.releaseTag = ImportCommand.getTrimmedString(releaseTag);
    }

    private String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    private String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = ImportCommand.getTrimmedString(module);
    }

    private String getVendorBranch() {
        return this.vendorBranch;
    }

    private String getVendorBranchNotNull() {
        if (this.vendorBranch == null) {
            return "1.1.1";
        }
        return this.vendorBranch;
    }

    public void setVendorBranch(String vendorBranch) {
        this.vendorBranch = ImportCommand.getTrimmedString(vendorBranch);
    }

    private String getVendorTag() {
        return this.vendorTag;
    }

    public void setVendorTag(String vendorTag) {
        this.vendorTag = ImportCommand.getTrimmedString(vendorTag);
    }

    private String getCvsArguments() {
        StringBuilder cvsArguments = new StringBuilder();
        cvsArguments.append("-m \"");
        cvsArguments.append(CommandUtils.getMessageNotNull(this.getLogMessage()));
        cvsArguments.append("\" ");
        if (this.getKeywordSubstitutionOption() != null) {
            cvsArguments.append("-k");
            cvsArguments.append(this.getKeywordSubstitutionOption().toString());
            cvsArguments.append(" ");
        }
        if (this.getVendorBranch() != null) {
            cvsArguments.append("-b ");
            cvsArguments.append(this.getVendorBranch());
            cvsArguments.append(" ");
        }
        if (this.wrapperMap.size() > 0) {
            for (SimpleStringPattern pattern : this.wrapperMap.keySet()) {
                KeywordSubstitution keywordSubstitutionOptions = this.wrapperMap.get(pattern);
                cvsArguments.append("-W ");
                cvsArguments.append(pattern.toString());
                cvsArguments.append(" -k '");
                cvsArguments.append(keywordSubstitutionOptions.toString());
                cvsArguments.append("' ");
            }
        }
        return cvsArguments.toString();
    }

    private static void addWrapperRequests(Requests requests, Map<SimpleStringPattern, KeywordSubstitution> wrapperMap) {
        requests.addArgumentRequest("-I !");
        for (SimpleStringPattern pattern : wrapperMap.keySet()) {
            KeywordSubstitution keywordSubstitutionOptions = wrapperMap.get(pattern);
            StringBuilder buffer = new StringBuilder();
            buffer.append(pattern.toString());
            buffer.append(" -k '");
            buffer.append(keywordSubstitutionOptions.toString());
            buffer.append("'");
            requests.addArgumentRequest("-W");
            requests.addArgumentRequest(buffer.toString());
        }
    }

    private void addFileRequests(File directory, Requests requests, IRequestProcessor requestProcessor, IClientEnvironment clientEnvironment) {
        DirectoryObject directoryObject = clientEnvironment.getCvsFileSystem().getLocalFileSystem().getDirectoryObject(directory);
        String relativePath = directoryObject.toUnixPath();
        String repository = this.getRepositoryRoot(clientEnvironment);
        if (!relativePath.equals(".")) {
            repository = repository + '/' + relativePath;
        }
        requests.addRequest(new DirectoryRequest(relativePath, repository));
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        ArrayList<File> subdirectories = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                DirectoryObject subDirObject = clientEnvironment.getCvsFileSystem().getLocalFileSystem().getDirectoryObject(file);
                if (clientEnvironment.getIgnoreFileFilter().shouldBeIgnored(subDirObject, clientEnvironment.getCvsFileSystem())) continue;
                subdirectories.add(file);
                continue;
            }
            FileObject fileObject = clientEnvironment.getCvsFileSystem().getLocalFileSystem().getFileObject(file);
            if (clientEnvironment.getIgnoreFileFilter().shouldBeIgnored(fileObject, clientEnvironment.getCvsFileSystem())) continue;
            KeywordSubstitution keywordSubstMode = this.getKeywordSubstMode(file.getName());
            boolean writable = clientEnvironment.getLocalFileReader().isWritable(fileObject, clientEnvironment.getCvsFileSystem());
            if (keywordSubstMode != null) {
                requests.addKoptRequest(keywordSubstMode);
            }
            requests.addModifiedRequest(fileObject, keywordSubstMode == KeywordSubstitution.BINARY, writable);
        }
        for (File subdirectory : subdirectories) {
            this.addFileRequests(subdirectory, requests, requestProcessor, clientEnvironment);
        }
    }

    private String getRepositoryRoot(IClientEnvironment clientEnvironment) {
        return clientEnvironment.getCvsRoot().getRepositoryPath() + '/' + this.getModule();
    }

    private KeywordSubstitution getKeywordSubstMode(String fileName) {
        KeywordSubstitution keywordSubstMode = this.getKeywordSubstitutionOption();
        for (SimpleStringPattern pattern : this.wrapperMap.keySet()) {
            if (!pattern.doesMatch(fileName)) continue;
            keywordSubstMode = this.wrapperMap.get(pattern);
            break;
        }
        return keywordSubstMode;
    }
}

