/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class Throwables {
    @Nullable
    private static final Object jla = Throwables.getJLA();
    @Nullable
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @Nullable
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod();

    public static void propagateIfInstanceOf(@Nullable Throwable throwable, Class clazz) {
        if (throwable != null && clazz.isInstance(throwable)) {
            throw (Throwable)clazz.cast(throwable);
        }
    }

    public static void propagateIfPossible(@Nullable Throwable throwable) {
        Throwables.propagateIfInstanceOf(throwable, Error.class);
        Throwables.propagateIfInstanceOf(throwable, RuntimeException.class);
    }

    public static void propagateIfPossible(@Nullable Throwable throwable, Class clazz) {
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable);
    }

    public static RuntimeException propagate(Throwable throwable) {
        Throwables.propagateIfPossible((Throwable)Preconditions.checkNotNull(throwable));
        throw new RuntimeException(throwable);
    }

    @CheckReturnValue
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Nullable
    private static Object getJLA() {
        try {
            Class<?> clazz = Class.forName("sun.misc.SharedSecrets", false, null);
            Method method = clazz.getMethod("getJavaLangAccess", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    @Nullable
    private static Method getSizeMethod() {
        return Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
    }

    @Nullable
    private static Method getJlaMethod(String string, Class ... classArray) {
        try {
            return Class.forName("sun.misc.JavaLangAccess", false, null).getMethod(string, classArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

