/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SimpleCollector;
import org.apache.solr.analytics.facet.AnalyticsFacet;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class AbstractSolrQueryFacet
extends AnalyticsFacet {
    protected AbstractSolrQueryFacet(String name) {
        super(name);
    }

    public abstract void createFacetValueExecuters(Filter var1, SolrQueryRequest var2, Consumer<FacetValueQueryExecuter> var3);

    public class FacetValueQueryExecuter
    extends SimpleCollector {
        private final ReductionCollectionManager.ReductionDataCollection collection;
        private final Query query;

        public FacetValueQueryExecuter(ReductionCollectionManager.ReductionDataCollection collection, Query query) {
            this.collection = collection;
            this.query = query;
        }

        public boolean needsScores() {
            return false;
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            AbstractSolrQueryFacet.this.collectionManager.doSetNextReader(context);
        }

        public void collect(int doc) throws IOException {
            AbstractSolrQueryFacet.this.collectionManager.collect(doc);
            AbstractSolrQueryFacet.this.collectionManager.apply();
        }

        public void execute(SolrIndexSearcher searcher) throws IOException {
            AbstractSolrQueryFacet.this.collectionManager.clearLastingCollectTargets();
            AbstractSolrQueryFacet.this.collectionManager.addLastingCollectTarget(this.collection);
            searcher.search(this.query, (Collector)this);
        }
    }
}

