/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.MutableBits;

class CrankyLiveDocsFormat
extends LiveDocsFormat {
    final LiveDocsFormat delegate;
    final Random random;

    CrankyLiveDocsFormat(LiveDocsFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public MutableBits newLiveDocs(int size) throws IOException {
        return this.delegate.newLiveDocs(size);
    }

    public MutableBits newLiveDocs(Bits existing) throws IOException {
        return this.delegate.newLiveDocs(existing);
    }

    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        return this.delegate.readLiveDocs(dir, info, context);
    }

    public void writeLiveDocs(MutableBits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from LiveDocsFormat.writeLiveDocs()");
        }
        this.delegate.writeLiveDocs(bits, dir, info, newDelCount, context);
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        this.delegate.files(info, files);
    }
}

