/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.mockfile.FilterFileSystemProvider;

public class ExtrasFS
extends FilterFileSystemProvider {
    final boolean active;
    final boolean createDirectory;

    public ExtrasFS(FileSystem delegate, boolean active, boolean createDirectory) {
        super("extras://", delegate);
        this.active = active;
        this.createDirectory = createDirectory;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        super.createDirectory(dir, attrs);
        if (this.active) {
            try {
                Path target = dir.resolve("extra0");
                if (this.createDirectory) {
                    super.createDirectory(target, new FileAttribute[0]);
                } else {
                    Files.createFile(target, new FileAttribute[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

