/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.formatters;

import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.number.modifiers.GeneralPluralModifier;
import com.ibm.icu.impl.number.modifiers.SimpleModifier;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.MeasureFormat;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;

public class MeasureFormat {
    public static boolean useMeasureFormat(IProperties properties) {
        return properties.getMeasureUnit() != IProperties.DEFAULT_MEASURE_UNIT;
    }

    public static GeneralPluralModifier getInstance(DecimalFormatSymbols symbols, IProperties properties) {
        ULocale uloc = symbols.getULocale();
        MeasureUnit unit = properties.getMeasureUnit();
        MeasureFormat.FormatWidth width = properties.getMeasureFormatWidth();
        if (unit == null) {
            throw new IllegalArgumentException("A measure unit is required for MeasureFormat");
        }
        if (width == null) {
            width = MeasureFormat.FormatWidth.WIDE;
        }
        com.ibm.icu.text.MeasureFormat mf = com.ibm.icu.text.MeasureFormat.getInstance(uloc, width);
        GeneralPluralModifier mod = new GeneralPluralModifier();
        for (StandardPlural plural : StandardPlural.VALUES) {
            String formatString = null;
            mf.getPluralFormatter(unit, width, plural.ordinal());
            mod.put(plural, new SimpleModifier(formatString, null, false));
        }
        return mod;
    }

    public static interface IProperties {
        public static final MeasureUnit DEFAULT_MEASURE_UNIT = null;
        public static final MeasureFormat.FormatWidth DEFAULT_MEASURE_FORMAT_WIDTH = null;

        public MeasureUnit getMeasureUnit();

        public IProperties setMeasureUnit(MeasureUnit var1);

        public MeasureFormat.FormatWidth getMeasureFormatWidth();

        public IProperties setMeasureFormatWidth(MeasureFormat.FormatWidth var1);
    }
}

