/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;

public class ShuffleStream
extends CloudSolrStream
implements Expressible {
    public ShuffleStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter aliasExpression = factory.getNamedOperand(expression, "aliases");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (expression.getParameters().size() != 1 + namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams mParams = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            mParams.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        if (null != aliasExpression && aliasExpression.getParameter() instanceof StreamExpressionValue) {
            this.fieldMappings = new HashMap();
            for (String mapping : ((StreamExpressionValue)aliasExpression.getParameter()).getValue().split(",")) {
                String[] parts = mapping.trim().split("=");
                if (2 != parts.length) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - alias expected of the format origName=newName", expression));
                }
                this.fieldMappings.put(parts[0], parts[1]);
            }
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, zkHost, mParams);
    }

    @Override
    public ModifiableSolrParams adjustParams(ModifiableSolrParams mParams) {
        mParams.set("qt", "/export");
        return mParams;
    }
}

