/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.impl.RelativePathResolver_impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataResource_impl
extends Resource_ImplBase
implements DataResource {
    private URL mFileUrl;
    private File mLocalCache;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof FileResourceSpecifier)) {
            return false;
        }
        FileResourceSpecifier spec = (FileResourceSpecifier)aSpecifier;
        RelativePathResolver relPathResolver = null;
        if (aAdditionalParams != null) {
            relPathResolver = (RelativePathResolver)aAdditionalParams.get("RELATIVE_PATH_RESOLVER");
        }
        if (relPathResolver == null) {
            relPathResolver = new RelativePathResolver_impl();
        }
        IOException ioEx = null;
        try {
            URL relativeUrl;
            try {
                relativeUrl = new URL(spec.getFileUrl());
            }
            catch (MalformedURLException e) {
                File file = new File(spec.getFileUrl());
                relativeUrl = file.isAbsolute() ? file.toURL() : new URL("file", "", spec.getFileUrl());
            }
            this.mFileUrl = relPathResolver.resolveRelativePath(relativeUrl);
            this.mLocalCache = spec.getLocalCache() == null ? null : new File(spec.getLocalCache());
        }
        catch (IOException e) {
            ioEx = e;
        }
        if (this.mFileUrl == null) {
            throw new ResourceInitializationException("could_not_access_data", new Object[]{spec.getFileUrl()}, ioEx);
        }
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mFileUrl.openStream();
    }

    @Override
    public URL getUrl() {
        return this.mFileUrl;
    }

    @Override
    public URI getUri() {
        try {
            String urlStr = this.mFileUrl.toString();
            return new URI(urlStr.replaceAll(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new UIMARuntimeException(e);
        }
    }

    protected File getLocalCache() {
        return this.mLocalCache;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DataResource_impl)) {
            return false;
        }
        URL url = ((DataResource_impl)obj).getUrl();
        if (url == null || !url.toString().equals(this.getUrl().toString())) {
            return false;
        }
        File localCache = ((DataResource_impl)obj).getLocalCache();
        if (localCache == null && this.getLocalCache() != null) {
            return false;
        }
        return localCache == null || localCache.equals(this.getLocalCache());
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        if (this.mFileUrl != null) {
            hashCode += this.mFileUrl.toString().hashCode();
        }
        if (this.mLocalCache != null) {
            hashCode += this.mLocalCache.hashCode();
        }
        return hashCode;
    }
}

