/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.loader.CSVLoader;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.handler.loader.JavabinLoader;
import org.apache.solr.handler.loader.JsonLoader;
import org.apache.solr.handler.loader.XMLLoader;
import org.apache.solr.metrics.AggregateMetric;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollectorHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String HANDLER_PATH = "/admin/metrics/collector";
    private final CoreContainer coreContainer;
    private final SolrMetricManager metricManager;
    private final Map<String, ContentStreamLoader> loaders = new HashMap<String, ContentStreamLoader>();
    private SolrParams params;

    public MetricsCollectorHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.metricManager = coreContainer.getMetricManager();
    }

    @Override
    public void init(NamedList initArgs) {
        super.init(initArgs);
        this.params = initArgs != null ? SolrParams.toSolrParams((NamedList)initArgs) : new ModifiableSolrParams();
        this.loaders.put("application/xml", new XMLLoader().init(this.params));
        this.loaders.put("application/json", new JsonLoader().init(this.params));
        this.loaders.put("application/csv", new CSVLoader().init(this.params));
        this.loaders.put("application/javabin", new JavabinLoader().init(this.params));
        this.loaders.put("text/csv", this.loaders.get("application/csv"));
        this.loaders.put("text/xml", this.loaders.get("application/xml"));
        this.loaders.put("text/json", this.loaders.get("application/json"));
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        if (this.coreContainer == null || this.coreContainer.isShutDown()) {
            return;
        }
        if (req.getContentStreams() == null) {
            return;
        }
        for (ContentStream cs : req.getContentStreams()) {
            if (cs.getContentType() == null) {
                log.warn("Missing content type - ignoring");
                continue;
            }
            ContentStreamLoader loader = this.loaders.get(cs.getContentType());
            if (loader == null) {
                throw new SolrException(SolrException.ErrorCode.UNSUPPORTED_MEDIA_TYPE, "Unsupported content type for stream: " + cs.getSourceInfo() + ", contentType=" + cs.getContentType());
            }
            loader.load(req, rsp, cs, new MetricUpdateProcessor(this.metricManager));
        }
    }

    @Override
    public String getDescription() {
        return "Handler for collecting and aggregating SolrCloud metric reports.";
    }

    private static class MetricUpdateProcessor
    extends UpdateRequestProcessor {
        private final SolrMetricManager metricManager;

        public MetricUpdateProcessor(SolrMetricManager metricManager) {
            super(null);
            this.metricManager = metricManager;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            SolrInputDocument doc = cmd.solrDoc;
            if (doc == null) {
                return;
            }
            String metricName = (String)doc.getFieldValue("metric");
            if (metricName == null) {
                log.warn("Missing metric field in document, skipping: " + doc);
                return;
            }
            doc.remove((Object)"metric");
            doc.remove((Object)"_registry_");
            String groupId = (String)doc.getFieldValue("_group_");
            if (groupId == null) {
                log.warn("Missing _group_ field in document, skipping: " + doc);
                return;
            }
            doc.remove((Object)"_group_");
            String reporterId = (String)doc.getFieldValue("_reporter_");
            if (reporterId == null) {
                log.warn("Missing _reporter_ field in document, skipping: " + doc);
                return;
            }
            doc.remove((Object)"_reporter_");
            String labelId = (String)doc.getFieldValue("_label_");
            doc.remove((Object)"_label_");
            doc.forEach(f -> {
                String key = doc.size() == 1 && f.getName().equals("value") ? MetricRegistry.name((String)labelId, (String[])new String[]{metricName}) : MetricRegistry.name((String)labelId, (String[])new String[]{metricName, f.getName()});
                MetricRegistry registry = this.metricManager.registry(groupId);
                AggregateMetric metric = this.getOrCreate(registry, key);
                Object o = f.getFirstValue();
                if (o != null) {
                    metric.set(reporterId, o);
                } else {
                    metric.clear(reporterId);
                }
            });
        }

        private AggregateMetric getOrCreate(MetricRegistry registry, String name) {
            AggregateMetric existing = (AggregateMetric)registry.getMetrics().get(name);
            if (existing != null) {
                return existing;
            }
            AggregateMetric add = new AggregateMetric();
            try {
                registry.register(name, (Metric)add);
                return add;
            }
            catch (IllegalArgumentException e) {
                existing = (AggregateMetric)registry.getMetrics().get(name);
                if (existing == null) {
                    throw new IllegalArgumentException("Inconsistent metric status, " + name);
                }
                return existing;
            }
        }

        @Override
        public void processDelete(DeleteUpdateCommand cmd) throws IOException {
            throw new UnsupportedOperationException("processDelete");
        }

        @Override
        public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
            throw new UnsupportedOperationException("processMergeIndexes");
        }

        @Override
        public void processCommit(CommitUpdateCommand cmd) throws IOException {
            throw new UnsupportedOperationException("processCommit");
        }

        @Override
        public void processRollback(RollbackUpdateCommand cmd) throws IOException {
            throw new UnsupportedOperationException("processRollback");
        }
    }
}

