/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.AvgSlotAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDoubleMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;

public class AvgAgg
extends SimpleAggValueSource {
    public AvgAgg(ValueSource vs) {
        super("avg", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        return new AvgSlotAcc(this.getArg(), fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    private static class Merger
    extends FacetDoubleMerger {
        long num;
        double sum;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext1) {
            List numberList = (List)facetResult;
            this.num += ((Number)numberList.get(0)).longValue();
            this.sum += ((Number)numberList.get(1)).doubleValue();
        }

        @Override
        protected double getDouble() {
            return this.num == 0L ? 0.0 : this.sum / (double)this.num;
        }
    }
}

