/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TransformBean
implements SessionBean {
    private SessionContext m_context = null;
    private static final String nullErrorMsg = "<h1>XSL transformation error</h1><p>'null' parameters sent to the XSL transformation bean's <tt>transform(String document, String translet)</tt> method.</p>";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";

    private void errorMsg(PrintWriter out, Exception e, String msg) {
        out.println("<h1>Error</h1>");
        out.println("<p>" + msg + "</p><br>");
        out.println(e.toString());
    }

    public String transform(String document, String transletName) {
        PrintWriter out;
        StringWriter sout;
        block5: {
            sout = new StringWriter();
            out = new PrintWriter(sout);
            try {
                if (document == null || transletName == null) {
                    out.println(nullErrorMsg);
                    break block5;
                }
                TransformerFactory tf = TransformerFactory.newInstance();
                try {
                    tf.setAttribute("use-classpath", Boolean.TRUE);
                }
                catch (IllegalArgumentException iae) {
                    System.err.println("Could not set XSLTC-specific TransformerFactory attributes.  Transformation failed.");
                }
                Transformer t = tf.newTransformer(new StreamSource(transletName));
                long start = System.currentTimeMillis();
                t.transform(new StreamSource(document), new StreamResult(out));
                long done = System.currentTimeMillis() - start;
                out.println("<!-- transformed by XSLTC in " + done + "msecs -->");
            }
            catch (Exception e) {
                this.errorMsg(out, e, "Impossible state reached.");
            }
        }
        out.close();
        return sout.toString();
    }

    public void setSessionContext(SessionContext context) {
        this.m_context = context;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbLoad() {
    }

    public void ejbStore() {
    }
}

