/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.lib.FileUtil;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    public static final int LOG_DETAIL = 3;
    public static final int LOG_RESULT = 4;
    public static final String logTypeNameEngine = "ENGINE";
    static final String[] appLogTypeNames = new String[]{"", "ERROR ", "NORMAL", "DETAIL"};
    static final String[] sqlLogTypeNames = new String[]{"", "BASIC ", "NORMAL", "DETAIL", "RESULT"};
    private PrintWriter writer;
    private int level;
    private boolean isSystem;
    private boolean isSQL;
    String[] logTypeNames;
    private String filePath;
    private StringBuffer sb;

    public SimpleLog(String string, int n, boolean bl) {
        this.isSystem = string == null;
        this.filePath = string;
        this.isSQL = bl;
        this.logTypeNames = bl ? sqlLogTypeNames : appLogTypeNames;
        this.sb = new StringBuffer(256);
        this.setLevel(n);
    }

    private void setupWriter() {
        if (this.level == 0) {
            this.close();
            return;
        }
        if (this.writer == null) {
            if (this.isSystem) {
                this.writer = new PrintWriter(System.out);
            } else {
                File file = new File(this.filePath);
                this.setupLog(file);
            }
        }
    }

    private void setupLog(File file) {
        try {
            FileUtil.getFileUtil().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file, true), true);
        }
        catch (Exception exception) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
        this.setupWriter();
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void logContext(int n, String string) {
        if (this.level < n) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        this.sb.append(HsqlDateTime.getSystemTimeString()).append(' ');
        if (!this.isSQL) {
            this.sb.append(this.logTypeNames[n]).append(' ');
        }
        this.sb.append(string);
        this.writer.println(this.sb.toString());
        this.sb.setLength(0);
        this.writer.flush();
    }

    public synchronized void logContext(int n, String string, String string2, String string3) {
        if (this.level < n) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        this.sb.append(HsqlDateTime.getSystemTimeString()).append(' ');
        if (!this.isSQL) {
            this.sb.append(this.logTypeNames[n]).append(' ');
        }
        this.sb.append(string).append(' ');
        this.sb.append(string2).append(' ').append(string3);
        this.writer.println(this.sb.toString());
        this.sb.setLength(0);
        this.writer.flush();
    }

    public synchronized void logContext(Throwable throwable, String string, int n) {
        if (this.level == 0) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        this.sb.append(HsqlDateTime.getSystemTimeString()).append(' ');
        if (!this.isSQL) {
            this.sb.append(this.logTypeNames[n]).append(' ');
        }
        this.sb.append(string);
        Throwable throwable2 = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
        if (stackTraceElementArray.length > 1) {
            this.sb.append(' ');
            this.sb.append(stackTraceElementArray[1].getClassName()).append('.');
            this.sb.append(stackTraceElementArray[1].getMethodName());
        }
        if ((stackTraceElementArray = throwable.getStackTrace()).length > 0) {
            this.sb.append(' ');
            this.sb.append(stackTraceElementArray[0].getClassName()).append('.');
            this.sb.append(' ').append(stackTraceElementArray[0].getMethodName());
        }
        this.sb.append(' ').append(throwable.toString());
        this.writer.println(this.sb.toString());
        this.sb.setLength(0);
        this.writer.flush();
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = null;
    }
}

