'\"
'\" Generated from file 'exact\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2015 Kevin B\&. Kenny <kennykb@acm\&.org>
'\" Redistribution permitted under the terms of the Open Publication License <http://www\&.opencontent\&.org/openpub/>
'\"
.TH "math::exact" n 1\&.0 tcllib "Tcl Math Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
math::exact \- Exact Real Arithmetic
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBgrammar::aycock  1\&.0\fR
.sp
package require \fBmath::exact  1\&.0\fR
.sp
\fB::math::exact::exactexpr\fR \fIexpr\fR
.sp
\fInumber\fR \fBref\fR
.sp
\fInumber\fR \fBunref\fR
.sp
\fInumber\fR \fBasPrint\fR \fIprecision\fR
.sp
\fInumber\fR \fBasFloat\fR \fIprecision\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBexactexpr\fR command in the \fBmath::exact\fR package
allows for exact computations over the computable real numbers\&.
These are not arbitrary-precision calculations; rather they are
exact, with numbers represented by algorithms that produce successive
approximations\&. At the end of a calculation, the caller can
request a given precision for the end result, and intermediate results are
computed to whatever precision is necessary to satisfy the request\&.
.SH PROCEDURES
The following procedure is the primary entry into the \fBmath::exact\fR
package\&.
.TP
\fB::math::exact::exactexpr\fR \fIexpr\fR
Accepts a mathematical expression in Tcl syntax, and returns an object
that represents the program to calculate successive approximations to
the expression's value\&. The result will be referred to as an
exact real number\&.
.TP
\fInumber\fR \fBref\fR
Increases the reference count of a given exact real number\&.
.TP
\fInumber\fR \fBunref\fR
Decreases the reference count of a given exact real number, and destroys
the number if the reference count is zero\&.
.TP
\fInumber\fR \fBasPrint\fR \fIprecision\fR
Formats the given \fInumber\fR for printing, with the specified \fIprecision\fR\&.
(See below for how \fIprecision\fR is interpreted)\&. Numbers that are known to
be rational are formatted as fractions\&.
.TP
\fInumber\fR \fBasFloat\fR \fIprecision\fR
Formats the given \fInumber\fR for printing, with the specified \fIprecision\fR\&.
(See below for how \fIprecision\fR is interpreted)\&. All numbers are formatted
in floating-point E format\&.
.PP
.SH PARAMETERS
.TP
\fIexpr\fR
Expression to evaluate\&. The syntax for expressions is the same as it is in Tcl,
but the set of operations is smaller\&. See \fBExpressions\fR below
for details\&.
.TP
\fInumber\fR
The object returned by an earlier invocation of \fBmath::exact::exactexpr\fR
.TP
\fIprecision\fR
The requested 'precision' of the result\&. The precision is (approximately)
the absolute value of the binary exponent plus the number of bits of the
binary significand\&. For instance, to return results to IEEE-754 double
precision, 56 bits plus the exponent are required\&. Numbers between 1/2 and 2
will require a precision of 57; numbers between 1/4 and 1/2 or between 2 and 4
will require 58; numbers between 1/8 and 1/4 or between 4 and 8 will require
59; and so on\&.
.PP
.SH EXPRESSIONS
The \fBmath::exact::exactexpr\fR command accepts expressions in a subset
of Tcl's syntax\&. The following components may be used in an expression\&.
.IP \(bu
Decimal integers\&.
.IP \(bu
Variable references with the dollar sign (\fB$\fR)\&.
The value of the variable must be the result of another call to
\fBmath::exact::exactexpr\fR\&. The reference count of the value
will be increased by one for each position at which it appears
in the expression\&.
.IP \(bu
The exponentiation operator (\fB**\fR)\&.
.IP \(bu
Unary plus (\fB+\fR) and minus (\fB-\fR) operators\&.
.IP \(bu
Multiplication (\fB*\fR) and division (\fB/\fR) operators\&.
.IP \(bu
Parentheses used for grouping\&.
.IP \(bu
Functions\&. See \fBFunctions\fR below for the functions that are
available\&.
.PP
.SH FUNCTIONS
The following functions are available for use within exact real expressions\&.
.TP
\fBacos(\fR\fIx\fR\fB)\fR
The inverse cosine of \fIx\fR\&. The result is expressed in radians\&.
The absolute value of \fIx\fR must be less than 1\&.
.TP
\fBacosh(\fR\fIx\fR\fB)\fR
The inverse hyperbolic cosine of \fIx\fR\&.
\fIx\fR must be greater than 1\&.
.TP
\fBasin(\fR\fIx\fR\fB)\fR
The inverse sine of \fIx\fR\&. The result is expressed in radians\&.
The absolute value of \fIx\fR must be less than 1\&.
.TP
\fBasinh(\fR\fIx\fR\fB)\fR
The inverse hyperbolic sine of \fIx\fR\&.
.TP
\fBatan(\fR\fIx\fR\fB)\fR
The inverse tangent of \fIx\fR\&. The result is expressed in radians\&.
.TP
\fBatanh(\fR\fIx\fR\fB)\fR
The inverse hyperbolic tangent of \fIx\fR\&.
The absolute value of \fIx\fR must be less than 1\&.
.TP
\fBcos(\fR\fIx\fR\fB)\fR
The cosine of \fIx\fR\&. \fIx\fR is expressed in radians\&.
.TP
\fBcosh(\fR\fIx\fR\fB)\fR
The hyperbolic cosine of \fIx\fR\&.
.TP
\fBe()\fR
The base of the natural logarithms = \fB2\&.71828\&.\&.\&.\fR
.TP
\fBexp(\fR\fIx\fR\fB)\fR
The exponential function of \fIx\fR\&.
.TP
\fBlog(\fR\fIx\fR\fB)\fR
The natural logarithm of \fIx\fR\&. \fIx\fR must be positive\&.
.TP
\fBpi()\fR
The value of pi = \fB3\&.15159\&.\&.\&.\fR
.TP
\fBsin(\fR\fIx\fR\fB)\fR
The sine of \fIx\fR\&. \fIx\fR is expressed in radians\&.
.TP
\fBsinh(\fR\fIx\fR\fB)\fR
The hyperbolic sine of \fIx\fR\&.
.TP
\fBsqrt(\fR\fIx\fR\fB)\fR
The square root of \fIx\fR\&. \fIx\fR must be positive\&.
.TP
\fBtan(\fR\fIx\fR\fB)\fR
The tangent of \fIx\fR\&. \fIx\fR is expressed in radians\&.
.TP
\fBtanh(\fR\fIx\fR\fB)\fR
The hyperbolic tangent of \fIx\fR\&.
.PP
.SH SUMMARY
The \fBmath::exact::exactexpr\fR command provides a system that
performs exact arithmetic over computable real numbers, representing
the numbers as algorithms for successive approximation\&.
An example, which implements the high-school quadratic formula,
is shown below\&.
.CS


namespace import math::exact::exactexpr
proc exactquad {a b c} {
    set d [[exactexpr {sqrt($b*$b - 4*$a*$c)}] ref]
    set r0 [[exactexpr {(-$b - $d) / (2 * $a)}] ref]
    set r1 [[exactexpr {(-$b + $d) / (2 * $a)}] ref]
    $d unref
    return [list $r0 $r1]
}

set a [[exactexpr 1] ref]
set b [[exactexpr 200] ref]
set c [[exactexpr {(-3/2) * 10**-12}] ref]
lassign [exactquad $a $b $c] r0 r1
$a unref; $b unref; $c unref
puts [list [$r0 asFloat 70] [$r1 asFloat 110]]
$r0 unref; $r1 unref

.CE
The program prints the result:
.CS


-2\&.000000000000000075e2 7\&.499999999999999719e-15

.CE
Note that if IEEE-754 floating point had been used, a catastrophic
roundoff error would yield a smaller root that is a factor of two
too high:
.CS


-200\&.0 1\&.4210854715202004e-14

.CE
The invocations of \fBexactexpr\fR should be fairly self-explanatory\&.
The other commands of note are \fBref\fR and \fBunref\fR\&. It is necessary
for the caller to keep track of references to exact expressions - to call
\fBref\fR every time an exact expression is stored in a variable and
\fBunref\fR every time the variable goes out of scope or is overwritten\&.
The \fBasFloat\fR method emits decimal digits as long as the requested
precision supports them\&. It terminates when the requested precision
yields an uncertainty of more than one unit in the least significant digit\&.
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2015 Kevin B\&. Kenny <kennykb@acm\&.org>
Redistribution permitted under the terms of the Open Publication License <http://www\&.opencontent\&.org/openpub/>

.fi