/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.common.ProviderUtil;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.CACertCmd;
import gnu.classpath.tools.keytool.CertReqCmd;
import gnu.classpath.tools.keytool.DeleteCmd;
import gnu.classpath.tools.keytool.ExportCmd;
import gnu.classpath.tools.keytool.GenKeyCmd;
import gnu.classpath.tools.keytool.IdentityDBCmd;
import gnu.classpath.tools.keytool.ImportCmd;
import gnu.classpath.tools.keytool.KeyCloneCmd;
import gnu.classpath.tools.keytool.KeyPasswdCmd;
import gnu.classpath.tools.keytool.ListCmd;
import gnu.classpath.tools.keytool.Messages;
import gnu.classpath.tools.keytool.PrintCertCmd;
import gnu.classpath.tools.keytool.SelfCertCmd;
import gnu.classpath.tools.keytool.StorePasswdCmd;
import gnu.javax.crypto.jce.GnuCrypto;
import gnu.javax.security.auth.callback.GnuCallbacks;
import java.security.Provider;
import java.util.logging.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class.getName());
    static final String KEYTOOL_TOOL = "keytool";
    static final String GENKEY_CMD = "genkey";
    static final String IMPORT_CMD = "import";
    static final String SELFCERT_CMD = "selfcert";
    static final String IDENTITYDB_CMD = "identitydb";
    static final String CERTREQ_CMD = "certreq";
    static final String EXPORT_CMD = "export";
    static final String LIST_CMD = "list";
    static final String PRINTCERT_CMD = "printcert";
    static final String KEYCLONE_CMD = "keyclone";
    static final String STOREPASSWD_CMD = "storepasswd";
    static final String KEYPASSWD_CMD = "keypasswd";
    static final String DELETE_CMD = "delete";
    static final String CACERT_CMD = "cacert";
    static final String _GENKEY = "-genkey";
    static final String _IMPORT = "-import";
    static final String _SELFCERT = "-selfcert";
    static final String _IDENTITYDB = "-identitydb";
    static final String _CERTREQ = "-certreq";
    static final String _EXPORT = "-export";
    static final String _LIST = "-list";
    static final String _PRINTCERT = "-printcert";
    static final String _KEYCLONE = "-keyclone";
    static final String _STOREPASSWD = "-storepasswd";
    static final String _KEYPASSWD = "-keypasswd";
    static final String _DELETE = "-delete";
    static final String _HELP = "-help";
    static final String _CACERT = "-cacert";
    static final String ALIAS_OPT = "alias";
    static final String SIGALG_OPT = "sigalg";
    static final String KEYALG_OPT = "keyalg";
    static final String KEYSIZE_OPT = "keysize";
    static final String KEYPASS_OPT = "keypass";
    static final String VALIDITY_OPT = "validity";
    static final String STORETYPE_OPT = "storetype";
    static final String STOREPASS_OPT = "storepass";
    static final String KEYSTORE_OPT = "keystore";
    static final String PROVIDER_OPT = "provider";
    static final String FILE_OPT = "file";
    static final String VERBOSE_OPT = "v";
    static final String DEST_OPT = "dest";
    static final String NEW_OPT = "new";
    static final String RFC_OPT = "rfc";
    static final String DNAME_OPT = "dname";
    static final String LAST_SERIAL_NUMBER = "lastSerialNumber";
    static final String X_509 = "X.509";
    private boolean helpPrinted;
    private int gnuCryptoProviderNdx = -2;
    private int gnuCallbacksNdx = -2;
    private Parser cmdLineParser;
    private ShutdownHook shutdownThread = new ShutdownHook();

    private Main() {
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    /*
     * Loose catch block
     */
    public static final void main(String[] args) {
        int result;
        block16: {
            if (Configuration.DEBUG) {
                log.entering(Main.class.getName(), "main", args);
            }
            Main tool = new Main();
            result = 1;
            try {
                tool.setup();
                tool.start(args);
                result = 0;
            }
            catch (OptionException x) {
                System.err.println(x.getMessage());
                if (tool.cmdLineParser != null) {
                    tool.cmdLineParser.printHelp();
                }
                tool.teardown();
                if (tool.shutdownThread != null) {
                    Runtime.getRuntime().removeShutdownHook(tool.shutdownThread);
                }
                break block16;
            }
            catch (SecurityException x) {
                if (Configuration.DEBUG) {
                    log.throwing(Main.class.getName(), "main", x);
                }
                System.err.println(Messages.getFormattedString("Main.6", x.getMessage()));
                break block16;
            }
            catch (Exception x) {
                if (Configuration.DEBUG) {
                    log.throwing(Main.class.getName(), "main", x);
                }
                System.err.println(Messages.getFormattedString("Main.8", x));
                tool.teardown();
                if (tool.shutdownThread == null) break block16;
                Runtime.getRuntime().removeShutdownHook(tool.shutdownThread);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                break block16;
            }
            {
                finally {
                    tool.teardown();
                    if (tool.shutdownThread != null) {
                        Runtime.getRuntime().removeShutdownHook(tool.shutdownThread);
                    }
                }
            }
            tool.teardown();
            if (tool.shutdownThread == null) break block16;
            Runtime.getRuntime().removeShutdownHook(tool.shutdownThread);
        }
        if (Configuration.DEBUG) {
            log.exiting(Main.class.getName(), "main", result);
        }
        System.exit(result);
    }

    private void setup() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "setup");
        }
        this.cmdLineParser = this.getParser();
        this.gnuCryptoProviderNdx = ProviderUtil.addProvider((Provider)new GnuCrypto());
        this.gnuCallbacksNdx = ProviderUtil.addProvider((Provider)new GnuCallbacks());
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "setup");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void start(String[] args) throws Exception {
        if (Configuration.DEBUG) {
            Main.log.entering(this.getClass().getName(), "start");
        }
        if (args != null && args.length != 0) ** GOTO lbl53
        throw new OptionException("");
lbl-1000:
        // 1 sources

        {
            opt = args[0];
            cmd = null;
            if ("-genkey".equals(opt)) {
                cmd = new GenKeyCmd();
            } else if ("-import".equals(opt)) {
                cmd = new ImportCmd();
            } else if ("-selfcert".equals(opt)) {
                cmd = new SelfCertCmd();
            } else if ("-identitydb".equals(opt)) {
                cmd = new IdentityDBCmd();
            } else if ("-certreq".equals(opt)) {
                cmd = new CertReqCmd();
            } else if ("-export".equals(opt)) {
                cmd = new ExportCmd();
            } else if ("-list".equals(opt)) {
                cmd = new ListCmd();
            } else if ("-printcert".equals(opt)) {
                cmd = new PrintCertCmd();
            } else if ("-keyclone".equals(opt)) {
                cmd = new KeyCloneCmd();
            } else if ("-storepasswd".equals(opt)) {
                cmd = new StorePasswdCmd();
            } else if ("-keypasswd".equals(opt)) {
                cmd = new KeyPasswdCmd();
            } else if ("-delete".equals(opt)) {
                cmd = new DeleteCmd();
            } else if ("-cacert".equals(opt)) {
                cmd = new CACertCmd();
            } else {
                if ("-help".equals(opt)) {
                    throw new OptionException("");
                }
                throw new OptionException(Messages.getFormattedString("Main.18", opt));
            }
            cmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, cmdArgs, 0, cmdArgs.length);
            args = cmd.processArgs(cmdArgs);
            cmd.doCommand();
lbl53:
            // 2 sources

            ** while (args.length > 0)
        }
lbl54:
        // 1 sources

        if (Configuration.DEBUG) {
            Main.log.exiting(this.getClass().getName(), "start");
        }
    }

    private Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser(KEYTOOL_TOOL, true);
        result.setHeader(Messages.getString("Main.19"));
        result.setFooter(Messages.getString("Main.20"));
        OptionGroup cmdGroup = new OptionGroup(Messages.getString("Main.21"));
        cmdGroup.add(new NoParseOption(GENKEY_CMD, Messages.getString("Main.22")));
        cmdGroup.add(new NoParseOption(IMPORT_CMD, Messages.getString("Main.23")));
        cmdGroup.add(new NoParseOption(SELFCERT_CMD, Messages.getString("Main.24")));
        cmdGroup.add(new NoParseOption(IDENTITYDB_CMD, Messages.getString("Main.25")));
        cmdGroup.add(new NoParseOption(CERTREQ_CMD, Messages.getString("Main.26")));
        cmdGroup.add(new NoParseOption(EXPORT_CMD, Messages.getString("Main.27")));
        cmdGroup.add(new NoParseOption(LIST_CMD, Messages.getString("Main.28")));
        cmdGroup.add(new NoParseOption(PRINTCERT_CMD, Messages.getString("Main.29")));
        cmdGroup.add(new NoParseOption(KEYCLONE_CMD, Messages.getString("Main.30")));
        cmdGroup.add(new NoParseOption(STOREPASSWD_CMD, Messages.getString("Main.31")));
        cmdGroup.add(new NoParseOption(KEYPASSWD_CMD, Messages.getString("Main.32")));
        cmdGroup.add(new NoParseOption(DELETE_CMD, Messages.getString("Main.33")));
        cmdGroup.add(new NoParseOption(CACERT_CMD, Messages.getString("Main.5")));
        result.add(cmdGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    void teardown() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "teardown");
        }
        if (this.gnuCryptoProviderNdx > 0) {
            ProviderUtil.removeProvider("GNU-CRYPTO");
        }
        if (this.gnuCallbacksNdx > 0) {
            ProviderUtil.removeProvider("GNU-CALLBACKS");
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "teardown");
        }
    }

    private class NoParseOption
    extends Option {
        public NoParseOption(String name, String description) {
            super(name, description);
        }

        public NoParseOption(String name, String description, String param) {
            super(name, description, param);
        }

        public void parsed(String argument) throws OptionException {
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            Main.this.teardown();
        }
    }
}

