/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.CDR.AbstractDataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
extends FilterOutputStream
implements AbstractDataOutput {
    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public synchronized void write(int value) throws IOException {
        this.out.write(value);
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        this.out.write(buf, offset, len);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public void writeByte(int value) throws IOException {
        this.write(value & 0xFF);
    }

    public synchronized void writeShort(int value) throws IOException {
        this.write((byte)(0xFF & value));
        this.write((byte)(0xFF & value >> 8));
    }

    public synchronized void writeChar(int value) throws IOException {
        this.write((byte)(0xFF & value));
        this.write((byte)(0xFF & value >> 8));
    }

    public synchronized void writeInt(int value) throws IOException {
        this.write((byte)(0xFF & value));
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value >> 16));
        this.write((byte)(0xFF & value >> 24));
    }

    public synchronized void writeLong(long value) throws IOException {
        this.write((byte)(0xFFL & value));
        this.write((byte)(0xFFL & value >> 8));
        this.write((byte)(0xFFL & value >> 16));
        this.write((byte)(0xFFL & value >> 24));
        this.write((byte)(0xFFL & value >> 32));
        this.write((byte)(0xFFL & value >> 40));
        this.write((byte)(0xFFL & value >> 48));
        this.write((byte)(0xFFL & value >> 56));
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }
}

