/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -4328196481005934313L;
    private int hgap;
    private int vgap;
    private Hashtable tab;
    private static final int FIRST = 0;
    private static final int LAST = 1;
    private static final int NEXT = 2;
    private static final int PREV = 3;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.tab = new Hashtable();
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof String)) {
            throw new IllegalArgumentException("Object " + constraints + " is not a string");
        }
        this.addLayoutComponent((String)constraints, comp);
    }

    public void addLayoutComponent(String name, Component comp) {
        this.tab.put(name, comp);
        comp.setVisible(this.tab.size() == 1);
    }

    public void first(Container parent) {
        this.gotoComponent(parent, 0);
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container target) {
    }

    public void last(Container parent) {
        this.gotoComponent(parent, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width = parent.width;
            int height = parent.height;
            Insets ins = parent.getInsets();
            int num = parent.ncomponents;
            Component[] comps = parent.component;
            int x = ins.left + this.hgap;
            int y = ins.top + this.vgap;
            width = width - 2 * this.hgap - ins.left - ins.right;
            height = height - 2 * this.vgap - ins.top - ins.bottom;
            int i = 0;
            while (i < num) {
                comps[i].setBounds(x, y, width, height);
                ++i;
            }
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        if (target == null || target.ncomponents == 0) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return this.getSize(target, 1);
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.getSize(target, 0);
    }

    public void next(Container parent) {
        this.gotoComponent(parent, 2);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize(parent, 2);
    }

    public void previous(Container parent) {
        this.gotoComponent(parent, 3);
    }

    public void removeLayoutComponent(Component comp) {
        Enumeration e = this.tab.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.tab.get(key) != comp) continue;
            this.tab.remove(key);
            Container parent = comp.getParent();
            this.next(parent);
            break;
        }
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void show(Container parent, String name) {
        if (name == null) {
            return;
        }
        if (parent.getLayout() != this) {
            throw new IllegalArgumentException("parent's layout is not this CardLayout");
        }
        Object target = this.tab.get(name);
        if (target != null) {
            int num = parent.ncomponents;
            Component[] comps = parent.component;
            int i = 0;
            while (i < num) {
                if (comps[i].isVisible()) {
                    if (target == comps[i]) {
                        return;
                    }
                    comps[i].setVisible(false);
                }
                ++i;
            }
            ((Component)target).setVisible(true);
            parent.validate();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoComponent(Container parent, int what) {
        if (parent.getLayout() != this) {
            throw new IllegalArgumentException("parent's layout is not this CardLayout");
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int num = parent.ncomponents;
            Component[] comps = parent.component;
            if (num == 1) {
                comps[0].setVisible(true);
                return;
            }
            int choice = -1;
            if (what == 0) {
                choice = 0;
            } else if (what == 1) {
                choice = num - 1;
            }
            int i = 0;
            while (i < num) {
                if (comps[i].isVisible()) {
                    if (choice == i) {
                        return;
                    }
                    if (what == 3) {
                        choice = i - 1;
                        if (choice < 0) {
                            choice = num - 1;
                        }
                    } else if (what == 2 && (choice = i + 1) == num) {
                        choice = 0;
                    }
                    comps[i].setVisible(false);
                    if (choice >= 0) {
                        break;
                    }
                } else {
                    comps[i].setVisible(true);
                }
                ++i;
            }
            if (choice >= 0 && choice < num) {
                comps[choice].setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getSize(Container parent, int what) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            int num = parent.ncomponents;
            Component[] comps = parent.component;
            int i = 0;
            while (i < num) {
                Dimension d = what == 0 ? comps[i].getMinimumSize() : (what == 1 ? comps[i].getMaximumSize() : comps[i].getPreferredSize());
                w = Math.max(d.width, w);
                h = Math.max(d.height, h);
                ++i;
            }
            Insets i2 = parent.getInsets();
            h += 2 * this.vgap + i2.bottom + i2.top;
            if ((w += 2 * this.hgap + i2.right + i2.left) < 0) {
                w = Integer.MAX_VALUE;
            }
            if (h < 0) {
                h = Integer.MAX_VALUE;
            }
            return new Dimension(w, h);
        }
    }
}

