/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Short
extends Number
implements Comparable<Short> {
    private static final long serialVersionUID = 7515723908773894738L;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = VMClassLoader.getPrimitiveClass('S');
    public static final int SIZE = 16;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Short[] shortCache = new Short[256];
    private final short value;

    static {
        short i = -128;
        while (i <= 127) {
            Short.shortCache[i - -128] = new Short(i);
            i = (short)(i + 1);
        }
    }

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) {
        this.value = Short.parseShort(s, 10);
    }

    public static String toString(short s) {
        return String.valueOf(s);
    }

    public static short parseShort(String s) {
        return Short.parseShort(s, 10);
    }

    public static short parseShort(String s, int radix) {
        int i = Integer.parseInt(s, radix, false);
        if ((short)i != i) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    public static Short valueOf(String s, int radix) {
        return Short.parseShort(s, radix);
    }

    public static Short valueOf(String s) {
        return Short.parseShort(s, 10);
    }

    public static Short valueOf(short val) {
        if (val < -128 || val > 127) {
            return new Short(val);
        }
        return shortCache[val - -128];
    }

    public static Short decode(String s) {
        int i = Integer.parseInt(s, 10, true);
        if ((short)i != i) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Short && this.value == ((Short)obj).value;
    }

    @Override
    public int compareTo(Short s) {
        return this.value - s.value;
    }

    public static int compare(short x, short y) {
        return Short.valueOf(x).compareTo(y);
    }

    public static short reverseBytes(short val) {
        return (short)(val >> 8 & 0xFF | val << 8 & 0xFF00);
    }
}

