"""Generated message classes for dlp version v2.

Provides methods for detection, risk analysis, and de-identification of
privacy-sensitive fragments in text, images, and Google Cloud Platform storage
repositories.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dlp'


class DlpInfoTypesListRequest(_messages.Message):
  r"""A DlpInfoTypesListRequest object.

  Fields:
    filter: Optional filter to only return infoTypes supported by certain
      parts of the API. Defaults to supported_by=INSPECT.
    languageCode: Optional BCP-47 language code for localized infoType
      friendly names. If omitted, or if localized strings are not available,
      en-US strings will be returned.
  """

  filter = _messages.StringField(1)
  languageCode = _messages.StringField(2)


class DlpOrganizationsDeidentifyTemplatesCreateRequest(_messages.Message):
  r"""A DlpOrganizationsDeidentifyTemplatesCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateDeidentifyTemplateRequest: A
      GooglePrivacyDlpV2CreateDeidentifyTemplateRequest resource to be passed
      as the request body.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  googlePrivacyDlpV2CreateDeidentifyTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2CreateDeidentifyTemplateRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpOrganizationsDeidentifyTemplatesDeleteRequest(_messages.Message):
  r"""A DlpOrganizationsDeidentifyTemplatesDeleteRequest object.

  Fields:
    name: Resource name of the organization and deidentify template to be
      deleted, for example
      `organizations/433245324/deidentifyTemplates/432452342` or projects
      /project-id/deidentifyTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpOrganizationsDeidentifyTemplatesGetRequest(_messages.Message):
  r"""A DlpOrganizationsDeidentifyTemplatesGetRequest object.

  Fields:
    name: Resource name of the organization and deidentify template to be
      read, for example
      `organizations/433245324/deidentifyTemplates/432452342` or projects
      /project-id/deidentifyTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpOrganizationsDeidentifyTemplatesListRequest(_messages.Message):
  r"""A DlpOrganizationsDeidentifyTemplatesListRequest object.

  Fields:
    orderBy: Optional comma separated list of fields to order by, followed by
      `asc` or `desc` postfix. This list is case-insensitive, default sorting
      order is ascending, redundant space characters are insignificant.
      Example: `name asc,update_time, create_time desc`  Supported fields are:
      - `create_time`: corresponds to time the template was created. -
      `update_time`: corresponds to time the template was last updated. -
      `name`: corresponds to template's name. - `display_name`: corresponds to
      template's display name.
    pageSize: Optional size of the page, can be limited by server. If zero
      server returns a page of max size 100.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to `ListDeidentifyTemplates`.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DlpOrganizationsDeidentifyTemplatesPatchRequest(_messages.Message):
  r"""A DlpOrganizationsDeidentifyTemplatesPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateDeidentifyTemplateRequest: A
      GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest resource to be passed
      as the request body.
    name: Resource name of organization and deidentify template to be updated,
      for example `organizations/433245324/deidentifyTemplates/432452342` or
      projects/project-id/deidentifyTemplates/432452342.
  """

  googlePrivacyDlpV2UpdateDeidentifyTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpOrganizationsInspectTemplatesCreateRequest(_messages.Message):
  r"""A DlpOrganizationsInspectTemplatesCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateInspectTemplateRequest: A
      GooglePrivacyDlpV2CreateInspectTemplateRequest resource to be passed as
      the request body.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  googlePrivacyDlpV2CreateInspectTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2CreateInspectTemplateRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpOrganizationsInspectTemplatesDeleteRequest(_messages.Message):
  r"""A DlpOrganizationsInspectTemplatesDeleteRequest object.

  Fields:
    name: Resource name of the organization and inspectTemplate to be deleted,
      for example `organizations/433245324/inspectTemplates/432452342` or
      projects/project-id/inspectTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpOrganizationsInspectTemplatesGetRequest(_messages.Message):
  r"""A DlpOrganizationsInspectTemplatesGetRequest object.

  Fields:
    name: Resource name of the organization and inspectTemplate to be read,
      for example `organizations/433245324/inspectTemplates/432452342` or
      projects/project-id/inspectTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpOrganizationsInspectTemplatesListRequest(_messages.Message):
  r"""A DlpOrganizationsInspectTemplatesListRequest object.

  Fields:
    orderBy: Optional comma separated list of fields to order by, followed by
      `asc` or `desc` postfix. This list is case-insensitive, default sorting
      order is ascending, redundant space characters are insignificant.
      Example: `name asc,update_time, create_time desc`  Supported fields are:
      - `create_time`: corresponds to time the template was created. -
      `update_time`: corresponds to time the template was last updated. -
      `name`: corresponds to template's name. - `display_name`: corresponds to
      template's display name.
    pageSize: Optional size of the page, can be limited by server. If zero
      server returns a page of max size 100.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to `ListInspectTemplates`.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DlpOrganizationsInspectTemplatesPatchRequest(_messages.Message):
  r"""A DlpOrganizationsInspectTemplatesPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateInspectTemplateRequest: A
      GooglePrivacyDlpV2UpdateInspectTemplateRequest resource to be passed as
      the request body.
    name: Resource name of organization and inspectTemplate to be updated, for
      example `organizations/433245324/inspectTemplates/432452342` or projects
      /project-id/inspectTemplates/432452342.
  """

  googlePrivacyDlpV2UpdateInspectTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateInspectTemplateRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpOrganizationsStoredInfoTypesCreateRequest(_messages.Message):
  r"""A DlpOrganizationsStoredInfoTypesCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateStoredInfoTypeRequest: A
      GooglePrivacyDlpV2CreateStoredInfoTypeRequest resource to be passed as
      the request body.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  googlePrivacyDlpV2CreateStoredInfoTypeRequest = _messages.MessageField('GooglePrivacyDlpV2CreateStoredInfoTypeRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpOrganizationsStoredInfoTypesDeleteRequest(_messages.Message):
  r"""A DlpOrganizationsStoredInfoTypesDeleteRequest object.

  Fields:
    name: Resource name of the organization and storedInfoType to be deleted,
      for example `organizations/433245324/storedInfoTypes/432452342` or
      projects/project-id/storedInfoTypes/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpOrganizationsStoredInfoTypesGetRequest(_messages.Message):
  r"""A DlpOrganizationsStoredInfoTypesGetRequest object.

  Fields:
    name: Resource name of the organization and storedInfoType to be read, for
      example `organizations/433245324/storedInfoTypes/432452342` or projects
      /project-id/storedInfoTypes/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpOrganizationsStoredInfoTypesListRequest(_messages.Message):
  r"""A DlpOrganizationsStoredInfoTypesListRequest object.

  Fields:
    pageSize: Optional size of the page, can be limited by server. If zero
      server returns a page of max size 100.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to `ListStoredInfoTypes`.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DlpOrganizationsStoredInfoTypesPatchRequest(_messages.Message):
  r"""A DlpOrganizationsStoredInfoTypesPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateStoredInfoTypeRequest: A
      GooglePrivacyDlpV2UpdateStoredInfoTypeRequest resource to be passed as
      the request body.
    name: Resource name of organization and storedInfoType to be updated, for
      example `organizations/433245324/storedInfoTypes/432452342` or projects
      /project-id/storedInfoTypes/432452342.
  """

  googlePrivacyDlpV2UpdateStoredInfoTypeRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateStoredInfoTypeRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpProjectsContentDeidentifyRequest(_messages.Message):
  r"""A DlpProjectsContentDeidentifyRequest object.

  Fields:
    googlePrivacyDlpV2DeidentifyContentRequest: A
      GooglePrivacyDlpV2DeidentifyContentRequest resource to be passed as the
      request body.
    parent: The parent resource name, for example projects/my-project-id.
  """

  googlePrivacyDlpV2DeidentifyContentRequest = _messages.MessageField('GooglePrivacyDlpV2DeidentifyContentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsContentInspectRequest(_messages.Message):
  r"""A DlpProjectsContentInspectRequest object.

  Fields:
    googlePrivacyDlpV2InspectContentRequest: A
      GooglePrivacyDlpV2InspectContentRequest resource to be passed as the
      request body.
    parent: The parent resource name, for example projects/my-project-id.
  """

  googlePrivacyDlpV2InspectContentRequest = _messages.MessageField('GooglePrivacyDlpV2InspectContentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsContentReidentifyRequest(_messages.Message):
  r"""A DlpProjectsContentReidentifyRequest object.

  Fields:
    googlePrivacyDlpV2ReidentifyContentRequest: A
      GooglePrivacyDlpV2ReidentifyContentRequest resource to be passed as the
      request body.
    parent: The parent resource name.
  """

  googlePrivacyDlpV2ReidentifyContentRequest = _messages.MessageField('GooglePrivacyDlpV2ReidentifyContentRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsDeidentifyTemplatesCreateRequest(_messages.Message):
  r"""A DlpProjectsDeidentifyTemplatesCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateDeidentifyTemplateRequest: A
      GooglePrivacyDlpV2CreateDeidentifyTemplateRequest resource to be passed
      as the request body.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  googlePrivacyDlpV2CreateDeidentifyTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2CreateDeidentifyTemplateRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsDeidentifyTemplatesDeleteRequest(_messages.Message):
  r"""A DlpProjectsDeidentifyTemplatesDeleteRequest object.

  Fields:
    name: Resource name of the organization and deidentify template to be
      deleted, for example
      `organizations/433245324/deidentifyTemplates/432452342` or projects
      /project-id/deidentifyTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsDeidentifyTemplatesGetRequest(_messages.Message):
  r"""A DlpProjectsDeidentifyTemplatesGetRequest object.

  Fields:
    name: Resource name of the organization and deidentify template to be
      read, for example
      `organizations/433245324/deidentifyTemplates/432452342` or projects
      /project-id/deidentifyTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsDeidentifyTemplatesListRequest(_messages.Message):
  r"""A DlpProjectsDeidentifyTemplatesListRequest object.

  Fields:
    orderBy: Optional comma separated list of fields to order by, followed by
      `asc` or `desc` postfix. This list is case-insensitive, default sorting
      order is ascending, redundant space characters are insignificant.
      Example: `name asc,update_time, create_time desc`  Supported fields are:
      - `create_time`: corresponds to time the template was created. -
      `update_time`: corresponds to time the template was last updated. -
      `name`: corresponds to template's name. - `display_name`: corresponds to
      template's display name.
    pageSize: Optional size of the page, can be limited by server. If zero
      server returns a page of max size 100.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to `ListDeidentifyTemplates`.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DlpProjectsDeidentifyTemplatesPatchRequest(_messages.Message):
  r"""A DlpProjectsDeidentifyTemplatesPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateDeidentifyTemplateRequest: A
      GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest resource to be passed
      as the request body.
    name: Resource name of organization and deidentify template to be updated,
      for example `organizations/433245324/deidentifyTemplates/432452342` or
      projects/project-id/deidentifyTemplates/432452342.
  """

  googlePrivacyDlpV2UpdateDeidentifyTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpProjectsDlpJobsCancelRequest(_messages.Message):
  r"""A DlpProjectsDlpJobsCancelRequest object.

  Fields:
    googlePrivacyDlpV2CancelDlpJobRequest: A
      GooglePrivacyDlpV2CancelDlpJobRequest resource to be passed as the
      request body.
    name: The name of the DlpJob resource to be cancelled.
  """

  googlePrivacyDlpV2CancelDlpJobRequest = _messages.MessageField('GooglePrivacyDlpV2CancelDlpJobRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpProjectsDlpJobsCreateRequest(_messages.Message):
  r"""A DlpProjectsDlpJobsCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateDlpJobRequest: A
      GooglePrivacyDlpV2CreateDlpJobRequest resource to be passed as the
      request body.
    parent: The parent resource name, for example projects/my-project-id.
  """

  googlePrivacyDlpV2CreateDlpJobRequest = _messages.MessageField('GooglePrivacyDlpV2CreateDlpJobRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsDlpJobsDeleteRequest(_messages.Message):
  r"""A DlpProjectsDlpJobsDeleteRequest object.

  Fields:
    name: The name of the DlpJob resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsDlpJobsGetRequest(_messages.Message):
  r"""A DlpProjectsDlpJobsGetRequest object.

  Fields:
    name: The name of the DlpJob resource.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsDlpJobsListRequest(_messages.Message):
  r"""A DlpProjectsDlpJobsListRequest object.

  Enums:
    TypeValueValuesEnum: The type of job. Defaults to `DlpJobType.INSPECT`

  Fields:
    filter: Optional. Allows filtering.  Supported syntax:  * Filter
      expressions are made up of one or more restrictions. * Restrictions can
      be combined by `AND` or `OR` logical operators. A sequence of
      restrictions implicitly uses `AND`. * A restriction has the form of
      `<field> <operator> <value>`. * Supported fields/values for inspect
      jobs:     - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED     -
      `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY     -
      `trigger_name` - The resource name of the trigger that created job. *
      Supported fields for risk analysis jobs:     - `state` -
      RUNNING|CANCELED|FINISHED|FAILED * The operator must be `=` or `!=`.
      Examples:  * inspected_storage = cloud_storage AND state = done *
      inspected_storage = cloud_storage OR inspected_storage = bigquery *
      inspected_storage = cloud_storage AND (state = done OR state = canceled)
      The length of this field should be no more than 500 characters.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: The parent resource name, for example projects/my-project-id.
    type: The type of job. Defaults to `DlpJobType.INSPECT`
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of job. Defaults to `DlpJobType.INSPECT`

    Values:
      DLP_JOB_TYPE_UNSPECIFIED: <no description>
      INSPECT_JOB: <no description>
      RISK_ANALYSIS_JOB: <no description>
    """
    DLP_JOB_TYPE_UNSPECIFIED = 0
    INSPECT_JOB = 1
    RISK_ANALYSIS_JOB = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class DlpProjectsImageRedactRequest(_messages.Message):
  r"""A DlpProjectsImageRedactRequest object.

  Fields:
    googlePrivacyDlpV2RedactImageRequest: A
      GooglePrivacyDlpV2RedactImageRequest resource to be passed as the
      request body.
    parent: The parent resource name, for example projects/my-project-id.
  """

  googlePrivacyDlpV2RedactImageRequest = _messages.MessageField('GooglePrivacyDlpV2RedactImageRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsInspectTemplatesCreateRequest(_messages.Message):
  r"""A DlpProjectsInspectTemplatesCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateInspectTemplateRequest: A
      GooglePrivacyDlpV2CreateInspectTemplateRequest resource to be passed as
      the request body.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  googlePrivacyDlpV2CreateInspectTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2CreateInspectTemplateRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsInspectTemplatesDeleteRequest(_messages.Message):
  r"""A DlpProjectsInspectTemplatesDeleteRequest object.

  Fields:
    name: Resource name of the organization and inspectTemplate to be deleted,
      for example `organizations/433245324/inspectTemplates/432452342` or
      projects/project-id/inspectTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsInspectTemplatesGetRequest(_messages.Message):
  r"""A DlpProjectsInspectTemplatesGetRequest object.

  Fields:
    name: Resource name of the organization and inspectTemplate to be read,
      for example `organizations/433245324/inspectTemplates/432452342` or
      projects/project-id/inspectTemplates/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsInspectTemplatesListRequest(_messages.Message):
  r"""A DlpProjectsInspectTemplatesListRequest object.

  Fields:
    orderBy: Optional comma separated list of fields to order by, followed by
      `asc` or `desc` postfix. This list is case-insensitive, default sorting
      order is ascending, redundant space characters are insignificant.
      Example: `name asc,update_time, create_time desc`  Supported fields are:
      - `create_time`: corresponds to time the template was created. -
      `update_time`: corresponds to time the template was last updated. -
      `name`: corresponds to template's name. - `display_name`: corresponds to
      template's display name.
    pageSize: Optional size of the page, can be limited by server. If zero
      server returns a page of max size 100.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to `ListInspectTemplates`.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DlpProjectsInspectTemplatesPatchRequest(_messages.Message):
  r"""A DlpProjectsInspectTemplatesPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateInspectTemplateRequest: A
      GooglePrivacyDlpV2UpdateInspectTemplateRequest resource to be passed as
      the request body.
    name: Resource name of organization and inspectTemplate to be updated, for
      example `organizations/433245324/inspectTemplates/432452342` or projects
      /project-id/inspectTemplates/432452342.
  """

  googlePrivacyDlpV2UpdateInspectTemplateRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateInspectTemplateRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpProjectsJobTriggersCreateRequest(_messages.Message):
  r"""A DlpProjectsJobTriggersCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateJobTriggerRequest: A
      GooglePrivacyDlpV2CreateJobTriggerRequest resource to be passed as the
      request body.
    parent: The parent resource name, for example projects/my-project-id.
  """

  googlePrivacyDlpV2CreateJobTriggerRequest = _messages.MessageField('GooglePrivacyDlpV2CreateJobTriggerRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsJobTriggersDeleteRequest(_messages.Message):
  r"""A DlpProjectsJobTriggersDeleteRequest object.

  Fields:
    name: Resource name of the project and the triggeredJob, for example
      `projects/dlp-test-project/jobTriggers/53234423`.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsJobTriggersGetRequest(_messages.Message):
  r"""A DlpProjectsJobTriggersGetRequest object.

  Fields:
    name: Resource name of the project and the triggeredJob, for example
      `projects/dlp-test-project/jobTriggers/53234423`.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsJobTriggersListRequest(_messages.Message):
  r"""A DlpProjectsJobTriggersListRequest object.

  Fields:
    orderBy: Optional comma separated list of triggeredJob fields to order by,
      followed by `asc` or `desc` postfix. This list is case-insensitive,
      default sorting order is ascending, redundant space characters are
      insignificant.  Example: `name asc,update_time, create_time desc`
      Supported fields are:  - `create_time`: corresponds to time the
      JobTrigger was created. - `update_time`: corresponds to time the
      JobTrigger was last updated. - `name`: corresponds to JobTrigger's name.
      - `display_name`: corresponds to JobTrigger's display name. - `status`:
      corresponds to JobTrigger's status.
    pageSize: Optional size of the page, can be limited by a server.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to ListJobTriggers. `order_by` field must not change for subsequent
      calls.
    parent: The parent resource name, for example `projects/my-project-id`.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DlpProjectsJobTriggersPatchRequest(_messages.Message):
  r"""A DlpProjectsJobTriggersPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateJobTriggerRequest: A
      GooglePrivacyDlpV2UpdateJobTriggerRequest resource to be passed as the
      request body.
    name: Resource name of the project and the triggeredJob, for example
      `projects/dlp-test-project/jobTriggers/53234423`.
  """

  googlePrivacyDlpV2UpdateJobTriggerRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateJobTriggerRequest', 1)
  name = _messages.StringField(2, required=True)


class DlpProjectsStoredInfoTypesCreateRequest(_messages.Message):
  r"""A DlpProjectsStoredInfoTypesCreateRequest object.

  Fields:
    googlePrivacyDlpV2CreateStoredInfoTypeRequest: A
      GooglePrivacyDlpV2CreateStoredInfoTypeRequest resource to be passed as
      the request body.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  googlePrivacyDlpV2CreateStoredInfoTypeRequest = _messages.MessageField('GooglePrivacyDlpV2CreateStoredInfoTypeRequest', 1)
  parent = _messages.StringField(2, required=True)


class DlpProjectsStoredInfoTypesDeleteRequest(_messages.Message):
  r"""A DlpProjectsStoredInfoTypesDeleteRequest object.

  Fields:
    name: Resource name of the organization and storedInfoType to be deleted,
      for example `organizations/433245324/storedInfoTypes/432452342` or
      projects/project-id/storedInfoTypes/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsStoredInfoTypesGetRequest(_messages.Message):
  r"""A DlpProjectsStoredInfoTypesGetRequest object.

  Fields:
    name: Resource name of the organization and storedInfoType to be read, for
      example `organizations/433245324/storedInfoTypes/432452342` or projects
      /project-id/storedInfoTypes/432452342.
  """

  name = _messages.StringField(1, required=True)


class DlpProjectsStoredInfoTypesListRequest(_messages.Message):
  r"""A DlpProjectsStoredInfoTypesListRequest object.

  Fields:
    pageSize: Optional size of the page, can be limited by server. If zero
      server returns a page of max size 100.
    pageToken: Optional page token to continue retrieval. Comes from previous
      call to `ListStoredInfoTypes`.
    parent: The parent resource name, for example projects/my-project-id or
      organizations/my-org-id.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DlpProjectsStoredInfoTypesPatchRequest(_messages.Message):
  r"""A DlpProjectsStoredInfoTypesPatchRequest object.

  Fields:
    googlePrivacyDlpV2UpdateStoredInfoTypeRequest: A
      GooglePrivacyDlpV2UpdateStoredInfoTypeRequest resource to be passed as
      the request body.
    name: Resource name of organization and storedInfoType to be updated, for
      example `organizations/433245324/storedInfoTypes/432452342` or projects
      /project-id/storedInfoTypes/432452342.
  """

  googlePrivacyDlpV2UpdateStoredInfoTypeRequest = _messages.MessageField('GooglePrivacyDlpV2UpdateStoredInfoTypeRequest', 1)
  name = _messages.StringField(2, required=True)


class GooglePrivacyDlpV2Action(_messages.Message):
  r"""A task to execute on the completion of a job. See
  https://cloud.google.com/dlp/docs/concepts-actions to learn more.

  Fields:
    pubSub: Publish a notification to a pubsub topic.
    publishSummaryToCscc: Publish summary to Cloud Security Command Center
      (Alpha).
    saveFindings: Save resulting findings in a provided location.
  """

  pubSub = _messages.MessageField('GooglePrivacyDlpV2PublishToPubSub', 1)
  publishSummaryToCscc = _messages.MessageField('GooglePrivacyDlpV2PublishSummaryToCscc', 2)
  saveFindings = _messages.MessageField('GooglePrivacyDlpV2SaveFindings', 3)


class GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails(_messages.Message):
  r"""Result of a risk analysis operation request.

  Fields:
    categoricalStatsResult: A GooglePrivacyDlpV2CategoricalStatsResult
      attribute.
    deltaPresenceEstimationResult: A
      GooglePrivacyDlpV2DeltaPresenceEstimationResult attribute.
    kAnonymityResult: A GooglePrivacyDlpV2KAnonymityResult attribute.
    kMapEstimationResult: A GooglePrivacyDlpV2KMapEstimationResult attribute.
    lDiversityResult: A GooglePrivacyDlpV2LDiversityResult attribute.
    numericalStatsResult: A GooglePrivacyDlpV2NumericalStatsResult attribute.
    requestedPrivacyMetric: Privacy metric to compute.
    requestedSourceTable: Input dataset to compute metrics over.
  """

  categoricalStatsResult = _messages.MessageField('GooglePrivacyDlpV2CategoricalStatsResult', 1)
  deltaPresenceEstimationResult = _messages.MessageField('GooglePrivacyDlpV2DeltaPresenceEstimationResult', 2)
  kAnonymityResult = _messages.MessageField('GooglePrivacyDlpV2KAnonymityResult', 3)
  kMapEstimationResult = _messages.MessageField('GooglePrivacyDlpV2KMapEstimationResult', 4)
  lDiversityResult = _messages.MessageField('GooglePrivacyDlpV2LDiversityResult', 5)
  numericalStatsResult = _messages.MessageField('GooglePrivacyDlpV2NumericalStatsResult', 6)
  requestedPrivacyMetric = _messages.MessageField('GooglePrivacyDlpV2PrivacyMetric', 7)
  requestedSourceTable = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 8)


class GooglePrivacyDlpV2AuxiliaryTable(_messages.Message):
  r"""An auxiliary table contains statistical information on the relative
  frequency of different quasi-identifiers values. It has one or several
  quasi-identifiers columns, and one column that indicates the relative
  frequency of each quasi-identifier tuple. If a tuple is present in the data
  but not in the auxiliary table, the corresponding relative frequency is
  assumed to be zero (and thus, the tuple is highly reidentifiable).

  Fields:
    quasiIds: Quasi-identifier columns. [required]
    relativeFrequency: The relative frequency column must contain a floating-
      point number between 0 and 1 (inclusive). Null values are assumed to be
      zero. [required]
    table: Auxiliary table location. [required]
  """

  quasiIds = _messages.MessageField('GooglePrivacyDlpV2QuasiIdField', 1, repeated=True)
  relativeFrequency = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)
  table = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 3)


class GooglePrivacyDlpV2BigQueryField(_messages.Message):
  r"""Message defining a field of a BigQuery table.

  Fields:
    field: Designated field in the BigQuery table.
    table: Source table of the field.
  """

  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)
  table = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 2)


class GooglePrivacyDlpV2BigQueryKey(_messages.Message):
  r"""Row key for identifying a record in BigQuery table.

  Fields:
    rowNumber: Absolute number of the row from the beginning of the table at
      the time of scanning.
    tableReference: Complete BigQuery table reference.
  """

  rowNumber = _messages.IntegerField(1)
  tableReference = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 2)


class GooglePrivacyDlpV2BigQueryOptions(_messages.Message):
  r"""Options defining BigQuery table and row identifiers.

  Enums:
    SampleMethodValueValuesEnum:

  Fields:
    identifyingFields: References to fields uniquely identifying rows within
      the table. Nested fields in the format, like `person.birthdate.year`,
      are allowed.
    rowsLimit: Max number of rows to scan. If the table has more rows than
      this value, the rest of the rows are omitted. If not set, or if set to
      0, all rows will be scanned. Only one of rows_limit and
      rows_limit_percent can be specified. Cannot be used in conjunction with
      TimespanConfig.
    rowsLimitPercent: Max percentage of rows to scan. The rest are omitted.
      The number of rows scanned is rounded down. Must be between 0 and 100,
      inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of
      rows_limit and rows_limit_percent can be specified. Cannot be used in
      conjunction with TimespanConfig.
    sampleMethod: A SampleMethodValueValuesEnum attribute.
    tableReference: Complete BigQuery table reference.
  """

  class SampleMethodValueValuesEnum(_messages.Enum):
    r"""SampleMethodValueValuesEnum enum type.

    Values:
      SAMPLE_METHOD_UNSPECIFIED: <no description>
      TOP: Scan from the top (default).
      RANDOM_START: Randomly pick the row to start scanning. The scanned rows
        are contiguous.
    """
    SAMPLE_METHOD_UNSPECIFIED = 0
    TOP = 1
    RANDOM_START = 2

  identifyingFields = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1, repeated=True)
  rowsLimit = _messages.IntegerField(2)
  rowsLimitPercent = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sampleMethod = _messages.EnumField('SampleMethodValueValuesEnum', 4)
  tableReference = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 5)


class GooglePrivacyDlpV2BigQueryTable(_messages.Message):
  r"""Message defining the location of a BigQuery table. A table is uniquely
  identified  by its project_id, dataset_id, and table_name. Within a query a
  table is often referenced with a string in the format of:
  `<project_id>:<dataset_id>.<table_id>` or
  `<project_id>.<dataset_id>.<table_id>`.

  Fields:
    datasetId: Dataset ID of the table.
    projectId: The Google Cloud Platform project ID of the project containing
      the table. If omitted, project ID is inferred from the API call.
    tableId: Name of the table.
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  tableId = _messages.StringField(3)


class GooglePrivacyDlpV2BoundingBox(_messages.Message):
  r"""Bounding box encompassing detected text within an image.

  Fields:
    height: Height of the bounding box in pixels.
    left: Left coordinate of the bounding box. (0,0) is upper left.
    top: Top coordinate of the bounding box. (0,0) is upper left.
    width: Width of the bounding box in pixels.
  """

  height = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  left = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  top = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  width = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2Bucket(_messages.Message):
  r"""Bucket is represented as a range, along with replacement values.

  Fields:
    max: Upper bound of the range, exclusive; type must match min.
    min: Lower bound of the range, inclusive. Type should be the same as max
      if used.
    replacementValue: Replacement value for this bucket. If not provided the
      default behavior will be to hyphenate the min-max range.
  """

  max = _messages.MessageField('GooglePrivacyDlpV2Value', 1)
  min = _messages.MessageField('GooglePrivacyDlpV2Value', 2)
  replacementValue = _messages.MessageField('GooglePrivacyDlpV2Value', 3)


class GooglePrivacyDlpV2BucketingConfig(_messages.Message):
  r"""Generalization function that buckets values based on ranges. The ranges
  and replacement values are dynamically provided by the user for custom
  behavior, such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH This can be
  used on data of type: number, long, string, timestamp. If the bound `Value`
  type differs from the type of data being transformed, we will first attempt
  converting the type of the data to be transformed to match the type of the
  bound before comparing. See https://cloud.google.com/dlp/docs/concepts-
  bucketing to learn more.

  Fields:
    buckets: Set of buckets. Ranges must be non-overlapping.
  """

  buckets = _messages.MessageField('GooglePrivacyDlpV2Bucket', 1, repeated=True)


class GooglePrivacyDlpV2ByteContentItem(_messages.Message):
  r"""Container for bytes to inspect or redact.

  Enums:
    TypeValueValuesEnum: The type of data stored in the bytes string. Default
      will be TEXT_UTF8.

  Fields:
    data: Content data to inspect or redact.
    type: The type of data stored in the bytes string. Default will be
      TEXT_UTF8.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of data stored in the bytes string. Default will be
    TEXT_UTF8.

    Values:
      BYTES_TYPE_UNSPECIFIED: <no description>
      IMAGE: <no description>
      IMAGE_JPEG: <no description>
      IMAGE_BMP: <no description>
      IMAGE_PNG: <no description>
      IMAGE_SVG: <no description>
      TEXT_UTF8: <no description>
    """
    BYTES_TYPE_UNSPECIFIED = 0
    IMAGE = 1
    IMAGE_JPEG = 2
    IMAGE_BMP = 3
    IMAGE_PNG = 4
    IMAGE_SVG = 5
    TEXT_UTF8 = 6

  data = _messages.BytesField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GooglePrivacyDlpV2CancelDlpJobRequest(_messages.Message):
  r"""The request message for canceling a DLP job."""


class GooglePrivacyDlpV2CategoricalStatsConfig(_messages.Message):
  r"""Compute numerical stats over an individual column, including number of
  distinct values and value count distribution.

  Fields:
    field: Field to compute categorical stats on. All column types are
      supported except for arrays and structs. However, it may be more
      informative to use NumericalStats when the field type is supported,
      depending on the data.
  """

  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)


class GooglePrivacyDlpV2CategoricalStatsHistogramBucket(_messages.Message):
  r"""A GooglePrivacyDlpV2CategoricalStatsHistogramBucket object.

  Fields:
    bucketSize: Total number of values in this bucket.
    bucketValueCount: Total number of distinct values in this bucket.
    bucketValues: Sample of value frequencies in this bucket. The total number
      of values returned per bucket is capped at 20.
    valueFrequencyLowerBound: Lower bound on the value frequency of the values
      in this bucket.
    valueFrequencyUpperBound: Upper bound on the value frequency of the values
      in this bucket.
  """

  bucketSize = _messages.IntegerField(1)
  bucketValueCount = _messages.IntegerField(2)
  bucketValues = _messages.MessageField('GooglePrivacyDlpV2ValueFrequency', 3, repeated=True)
  valueFrequencyLowerBound = _messages.IntegerField(4)
  valueFrequencyUpperBound = _messages.IntegerField(5)


class GooglePrivacyDlpV2CategoricalStatsResult(_messages.Message):
  r"""Result of the categorical stats computation.

  Fields:
    valueFrequencyHistogramBuckets: Histogram of value frequencies in the
      column.
  """

  valueFrequencyHistogramBuckets = _messages.MessageField('GooglePrivacyDlpV2CategoricalStatsHistogramBucket', 1, repeated=True)


class GooglePrivacyDlpV2CharacterMaskConfig(_messages.Message):
  r"""Partially mask a string by replacing a given number of characters with a
  fixed character. Masking can start from the beginning or end of the string.
  This can be used on data of any type (numbers, longs, and so on) and when
  de-identifying structured data we'll attempt to preserve the original data's
  type. (This allows you to take a long like 123 and modify it to a string
  like **3.

  Fields:
    charactersToIgnore: When masking a string, items in this list will be
      skipped when replacing. For example, if your string is 555-555-5555 and
      you ask us to skip `-` and mask 5 chars with * we would produce
      ***-*55-5555.
    maskingCharacter: Character to mask the sensitive values&mdash;for
      example, "*" for an alphabetic string such as name, or "0" for a numeric
      string such as ZIP code or credit card number. String must have length
      1. If not supplied, we will default to "*" for strings, 0 for digits.
    numberToMask: Number of characters to mask. If not set, all matching chars
      will be masked. Skipped characters do not count towards this tally.
    reverseOrder: Mask characters in reverse order. For example, if
      `masking_character` is '0', number_to_mask is 14, and `reverse_order` is
      false, then 1234-5678-9012-3456 -> 00000000000000-3456 If
      `masking_character` is '*', `number_to_mask` is 3, and `reverse_order`
      is true, then 12345 -> 12***
  """

  charactersToIgnore = _messages.MessageField('GooglePrivacyDlpV2CharsToIgnore', 1, repeated=True)
  maskingCharacter = _messages.StringField(2)
  numberToMask = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  reverseOrder = _messages.BooleanField(4)


class GooglePrivacyDlpV2CharsToIgnore(_messages.Message):
  r"""Characters to skip when doing deidentification of a value. These will be
  left alone and skipped.

  Enums:
    CommonCharactersToIgnoreValueValuesEnum:

  Fields:
    charactersToSkip: A string attribute.
    commonCharactersToIgnore: A CommonCharactersToIgnoreValueValuesEnum
      attribute.
  """

  class CommonCharactersToIgnoreValueValuesEnum(_messages.Enum):
    r"""CommonCharactersToIgnoreValueValuesEnum enum type.

    Values:
      COMMON_CHARS_TO_IGNORE_UNSPECIFIED: <no description>
      NUMERIC: 0-9
      ALPHA_UPPER_CASE: A-Z
      ALPHA_LOWER_CASE: a-z
      PUNCTUATION: US Punctuation, one of !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
      WHITESPACE: Whitespace character, one of [ \t\n\x0B\f\r]
    """
    COMMON_CHARS_TO_IGNORE_UNSPECIFIED = 0
    NUMERIC = 1
    ALPHA_UPPER_CASE = 2
    ALPHA_LOWER_CASE = 3
    PUNCTUATION = 4
    WHITESPACE = 5

  charactersToSkip = _messages.StringField(1)
  commonCharactersToIgnore = _messages.EnumField('CommonCharactersToIgnoreValueValuesEnum', 2)


class GooglePrivacyDlpV2CloudStorageFileSet(_messages.Message):
  r"""Message representing a set of files in Cloud Storage.

  Fields:
    url: The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in
      the path is allowed.
  """

  url = _messages.StringField(1)


class GooglePrivacyDlpV2CloudStorageOptions(_messages.Message):
  r"""Options defining a file or a set of files within a Google Cloud Storage
  bucket.

  Enums:
    FileTypesValueListEntryValuesEnum:
    SampleMethodValueValuesEnum:

  Fields:
    bytesLimitPerFile: Max number of bytes to scan from a file. If a scanned
      file's size is bigger than this value then the rest of the bytes are
      omitted. Only one of bytes_limit_per_file and
      bytes_limit_per_file_percent can be specified.
    bytesLimitPerFilePercent: Max percentage of bytes to scan from a file. The
      rest are omitted. The number of bytes scanned is rounded down. Must be
      between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults
      to 0. Only one of bytes_limit_per_file and bytes_limit_per_file_percent
      can be specified.
    fileSet: The set of one or more files to scan.
    fileTypes: List of file type groups to include in the scan. If empty, all
      files are scanned and available data format processors are applied.
    filesLimitPercent: Limits the number of files to scan to this percentage
      of the input FileSet. Number of files scanned is rounded down. Must be
      between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults
      to 0.
    sampleMethod: A SampleMethodValueValuesEnum attribute.
  """

  class FileTypesValueListEntryValuesEnum(_messages.Enum):
    r"""FileTypesValueListEntryValuesEnum enum type.

    Values:
      FILE_TYPE_UNSPECIFIED: <no description>
      BINARY_FILE: <no description>
      TEXT_FILE: <no description>
    """
    FILE_TYPE_UNSPECIFIED = 0
    BINARY_FILE = 1
    TEXT_FILE = 2

  class SampleMethodValueValuesEnum(_messages.Enum):
    r"""SampleMethodValueValuesEnum enum type.

    Values:
      SAMPLE_METHOD_UNSPECIFIED: <no description>
      TOP: Scan from the top (default).
      RANDOM_START: For each file larger than bytes_limit_per_file, randomly
        pick the offset to start scanning. The scanned bytes are contiguous.
    """
    SAMPLE_METHOD_UNSPECIFIED = 0
    TOP = 1
    RANDOM_START = 2

  bytesLimitPerFile = _messages.IntegerField(1)
  bytesLimitPerFilePercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  fileSet = _messages.MessageField('GooglePrivacyDlpV2FileSet', 3)
  fileTypes = _messages.EnumField('FileTypesValueListEntryValuesEnum', 4, repeated=True)
  filesLimitPercent = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  sampleMethod = _messages.EnumField('SampleMethodValueValuesEnum', 6)


class GooglePrivacyDlpV2CloudStoragePath(_messages.Message):
  r"""Message representing a single file or path in Cloud Storage.

  Fields:
    path: A url representing a file or path (no wildcards) in Cloud Storage.
      Example: gs://[BUCKET_NAME]/dictionary.txt
  """

  path = _messages.StringField(1)


class GooglePrivacyDlpV2Color(_messages.Message):
  r"""Represents a color in the RGB color space.

  Fields:
    blue: The amount of blue in the color as a value in the interval [0, 1].
    green: The amount of green in the color as a value in the interval [0, 1].
    red: The amount of red in the color as a value in the interval [0, 1].
  """

  blue = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  green = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  red = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GooglePrivacyDlpV2Condition(_messages.Message):
  r"""The field type of `value` and `field` do not need to match to be
  considered equal, but not all comparisons are possible.  A `value` of type:
  - `string` can be compared against all other types - `boolean` can only be
  compared against other booleans - `integer` can be compared against doubles
  or a string if the string value can be parsed as an integer. - `double` can
  be compared against integers or a string if the string can be parsed as a
  double. - `Timestamp` can be compared against strings in RFC 3339 date
  string format. - `TimeOfDay` can be compared against timestamps and strings
  in the format of 'HH:mm:ss'.  If we fail to compare do to type mismatch, a
  warning will be given and the condition will evaluate to false.

  Enums:
    OperatorValueValuesEnum: Operator used to compare the field or infoType to
      the value. [required]

  Fields:
    field: Field within the record this condition is evaluated against.
      [required]
    operator: Operator used to compare the field or infoType to the value.
      [required]
    value: Value to compare against. [Required, except for `EXISTS` tests.]
  """

  class OperatorValueValuesEnum(_messages.Enum):
    r"""Operator used to compare the field or infoType to the value.
    [required]

    Values:
      RELATIONAL_OPERATOR_UNSPECIFIED: <no description>
      EQUAL_TO: Equal.
      NOT_EQUAL_TO: Not equal to.
      GREATER_THAN: Greater than.
      LESS_THAN: Less than.
      GREATER_THAN_OR_EQUALS: Greater than or equals.
      LESS_THAN_OR_EQUALS: Less than or equals.
      EXISTS: Exists
    """
    RELATIONAL_OPERATOR_UNSPECIFIED = 0
    EQUAL_TO = 1
    NOT_EQUAL_TO = 2
    GREATER_THAN = 3
    LESS_THAN = 4
    GREATER_THAN_OR_EQUALS = 5
    LESS_THAN_OR_EQUALS = 6
    EXISTS = 7

  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)
  operator = _messages.EnumField('OperatorValueValuesEnum', 2)
  value = _messages.MessageField('GooglePrivacyDlpV2Value', 3)


class GooglePrivacyDlpV2Conditions(_messages.Message):
  r"""A collection of conditions.

  Fields:
    conditions: A GooglePrivacyDlpV2Condition attribute.
  """

  conditions = _messages.MessageField('GooglePrivacyDlpV2Condition', 1, repeated=True)


class GooglePrivacyDlpV2ContentItem(_messages.Message):
  r"""Container structure for the content to inspect.

  Fields:
    byteItem: Content data to inspect or redact. Replaces `type` and `data`.
    table: Structured content for inspection. See
      https://cloud.google.com/dlp/docs/inspecting-text#inspecting_a_table to
      learn more.
    value: String data to inspect or redact.
  """

  byteItem = _messages.MessageField('GooglePrivacyDlpV2ByteContentItem', 1)
  table = _messages.MessageField('GooglePrivacyDlpV2Table', 2)
  value = _messages.StringField(3)


class GooglePrivacyDlpV2ContentLocation(_messages.Message):
  r"""Findings container location data.

  Fields:
    containerName: Name of the container where the finding is located. The top
      level name is the source file name or table name. Nested names could be
      absent if the embedded object has no string identifier (for an example
      an image contained within a document).
    containerTimestamp: Findings container modification timestamp, if
      applicable. For Google Cloud Storage contains last file modification
      timestamp. For BigQuery table contains last_modified_time property. For
      Datastore - not populated.
    containerVersion: Findings container version, if available ("generation"
      for Google Cloud Storage).
    documentLocation: Location data for document files.
    imageLocation: Location within an image's pixels.
    recordLocation: Location within a row or record of a database table.
  """

  containerName = _messages.StringField(1)
  containerTimestamp = _messages.StringField(2)
  containerVersion = _messages.StringField(3)
  documentLocation = _messages.MessageField('GooglePrivacyDlpV2DocumentLocation', 4)
  imageLocation = _messages.MessageField('GooglePrivacyDlpV2ImageLocation', 5)
  recordLocation = _messages.MessageField('GooglePrivacyDlpV2RecordLocation', 6)


class GooglePrivacyDlpV2CreateDeidentifyTemplateRequest(_messages.Message):
  r"""Request message for CreateDeidentifyTemplate.

  Fields:
    deidentifyTemplate: The DeidentifyTemplate to create.
    templateId: The template id can contain uppercase and lowercase letters,
      numbers, and hyphens; that is, it must match the regular expression:
      `[a-zA-Z\\d-]+`. The maximum length is 100 characters. Can be empty to
      allow the system to generate one.
  """

  deidentifyTemplate = _messages.MessageField('GooglePrivacyDlpV2DeidentifyTemplate', 1)
  templateId = _messages.StringField(2)


class GooglePrivacyDlpV2CreateDlpJobRequest(_messages.Message):
  r"""Request message for CreateDlpJobRequest. Used to initiate long running
  jobs such as calculating risk metrics or inspecting Google Cloud Storage.

  Fields:
    inspectJob: A GooglePrivacyDlpV2InspectJobConfig attribute.
    jobId: The job id can contain uppercase and lowercase letters, numbers,
      and hyphens; that is, it must match the regular expression:
      `[a-zA-Z\\d-]+`. The maximum length is 100 characters. Can be empty to
      allow the system to generate one.
    riskJob: A GooglePrivacyDlpV2RiskAnalysisJobConfig attribute.
  """

  inspectJob = _messages.MessageField('GooglePrivacyDlpV2InspectJobConfig', 1)
  jobId = _messages.StringField(2)
  riskJob = _messages.MessageField('GooglePrivacyDlpV2RiskAnalysisJobConfig', 3)


class GooglePrivacyDlpV2CreateInspectTemplateRequest(_messages.Message):
  r"""Request message for CreateInspectTemplate.

  Fields:
    inspectTemplate: The InspectTemplate to create.
    templateId: The template id can contain uppercase and lowercase letters,
      numbers, and hyphens; that is, it must match the regular expression:
      `[a-zA-Z\\d-]+`. The maximum length is 100 characters. Can be empty to
      allow the system to generate one.
  """

  inspectTemplate = _messages.MessageField('GooglePrivacyDlpV2InspectTemplate', 1)
  templateId = _messages.StringField(2)


class GooglePrivacyDlpV2CreateJobTriggerRequest(_messages.Message):
  r"""Request message for CreateJobTrigger.

  Fields:
    jobTrigger: The JobTrigger to create.
    triggerId: The trigger id can contain uppercase and lowercase letters,
      numbers, and hyphens; that is, it must match the regular expression:
      `[a-zA-Z\\d-]+`. The maximum length is 100 characters. Can be empty to
      allow the system to generate one.
  """

  jobTrigger = _messages.MessageField('GooglePrivacyDlpV2JobTrigger', 1)
  triggerId = _messages.StringField(2)


class GooglePrivacyDlpV2CreateStoredInfoTypeRequest(_messages.Message):
  r"""Request message for CreateStoredInfoType.

  Fields:
    config: Configuration of the storedInfoType to create.
    storedInfoTypeId: The storedInfoType ID can contain uppercase and
      lowercase letters, numbers, and hyphens; that is, it must match the
      regular expression: `[a-zA-Z\\d-]+`. The maximum length is 100
      characters. Can be empty to allow the system to generate one.
  """

  config = _messages.MessageField('GooglePrivacyDlpV2StoredInfoTypeConfig', 1)
  storedInfoTypeId = _messages.StringField(2)


class GooglePrivacyDlpV2CryptoHashConfig(_messages.Message):
  r"""Pseudonymization method that generates surrogates via cryptographic
  hashing. Uses SHA-256. The key size must be either 32 or 64 bytes. Outputs a
  32 byte digest as an uppercase hex string (for example,
  41D1567F7F99F1DC2A5FAB886DEE5BEE). Currently, only string and integer values
  can be hashed.

  Fields:
    cryptoKey: The key used by the hash function.
  """

  cryptoKey = _messages.MessageField('GooglePrivacyDlpV2CryptoKey', 1)


class GooglePrivacyDlpV2CryptoKey(_messages.Message):
  r"""This is a data encryption key (DEK) (as opposed to a key encryption key
  (KEK) stored by KMS). When using KMS to wrap/unwrap DEKs, be sure to set an
  appropriate IAM policy on the KMS CryptoKey (KEK) to ensure an attacker
  cannot unwrap the data crypto key.

  Fields:
    kmsWrapped: A GooglePrivacyDlpV2KmsWrappedCryptoKey attribute.
    transient: A GooglePrivacyDlpV2TransientCryptoKey attribute.
    unwrapped: A GooglePrivacyDlpV2UnwrappedCryptoKey attribute.
  """

  kmsWrapped = _messages.MessageField('GooglePrivacyDlpV2KmsWrappedCryptoKey', 1)
  transient = _messages.MessageField('GooglePrivacyDlpV2TransientCryptoKey', 2)
  unwrapped = _messages.MessageField('GooglePrivacyDlpV2UnwrappedCryptoKey', 3)


class GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig(_messages.Message):
  r"""Replaces an identifier with a surrogate using FPE with the FFX mode of
  operation; however when used in the `ReidentifyContent` API method, it
  serves the opposite function by reversing the surrogate back into the
  original identifier. The identifier must be encoded as ASCII. For a given
  crypto key and context, the same identifier will be replaced with the same
  surrogate. Identifiers must be at least two characters long. In the case
  that the identifier is the empty string, it will be skipped. See
  https://cloud.google.com/dlp/docs/pseudonymization to learn more.

  Enums:
    CommonAlphabetValueValuesEnum:

  Fields:
    commonAlphabet: A CommonAlphabetValueValuesEnum attribute.
    context: The 'tweak', a context may be used for higher security since the
      same identifier in two different contexts won't be given the same
      surrogate. If the context is not set, a default tweak will be used.  If
      the context is set but:  1. there is no record present when transforming
      a given value or 1. the field is not present when transforming a given
      value,  a default tweak will be used.  Note that case (1) is expected
      when an `InfoTypeTransformation` is applied to both structured and non-
      structured `ContentItem`s. Currently, the referenced field may be of
      value type integer or string.  The tweak is constructed as a sequence of
      bytes in big endian byte order such that:  - a 64 bit integer is encoded
      followed by a single byte of value 1 - a string is encoded in UTF-8
      format followed by a single byte of value 2
    cryptoKey: The key used by the encryption algorithm. [required]
    customAlphabet: This is supported by mapping these to the alphanumeric
      characters that the FFX mode natively supports. This happens
      before/after encryption/decryption. Each character listed must appear
      only once. Number of characters must be in the range [2, 62]. This must
      be encoded as ASCII. The order of characters does not matter.
    radix: The native way to select the alphabet. Must be in the range [2,
      62].
    surrogateInfoType: The custom infoType to annotate the surrogate with.
      This annotation will be applied to the surrogate by prefixing it with
      the name of the custom infoType followed by the number of characters
      comprising the surrogate. The following scheme defines the format:
      info_type_name(surrogate_character_count):surrogate  For example, if the
      name of custom infoType is 'MY_TOKEN_INFO_TYPE' and the surrogate is
      'abc', the full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc'
      This annotation identifies the surrogate when inspecting content using
      the custom infoType [`SurrogateType`](/dlp/docs/reference/rest/v2/Inspec
      tConfig#surrogatetype). This facilitates reversal of the surrogate when
      it occurs in free text.  In order for inspection to work properly, the
      name of this infoType must not occur naturally anywhere in your data;
      otherwise, inspection may find a surrogate that does not correspond to
      an actual identifier. Therefore, choose your custom infoType name
      carefully after considering what your data looks like. One way to select
      a name that has a high chance of yielding reliable detection is to
      include one or more unicode characters that are highly improbable to
      exist in your data. For example, assuming your data is entered from a
      regular ASCII keyboard, the symbol with the hex code point 29DD might be
      used like so: \u29ddMY_TOKEN_TYPE
  """

  class CommonAlphabetValueValuesEnum(_messages.Enum):
    r"""CommonAlphabetValueValuesEnum enum type.

    Values:
      FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED: <no description>
      NUMERIC: [0-9] (radix of 10)
      HEXADECIMAL: [0-9A-F] (radix of 16)
      UPPER_CASE_ALPHA_NUMERIC: [0-9A-Z] (radix of 36)
      ALPHA_NUMERIC: [0-9A-Za-z] (radix of 62)
    """
    FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED = 0
    NUMERIC = 1
    HEXADECIMAL = 2
    UPPER_CASE_ALPHA_NUMERIC = 3
    ALPHA_NUMERIC = 4

  commonAlphabet = _messages.EnumField('CommonAlphabetValueValuesEnum', 1)
  context = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)
  cryptoKey = _messages.MessageField('GooglePrivacyDlpV2CryptoKey', 3)
  customAlphabet = _messages.StringField(4)
  radix = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  surrogateInfoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 6)


class GooglePrivacyDlpV2CustomInfoType(_messages.Message):
  r"""Custom information type provided by the user. Used to find domain-
  specific sensitive information configurable to the data in question.

  Enums:
    LikelihoodValueValuesEnum: Likelihood to return for this CustomInfoType.
      This base value can be altered by a detection rule if the finding meets
      the criteria specified by the rule. Defaults to `VERY_LIKELY` if not
      specified.

  Fields:
    detectionRules: Set of detection rules to apply to all findings of this
      CustomInfoType. Rules are applied in order that they are specified. Not
      supported for the `surrogate_type` CustomInfoType.
    dictionary: A list of phrases to detect as a CustomInfoType.
    infoType: All CustomInfoTypes must have a name that does not conflict with
      built-in InfoTypes or other CustomInfoTypes.
    likelihood: Likelihood to return for this CustomInfoType. This base value
      can be altered by a detection rule if the finding meets the criteria
      specified by the rule. Defaults to `VERY_LIKELY` if not specified.
    regex: Regular expression based CustomInfoType.
    storedType: Load an existing `StoredInfoType` resource for use in
      `InspectDataSource`. Not currently supported in `InspectContent`.
    surrogateType: Message for detecting output from deidentification
      transformations that support reversing.
  """

  class LikelihoodValueValuesEnum(_messages.Enum):
    r"""Likelihood to return for this CustomInfoType. This base value can be
    altered by a detection rule if the finding meets the criteria specified by
    the rule. Defaults to `VERY_LIKELY` if not specified.

    Values:
      LIKELIHOOD_UNSPECIFIED: Default value; same as POSSIBLE.
      VERY_UNLIKELY: Few matching elements.
      UNLIKELY: <no description>
      POSSIBLE: Some matching elements.
      LIKELY: <no description>
      VERY_LIKELY: Many matching elements.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  detectionRules = _messages.MessageField('GooglePrivacyDlpV2DetectionRule', 1, repeated=True)
  dictionary = _messages.MessageField('GooglePrivacyDlpV2Dictionary', 2)
  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 3)
  likelihood = _messages.EnumField('LikelihoodValueValuesEnum', 4)
  regex = _messages.MessageField('GooglePrivacyDlpV2Regex', 5)
  storedType = _messages.MessageField('GooglePrivacyDlpV2StoredType', 6)
  surrogateType = _messages.MessageField('GooglePrivacyDlpV2SurrogateType', 7)


class GooglePrivacyDlpV2DatastoreKey(_messages.Message):
  r"""Record key for a finding in Cloud Datastore.

  Fields:
    entityKey: Datastore entity key.
  """

  entityKey = _messages.MessageField('GooglePrivacyDlpV2Key', 1)


class GooglePrivacyDlpV2DatastoreOptions(_messages.Message):
  r"""Options defining a data set within Google Cloud Datastore.

  Fields:
    kind: The kind to process.
    partitionId: A partition ID identifies a grouping of entities. The
      grouping is always by project and namespace, however the namespace ID
      may be empty.
  """

  kind = _messages.MessageField('GooglePrivacyDlpV2KindExpression', 1)
  partitionId = _messages.MessageField('GooglePrivacyDlpV2PartitionId', 2)


class GooglePrivacyDlpV2DateShiftConfig(_messages.Message):
  r"""Shifts dates by random number of days, with option to be consistent for
  the same context. See https://cloud.google.com/dlp/docs/concepts-date-
  shifting to learn more.

  Fields:
    context: Points to the field that contains the context, for example, an
      entity id. If set, must also set method. If set, shift will be
      consistent for the given context.
    cryptoKey: Causes the shift to be computed based on this key and the
      context. This results in the same shift for the same context and
      crypto_key.
    lowerBoundDays: For example, -5 means shift date to at most 5 days back in
      the past. [Required]
    upperBoundDays: Range of shift in days. Actual shift will be selected at
      random within this range (inclusive ends). Negative means shift to
      earlier in time. Must not be more than 365250 days (1000 years) each
      direction.  For example, 3 means shift date to at most 3 days into the
      future. [Required]
  """

  context = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)
  cryptoKey = _messages.MessageField('GooglePrivacyDlpV2CryptoKey', 2)
  lowerBoundDays = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  upperBoundDays = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2DateTime(_messages.Message):
  r"""Message for a date time object.

  Enums:
    DayOfWeekValueValuesEnum:

  Fields:
    date: One or more of the following must be set. All fields are optional,
      but when set must be valid date or time values.
    dayOfWeek: A DayOfWeekValueValuesEnum attribute.
    time: A GoogleTypeTimeOfDay attribute.
    timeZone: A GooglePrivacyDlpV2TimeZone attribute.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""DayOfWeekValueValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The unspecified day-of-week.
      MONDAY: The day-of-week of Monday.
      TUESDAY: The day-of-week of Tuesday.
      WEDNESDAY: The day-of-week of Wednesday.
      THURSDAY: The day-of-week of Thursday.
      FRIDAY: The day-of-week of Friday.
      SATURDAY: The day-of-week of Saturday.
      SUNDAY: The day-of-week of Sunday.
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  date = _messages.MessageField('GoogleTypeDate', 1)
  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 2)
  time = _messages.MessageField('GoogleTypeTimeOfDay', 3)
  timeZone = _messages.MessageField('GooglePrivacyDlpV2TimeZone', 4)


class GooglePrivacyDlpV2DeidentifyConfig(_messages.Message):
  r"""The configuration that controls how the data will change.

  Fields:
    infoTypeTransformations: Treat the dataset as free-form text and apply the
      same free text transformation everywhere.
    recordTransformations: Treat the dataset as structured. Transformations
      can be applied to specific locations within structured datasets, such as
      transforming a column within a table.
  """

  infoTypeTransformations = _messages.MessageField('GooglePrivacyDlpV2InfoTypeTransformations', 1)
  recordTransformations = _messages.MessageField('GooglePrivacyDlpV2RecordTransformations', 2)


class GooglePrivacyDlpV2DeidentifyContentRequest(_messages.Message):
  r"""Request to de-identify a list of items.

  Fields:
    deidentifyConfig: Configuration for the de-identification of the content
      item. Items specified here will override the template referenced by the
      deidentify_template_name argument.
    deidentifyTemplateName: Optional template to use. Any configuration
      directly specified in deidentify_config will override those set in the
      template. Singular fields that are set in this request will replace
      their corresponding fields in the template. Repeated fields are
      appended. Singular sub-messages and groups are recursively merged.
    inspectConfig: Configuration for the inspector. Items specified here will
      override the template referenced by the inspect_template_name argument.
    inspectTemplateName: Optional template to use. Any configuration directly
      specified in inspect_config will override those set in the template.
      Singular fields that are set in this request will replace their
      corresponding fields in the template. Repeated fields are appended.
      Singular sub-messages and groups are recursively merged.
    item: The item to de-identify. Will be treated as text.
  """

  deidentifyConfig = _messages.MessageField('GooglePrivacyDlpV2DeidentifyConfig', 1)
  deidentifyTemplateName = _messages.StringField(2)
  inspectConfig = _messages.MessageField('GooglePrivacyDlpV2InspectConfig', 3)
  inspectTemplateName = _messages.StringField(4)
  item = _messages.MessageField('GooglePrivacyDlpV2ContentItem', 5)


class GooglePrivacyDlpV2DeidentifyContentResponse(_messages.Message):
  r"""Results of de-identifying a ContentItem.

  Fields:
    item: The de-identified item.
    overview: An overview of the changes that were made on the `item`.
  """

  item = _messages.MessageField('GooglePrivacyDlpV2ContentItem', 1)
  overview = _messages.MessageField('GooglePrivacyDlpV2TransformationOverview', 2)


class GooglePrivacyDlpV2DeidentifyTemplate(_messages.Message):
  r"""The DeidentifyTemplates contains instructions on how to deidentify
  content. See https://cloud.google.com/dlp/docs/concepts-templates to learn
  more.

  Fields:
    createTime: The creation timestamp of a inspectTemplate, output only
      field.
    deidentifyConfig: ///////////// // The core content of the template  //
      ///////////////
    description: Short description (max 256 chars).
    displayName: Display name (max 256 chars).
    name: The template name. Output only.  The template will have one of the
      following formats: `projects/PROJECT_ID/deidentifyTemplates/TEMPLATE_ID`
      OR `organizations/ORGANIZATION_ID/deidentifyTemplates/TEMPLATE_ID`
    updateTime: The last update timestamp of a inspectTemplate, output only
      field.
  """

  createTime = _messages.StringField(1)
  deidentifyConfig = _messages.MessageField('GooglePrivacyDlpV2DeidentifyConfig', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GooglePrivacyDlpV2DeltaPresenceEstimationConfig(_messages.Message):
  r"""\u03b4-presence metric, used to estimate how likely it is for an
  attacker to figure out that one given individual appears in a de-identified
  dataset. Similarly to the k-map metric, we cannot compute \u03b4-presence
  exactly without knowing the attack dataset, so we use a statistical model
  instead.

  Fields:
    auxiliaryTables: Several auxiliary tables can be used in the analysis.
      Each custom_tag used to tag a quasi-identifiers field must appear in
      exactly one field of one auxiliary table.
    quasiIds: Fields considered to be quasi-identifiers. No two fields can
      have the same tag. [required]
    regionCode: ISO 3166-1 alpha-2 region code to use in the statistical
      modeling. Required if no column is tagged with a region-specific
      InfoType (like US_ZIP_5) or a region code.
  """

  auxiliaryTables = _messages.MessageField('GooglePrivacyDlpV2StatisticalTable', 1, repeated=True)
  quasiIds = _messages.MessageField('GooglePrivacyDlpV2QuasiId', 2, repeated=True)
  regionCode = _messages.StringField(3)


class GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket(_messages.Message):
  r"""A DeltaPresenceEstimationHistogramBucket message with the following
  values:   min_probability: 0.1   max_probability: 0.2   frequency: 42 means
  that there are 42 records for which \u03b4 is in [0.1, 0.2). An important
  particular case is when min_probability = max_probability = 1: then, every
  individual who shares this quasi-identifier combination is in the dataset.

  Fields:
    bucketSize: Number of records within these probability bounds.
    bucketValueCount: Total number of distinct quasi-identifier tuple values
      in this bucket.
    bucketValues: Sample of quasi-identifier tuple values in this bucket. The
      total number of classes returned per bucket is capped at 20.
    maxProbability: Always greater than or equal to min_probability.
    minProbability: Between 0 and 1.
  """

  bucketSize = _messages.IntegerField(1)
  bucketValueCount = _messages.IntegerField(2)
  bucketValues = _messages.MessageField('GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues', 3, repeated=True)
  maxProbability = _messages.FloatField(4)
  minProbability = _messages.FloatField(5)


class GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues(_messages.Message):
  r"""A tuple of values for the quasi-identifier columns.

  Fields:
    estimatedProbability: The estimated probability that a given individual
      sharing these quasi-identifier values is in the dataset. This value,
      typically called \u03b4, is the ratio between the number of records in
      the dataset with these quasi-identifier values, and the total number of
      individuals (inside *and* outside the dataset) with these quasi-
      identifier values. For example, if there are 15 individuals in the
      dataset who share the same quasi-identifier values, and an estimated 100
      people in the entire population with these values, then \u03b4 is 0.15.
    quasiIdsValues: The quasi-identifier values.
  """

  estimatedProbability = _messages.FloatField(1)
  quasiIdsValues = _messages.MessageField('GooglePrivacyDlpV2Value', 2, repeated=True)


class GooglePrivacyDlpV2DeltaPresenceEstimationResult(_messages.Message):
  r"""Result of the \u03b4-presence computation. Note that these results are
  an estimation, not exact values.

  Fields:
    deltaPresenceEstimationHistogram: The intervals [min_probability,
      max_probability) do not overlap. If a value doesn't correspond to any
      such interval, the associated frequency is zero. For example, the
      following records:   {min_probability: 0, max_probability: 0.1,
      frequency: 17}   {min_probability: 0.2, max_probability: 0.3, frequency:
      42}   {min_probability: 0.3, max_probability: 0.4, frequency: 99} mean
      that there are no record with an estimated probability in [0.1, 0.2) nor
      larger or equal to 0.4.
  """

  deltaPresenceEstimationHistogram = _messages.MessageField('GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket', 1, repeated=True)


class GooglePrivacyDlpV2DetectionRule(_messages.Message):
  r"""Rule for modifying a CustomInfoType to alter behavior under certain
  circumstances, depending on the specific details of the rule. Not supported
  for the `surrogate_type` custom info type.

  Fields:
    hotwordRule: Hotword-based detection rule.
  """

  hotwordRule = _messages.MessageField('GooglePrivacyDlpV2HotwordRule', 1)


class GooglePrivacyDlpV2Dictionary(_messages.Message):
  r"""Custom information type based on a dictionary of words or phrases. This
  can be used to match sensitive information specific to the data, such as a
  list of employee IDs or job titles.  Dictionary words are case-insensitive
  and all characters other than letters and digits in the unicode [Basic
  Multilingual Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_
  Multilingual_Plane) will be replaced with whitespace when scanning for
  matches, so the dictionary phrase "Sam Johnson" will match all three phrases
  "sam johnson", "Sam, Johnson", and "Sam (Johnson)". Additionally, the
  characters surrounding any match must be of a different type than the
  adjacent characters within the word, so letters must be next to non-letters
  and digits next to non-digits. For example, the dictionary word "jen" will
  match the first three letters of the text "jen123" but will return no
  matches for "jennifer".  Dictionary words containing a large number of
  characters that are not letters or digits may result in unexpected findings
  because such characters are treated as whitespace. The
  [limits](https://cloud.google.com/dlp/limits) page contains details about
  the size limits of dictionaries. For dictionaries that do not fit within
  these constraints, consider using `LargeCustomDictionaryConfig` in the
  `StoredInfoType` API.

  Fields:
    cloudStoragePath: Newline-delimited file of words in Cloud Storage. Only a
      single file is accepted.
    wordList: List of words or phrases to search for.
  """

  cloudStoragePath = _messages.MessageField('GooglePrivacyDlpV2CloudStoragePath', 1)
  wordList = _messages.MessageField('GooglePrivacyDlpV2WordList', 2)


class GooglePrivacyDlpV2DlpJob(_messages.Message):
  r"""Combines all of the information about a DLP job.

  Enums:
    StateValueValuesEnum: State of a job.
    TypeValueValuesEnum: The type of job.

  Fields:
    createTime: Time when the job was created.
    endTime: Time when the job finished.
    errors: A stream of errors encountered running the job.
    inspectDetails: Results from inspecting a data source.
    jobTriggerName: If created by a job trigger, the resource name of the
      trigger that instantiated the job.
    name: The server-assigned name.
    riskDetails: Results from analyzing risk of a data source.
    startTime: Time when the job started.
    state: State of a job.
    type: The type of job.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of a job.

    Values:
      JOB_STATE_UNSPECIFIED: <no description>
      PENDING: The job has not yet started.
      RUNNING: The job is currently running.
      DONE: The job is no longer running.
      CANCELED: The job was canceled before it could complete.
      FAILED: The job had an error and did not complete.
    """
    JOB_STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3
    CANCELED = 4
    FAILED = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of job.

    Values:
      DLP_JOB_TYPE_UNSPECIFIED: <no description>
      INSPECT_JOB: The job inspected Google Cloud for sensitive data.
      RISK_ANALYSIS_JOB: The job executed a Risk Analysis computation.
    """
    DLP_JOB_TYPE_UNSPECIFIED = 0
    INSPECT_JOB = 1
    RISK_ANALYSIS_JOB = 2

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  errors = _messages.MessageField('GooglePrivacyDlpV2Error', 3, repeated=True)
  inspectDetails = _messages.MessageField('GooglePrivacyDlpV2InspectDataSourceDetails', 4)
  jobTriggerName = _messages.StringField(5)
  name = _messages.StringField(6)
  riskDetails = _messages.MessageField('GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails', 7)
  startTime = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)


class GooglePrivacyDlpV2DocumentLocation(_messages.Message):
  r"""Location of a finding within a document.

  Fields:
    fileOffset: Offset of the line, from the beginning of the file, where the
      finding is located.
  """

  fileOffset = _messages.IntegerField(1)


class GooglePrivacyDlpV2EntityId(_messages.Message):
  r"""An entity in a dataset is a field or set of fields that correspond to a
  single person. For example, in medical records the `EntityId` might be a
  patient identifier, or for financial records it might be an account
  identifier. This message is used when generalizations or analysis must take
  into account that multiple rows correspond to the same entity.

  Fields:
    field: Composite key indicating which field contains the entity
      identifier.
  """

  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)


class GooglePrivacyDlpV2Error(_messages.Message):
  r"""Details information about an error encountered during job execution or
  the results of an unsuccessful activation of the JobTrigger. Output only
  field.

  Fields:
    details: A GoogleRpcStatus attribute.
    timestamps: The times the error occurred.
  """

  details = _messages.MessageField('GoogleRpcStatus', 1)
  timestamps = _messages.StringField(2, repeated=True)


class GooglePrivacyDlpV2Expressions(_messages.Message):
  r"""An expression, consisting or an operator and conditions.

  Enums:
    LogicalOperatorValueValuesEnum: The operator to apply to the result of
      conditions. Default and currently only supported value is `AND`.

  Fields:
    conditions: A GooglePrivacyDlpV2Conditions attribute.
    logicalOperator: The operator to apply to the result of conditions.
      Default and currently only supported value is `AND`.
  """

  class LogicalOperatorValueValuesEnum(_messages.Enum):
    r"""The operator to apply to the result of conditions. Default and
    currently only supported value is `AND`.

    Values:
      LOGICAL_OPERATOR_UNSPECIFIED: <no description>
      AND: <no description>
    """
    LOGICAL_OPERATOR_UNSPECIFIED = 0
    AND = 1

  conditions = _messages.MessageField('GooglePrivacyDlpV2Conditions', 1)
  logicalOperator = _messages.EnumField('LogicalOperatorValueValuesEnum', 2)


class GooglePrivacyDlpV2FieldId(_messages.Message):
  r"""General identifier of a data field in a storage service.

  Fields:
    name: Name describing the field.
  """

  name = _messages.StringField(1)


class GooglePrivacyDlpV2FieldTransformation(_messages.Message):
  r"""The transformation to apply to the field.

  Fields:
    condition: Only apply the transformation if the condition evaluates to
      true for the given `RecordCondition`. The conditions are allowed to
      reference fields that are not used in the actual transformation.
      [optional]  Example Use Cases:  - Apply a different bucket
      transformation to an age column if the zip code column for the same
      record is within a specific range. - Redact a field if the date of birth
      field is greater than 85.
    fields: Input field(s) to apply the transformation to. [required]
    infoTypeTransformations: Treat the contents of the field as free text, and
      selectively transform content that matches an `InfoType`.
    primitiveTransformation: Apply the transformation to the entire field.
  """

  condition = _messages.MessageField('GooglePrivacyDlpV2RecordCondition', 1)
  fields = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2, repeated=True)
  infoTypeTransformations = _messages.MessageField('GooglePrivacyDlpV2InfoTypeTransformations', 3)
  primitiveTransformation = _messages.MessageField('GooglePrivacyDlpV2PrimitiveTransformation', 4)


class GooglePrivacyDlpV2FileSet(_messages.Message):
  r"""Set of files to scan.

  Fields:
    url: The Cloud Storage url of the file(s) to scan, in the format
      `gs://<bucket>/<path>`. Trailing wildcard in the path is allowed.
  """

  url = _messages.StringField(1)


class GooglePrivacyDlpV2Finding(_messages.Message):
  r"""Represents a piece of potentially sensitive content.

  Enums:
    LikelihoodValueValuesEnum: Confidence of how likely it is that the
      `info_type` is correct.

  Fields:
    createTime: Timestamp when finding was detected.
    infoType: The type of content that might have been found. Provided if
      `excluded_types` is false.
    likelihood: Confidence of how likely it is that the `info_type` is
      correct.
    location: Where the content was found.
    quote: The content that was found. Even if the content is not textual, it
      may be converted to a textual representation here. Provided if
      `include_quote` is true and the finding is less than or equal to 4096
      bytes long. If the finding exceeds 4096 bytes in length, the quote may
      be omitted.
    quoteInfo: Contains data parsed from quotes. Only populated if
      include_quote was set to true and a supported infoType was requested.
      Currently supported infoTypes: DATE, DATE_OF_BIRTH and TIME.
  """

  class LikelihoodValueValuesEnum(_messages.Enum):
    r"""Confidence of how likely it is that the `info_type` is correct.

    Values:
      LIKELIHOOD_UNSPECIFIED: Default value; same as POSSIBLE.
      VERY_UNLIKELY: Few matching elements.
      UNLIKELY: <no description>
      POSSIBLE: Some matching elements.
      LIKELY: <no description>
      VERY_LIKELY: Many matching elements.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  createTime = _messages.StringField(1)
  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 2)
  likelihood = _messages.EnumField('LikelihoodValueValuesEnum', 3)
  location = _messages.MessageField('GooglePrivacyDlpV2Location', 4)
  quote = _messages.StringField(5)
  quoteInfo = _messages.MessageField('GooglePrivacyDlpV2QuoteInfo', 6)


class GooglePrivacyDlpV2FindingLimits(_messages.Message):
  r"""A GooglePrivacyDlpV2FindingLimits object.

  Fields:
    maxFindingsPerInfoType: Configuration of findings limit given for
      specified infoTypes.
    maxFindingsPerItem: Max number of findings that will be returned for each
      item scanned. When set within `InspectDataSourceRequest`, the maximum
      returned is 1000 regardless if this is set higher. When set within
      `InspectContentRequest`, this field is ignored.
    maxFindingsPerRequest: Max number of findings that will be returned per
      request/job. When set within `InspectContentRequest`, the maximum
      returned is 1000 regardless if this is set higher.
  """

  maxFindingsPerInfoType = _messages.MessageField('GooglePrivacyDlpV2InfoTypeLimit', 1, repeated=True)
  maxFindingsPerItem = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  maxFindingsPerRequest = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2FixedSizeBucketingConfig(_messages.Message):
  r"""Buckets values based on fixed size ranges. The Bucketing transformation
  can provide all of this functionality, but requires more configuration. This
  message is provided as a convenience to the user for simple bucketing
  strategies.  The transformed value will be a hyphenated string of
  <lower_bound>-<upper_bound>, i.e if lower_bound = 10 and upper_bound = 20
  all values that are within this bucket will be replaced with "10-20".  This
  can be used on data of type: double, long.  If the bound Value type differs
  from the type of data being transformed, we will first attempt converting
  the type of the data to be transformed to match the type of the bound before
  comparing.  See https://cloud.google.com/dlp/docs/concepts-bucketing to
  learn more.

  Fields:
    bucketSize: Size of each bucket (except for minimum and maximum buckets).
      So if `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10,
      then the following buckets would be used: -10, 10-20, 20-30, 30-40,
      40-50, 50-60, 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals
      works. [Required].
    lowerBound: Lower bound value of buckets. All values less than
      `lower_bound` are grouped together into a single bucket; for example if
      `lower_bound` = 10, then all values less than 10 are replaced with the
      value "-10". [Required].
    upperBound: Upper bound value of buckets. All values greater than
      upper_bound are grouped together into a single bucket; for example if
      `upper_bound` = 89, then all values greater than 89 are replaced with
      the value "89+". [Required].
  """

  bucketSize = _messages.FloatField(1)
  lowerBound = _messages.MessageField('GooglePrivacyDlpV2Value', 2)
  upperBound = _messages.MessageField('GooglePrivacyDlpV2Value', 3)


class GooglePrivacyDlpV2HotwordRule(_messages.Message):
  r"""The rule that adjusts the likelihood of findings within a certain
  proximity of hotwords.

  Fields:
    hotwordRegex: Regular expression pattern defining what qualifies as a
      hotword.
    likelihoodAdjustment: Likelihood adjustment to apply to all matching
      findings.
    proximity: Proximity of the finding within which the entire hotword must
      reside. The total length of the window cannot exceed 1000 characters.
      Note that the finding itself will be included in the window, so that
      hotwords may be used to match substrings of the finding itself. For
      example, the certainty of a phone number regex "\(\d{3}\) \d{3}-\d{4}"
      could be adjusted upwards if the area code is known to be the local area
      code of a company office using the hotword regex "\(xxx\)", where "xxx"
      is the area code in question.
  """

  hotwordRegex = _messages.MessageField('GooglePrivacyDlpV2Regex', 1)
  likelihoodAdjustment = _messages.MessageField('GooglePrivacyDlpV2LikelihoodAdjustment', 2)
  proximity = _messages.MessageField('GooglePrivacyDlpV2Proximity', 3)


class GooglePrivacyDlpV2ImageLocation(_messages.Message):
  r"""Location of the finding within an image.

  Fields:
    boundingBoxes: Bounding boxes locating the pixels within the image
      containing the finding.
  """

  boundingBoxes = _messages.MessageField('GooglePrivacyDlpV2BoundingBox', 1, repeated=True)


class GooglePrivacyDlpV2ImageRedactionConfig(_messages.Message):
  r"""Configuration for determining how redaction of images should occur.

  Fields:
    infoType: Only one per info_type should be provided per request. If not
      specified, and redact_all_text is false, the DLP API will redact all
      text that it matches against all info_types that are found, but not
      specified in another ImageRedactionConfig.
    redactAllText: If true, all text found in the image, regardless whether it
      matches an info_type, is redacted. Only one should be provided.
    redactionColor: The color to use when redacting content from an image. If
      not specified, the default is black.
  """

  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 1)
  redactAllText = _messages.BooleanField(2)
  redactionColor = _messages.MessageField('GooglePrivacyDlpV2Color', 3)


class GooglePrivacyDlpV2InfoType(_messages.Message):
  r"""Type of information detected by the API.

  Fields:
    name: Name of the information type. Either a name of your choosing when
      creating a CustomInfoType, or one of the names listed at
      https://cloud.google.com/dlp/docs/infotypes-reference when specifying a
      built-in type.
  """

  name = _messages.StringField(1)


class GooglePrivacyDlpV2InfoTypeDescription(_messages.Message):
  r"""InfoType description.

  Enums:
    SupportedByValueListEntryValuesEnum:

  Fields:
    displayName: Human readable form of the infoType name.
    name: Internal name of the infoType.
    supportedBy: Which parts of the API supports this InfoType.
  """

  class SupportedByValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedByValueListEntryValuesEnum enum type.

    Values:
      ENUM_TYPE_UNSPECIFIED: <no description>
      INSPECT: <no description>
      RISK_ANALYSIS: <no description>
    """
    ENUM_TYPE_UNSPECIFIED = 0
    INSPECT = 1
    RISK_ANALYSIS = 2

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  supportedBy = _messages.EnumField('SupportedByValueListEntryValuesEnum', 3, repeated=True)


class GooglePrivacyDlpV2InfoTypeLimit(_messages.Message):
  r"""Max findings configuration per infoType, per content item or long
  running DlpJob.

  Fields:
    infoType: Type of information the findings limit applies to. Only one
      limit per info_type should be provided. If InfoTypeLimit does not have
      an info_type, the DLP API applies the limit against all info_types that
      are found but not specified in another InfoTypeLimit.
    maxFindings: Max findings limit for the given infoType.
  """

  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 1)
  maxFindings = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2InfoTypeStats(_messages.Message):
  r"""Statistics regarding a specific InfoType.

  Fields:
    count: Number of findings for this infoType.
    infoType: The type of finding this stat is for.
  """

  count = _messages.IntegerField(1)
  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 2)


class GooglePrivacyDlpV2InfoTypeTransformation(_messages.Message):
  r"""A transformation to apply to text that is identified as a specific
  info_type.

  Fields:
    infoTypes: InfoTypes to apply the transformation to. An empty list will
      cause this transformation to apply to all findings that correspond to
      infoTypes that were requested in `InspectConfig`.
    primitiveTransformation: Primitive transformation to apply to the
      infoType. [required]
  """

  infoTypes = _messages.MessageField('GooglePrivacyDlpV2InfoType', 1, repeated=True)
  primitiveTransformation = _messages.MessageField('GooglePrivacyDlpV2PrimitiveTransformation', 2)


class GooglePrivacyDlpV2InfoTypeTransformations(_messages.Message):
  r"""A type of transformation that will scan unstructured text and apply
  various `PrimitiveTransformation`s to each finding, where the transformation
  is applied to only values that were identified as a specific info_type.

  Fields:
    transformations: Transformation for each infoType. Cannot specify more
      than one for a given infoType. [required]
  """

  transformations = _messages.MessageField('GooglePrivacyDlpV2InfoTypeTransformation', 1, repeated=True)


class GooglePrivacyDlpV2InspectConfig(_messages.Message):
  r"""Configuration description of the scanning process. When used with
  redactContent only info_types and min_likelihood are currently used.

  Enums:
    ContentOptionsValueListEntryValuesEnum:
    MinLikelihoodValueValuesEnum: Only returns findings equal or above this
      threshold. The default is POSSIBLE. See
      https://cloud.google.com/dlp/docs/likelihood to learn more.

  Fields:
    contentOptions: List of options defining data content to scan. If empty,
      text, images, and other content will be included.
    customInfoTypes: CustomInfoTypes provided by the user. See
      https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn
      more.
    excludeInfoTypes: When true, excludes type information of the findings.
    includeQuote: When true, a contextual quote from the data that triggered a
      finding is included in the response; see Finding.quote.
    infoTypes: Restricts what info_types to look for. The values must
      correspond to InfoType values returned by ListInfoTypes or listed at
      https://cloud.google.com/dlp/docs/infotypes-reference.  When no
      InfoTypes or CustomInfoTypes are specified in a request, the system may
      automatically choose what detectors to run. By default this may be all
      types, but may change over time as detectors are updated.  The special
      InfoType name "ALL_BASIC" can be used to trigger all detectors, but may
      change over time as new InfoTypes are added. If you need precise control
      and predictability as to what detectors are run you should specify
      specific InfoTypes listed in the reference.
    limits: A GooglePrivacyDlpV2FindingLimits attribute.
    minLikelihood: Only returns findings equal or above this threshold. The
      default is POSSIBLE. See https://cloud.google.com/dlp/docs/likelihood to
      learn more.
  """

  class ContentOptionsValueListEntryValuesEnum(_messages.Enum):
    r"""ContentOptionsValueListEntryValuesEnum enum type.

    Values:
      CONTENT_UNSPECIFIED: <no description>
      CONTENT_TEXT: <no description>
      CONTENT_IMAGE: <no description>
    """
    CONTENT_UNSPECIFIED = 0
    CONTENT_TEXT = 1
    CONTENT_IMAGE = 2

  class MinLikelihoodValueValuesEnum(_messages.Enum):
    r"""Only returns findings equal or above this threshold. The default is
    POSSIBLE. See https://cloud.google.com/dlp/docs/likelihood to learn more.

    Values:
      LIKELIHOOD_UNSPECIFIED: Default value; same as POSSIBLE.
      VERY_UNLIKELY: Few matching elements.
      UNLIKELY: <no description>
      POSSIBLE: Some matching elements.
      LIKELY: <no description>
      VERY_LIKELY: Many matching elements.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  contentOptions = _messages.EnumField('ContentOptionsValueListEntryValuesEnum', 1, repeated=True)
  customInfoTypes = _messages.MessageField('GooglePrivacyDlpV2CustomInfoType', 2, repeated=True)
  excludeInfoTypes = _messages.BooleanField(3)
  includeQuote = _messages.BooleanField(4)
  infoTypes = _messages.MessageField('GooglePrivacyDlpV2InfoType', 5, repeated=True)
  limits = _messages.MessageField('GooglePrivacyDlpV2FindingLimits', 6)
  minLikelihood = _messages.EnumField('MinLikelihoodValueValuesEnum', 7)


class GooglePrivacyDlpV2InspectContentRequest(_messages.Message):
  r"""Request to search for potentially sensitive info in a ContentItem.

  Fields:
    inspectConfig: Configuration for the inspector. What specified here will
      override the template referenced by the inspect_template_name argument.
    inspectTemplateName: Optional template to use. Any configuration directly
      specified in inspect_config will override those set in the template.
      Singular fields that are set in this request will replace their
      corresponding fields in the template. Repeated fields are appended.
      Singular sub-messages and groups are recursively merged.
    item: The item to inspect.
  """

  inspectConfig = _messages.MessageField('GooglePrivacyDlpV2InspectConfig', 1)
  inspectTemplateName = _messages.StringField(2)
  item = _messages.MessageField('GooglePrivacyDlpV2ContentItem', 3)


class GooglePrivacyDlpV2InspectContentResponse(_messages.Message):
  r"""Results of inspecting an item.

  Fields:
    result: The findings.
  """

  result = _messages.MessageField('GooglePrivacyDlpV2InspectResult', 1)


class GooglePrivacyDlpV2InspectDataSourceDetails(_messages.Message):
  r"""The results of an inspect DataSource job.

  Fields:
    requestedOptions: The configuration used for this job.
    result: A summary of the outcome of this inspect job.
  """

  requestedOptions = _messages.MessageField('GooglePrivacyDlpV2RequestedOptions', 1)
  result = _messages.MessageField('GooglePrivacyDlpV2Result', 2)


class GooglePrivacyDlpV2InspectJobConfig(_messages.Message):
  r"""A GooglePrivacyDlpV2InspectJobConfig object.

  Fields:
    actions: Actions to execute at the completion of the job. Are executed in
      the order provided.
    inspectConfig: How and what to scan for.
    inspectTemplateName: If provided, will be used as the default for all
      values in InspectConfig. `inspect_config` will be merged into the values
      persisted as part of the template.
    storageConfig: The data to scan.
  """

  actions = _messages.MessageField('GooglePrivacyDlpV2Action', 1, repeated=True)
  inspectConfig = _messages.MessageField('GooglePrivacyDlpV2InspectConfig', 2)
  inspectTemplateName = _messages.StringField(3)
  storageConfig = _messages.MessageField('GooglePrivacyDlpV2StorageConfig', 4)


class GooglePrivacyDlpV2InspectResult(_messages.Message):
  r"""All the findings for a single scanned item.

  Fields:
    findings: List of findings for an item.
    findingsTruncated: If true, then this item might have more findings than
      were returned, and the findings returned are an arbitrary subset of all
      findings. The findings list might be truncated because the input items
      were too large, or because the server reached the maximum amount of
      resources allowed for a single API call. For best results, divide the
      input into smaller batches.
  """

  findings = _messages.MessageField('GooglePrivacyDlpV2Finding', 1, repeated=True)
  findingsTruncated = _messages.BooleanField(2)


class GooglePrivacyDlpV2InspectTemplate(_messages.Message):
  r"""The inspectTemplate contains a configuration (set of types of sensitive
  data to be detected) to be used anywhere you otherwise would normally
  specify InspectConfig. See https://cloud.google.com/dlp/docs/concepts-
  templates to learn more.

  Fields:
    createTime: The creation timestamp of a inspectTemplate, output only
      field.
    description: Short description (max 256 chars).
    displayName: Display name (max 256 chars).
    inspectConfig: The core content of the template. Configuration of the
      scanning process.
    name: The template name. Output only.  The template will have one of the
      following formats: `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR
      `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`
    updateTime: The last update timestamp of a inspectTemplate, output only
      field.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  inspectConfig = _messages.MessageField('GooglePrivacyDlpV2InspectConfig', 4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GooglePrivacyDlpV2JobTrigger(_messages.Message):
  r"""Contains a configuration to make dlp api calls on a repeating basis. See
  https://cloud.google.com/dlp/docs/concepts-job-triggers to learn more.

  Enums:
    StatusValueValuesEnum: A status for this trigger. [required]

  Fields:
    createTime: The creation timestamp of a triggeredJob, output only field.
    description: User provided description (max 256 chars)
    displayName: Display name (max 100 chars)
    errors: A stream of errors encountered when the trigger was activated.
      Repeated errors may result in the JobTrigger automaticaly being paused.
      Will return the last 100 errors. Whenever the JobTrigger is modified
      this list will be cleared. Output only field.
    inspectJob: A GooglePrivacyDlpV2InspectJobConfig attribute.
    lastRunTime: The timestamp of the last time this trigger executed, output
      only field.
    name: Unique resource name for the triggeredJob, assigned by the service
      when the triggeredJob is created, for example `projects/dlp-test-
      project/triggeredJobs/53234423`.
    status: A status for this trigger. [required]
    triggers: A list of triggers which will be OR'ed together. Only one in the
      list needs to trigger for a job to be started. The list may contain only
      a single Schedule trigger and must have at least one object.
    updateTime: The last update timestamp of a triggeredJob, output only
      field.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""A status for this trigger. [required]

    Values:
      STATUS_UNSPECIFIED: <no description>
      HEALTHY: Trigger is healthy.
      PAUSED: Trigger is temporarily paused.
      CANCELLED: Trigger is cancelled and can not be resumed.
    """
    STATUS_UNSPECIFIED = 0
    HEALTHY = 1
    PAUSED = 2
    CANCELLED = 3

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  errors = _messages.MessageField('GooglePrivacyDlpV2Error', 4, repeated=True)
  inspectJob = _messages.MessageField('GooglePrivacyDlpV2InspectJobConfig', 5)
  lastRunTime = _messages.StringField(6)
  name = _messages.StringField(7)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  triggers = _messages.MessageField('GooglePrivacyDlpV2Trigger', 9, repeated=True)
  updateTime = _messages.StringField(10)


class GooglePrivacyDlpV2KAnonymityConfig(_messages.Message):
  r"""k-anonymity metric, used for analysis of reidentification risk.

  Fields:
    entityId: Optional message indicating that multiple rows might be
      associated to a single individual. If the same entity_id is associated
      to multiple quasi-identifier tuples over distict rows, we consider the
      entire collection of tuples as the composite quasi-identifier. This
      collection is a multiset: the order in which the different tuples appear
      in the dataset is ignored, but their frequency is taken into account.
      Important note: a maximum of 1000 rows can be associated to a single
      entity ID. If more rows are associated with the same entity ID, some
      might be ignored.
    quasiIds: Set of fields to compute k-anonymity over. When multiple fields
      are specified, they are considered a single composite key. Structs and
      repeated data types are not supported; however, nested fields are
      supported so long as they are not structs themselves or nested within a
      repeated field.
  """

  entityId = _messages.MessageField('GooglePrivacyDlpV2EntityId', 1)
  quasiIds = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2, repeated=True)


class GooglePrivacyDlpV2KAnonymityEquivalenceClass(_messages.Message):
  r"""The set of columns' values that share the same ldiversity value

  Fields:
    equivalenceClassSize: Size of the equivalence class, for example number of
      rows with the above set of values.
    quasiIdsValues: Set of values defining the equivalence class. One value
      per quasi-identifier column in the original KAnonymity metric message.
      The order is always the same as the original request.
  """

  equivalenceClassSize = _messages.IntegerField(1)
  quasiIdsValues = _messages.MessageField('GooglePrivacyDlpV2Value', 2, repeated=True)


class GooglePrivacyDlpV2KAnonymityHistogramBucket(_messages.Message):
  r"""A GooglePrivacyDlpV2KAnonymityHistogramBucket object.

  Fields:
    bucketSize: Total number of equivalence classes in this bucket.
    bucketValueCount: Total number of distinct equivalence classes in this
      bucket.
    bucketValues: Sample of equivalence classes in this bucket. The total
      number of classes returned per bucket is capped at 20.
    equivalenceClassSizeLowerBound: Lower bound on the size of the equivalence
      classes in this bucket.
    equivalenceClassSizeUpperBound: Upper bound on the size of the equivalence
      classes in this bucket.
  """

  bucketSize = _messages.IntegerField(1)
  bucketValueCount = _messages.IntegerField(2)
  bucketValues = _messages.MessageField('GooglePrivacyDlpV2KAnonymityEquivalenceClass', 3, repeated=True)
  equivalenceClassSizeLowerBound = _messages.IntegerField(4)
  equivalenceClassSizeUpperBound = _messages.IntegerField(5)


class GooglePrivacyDlpV2KAnonymityResult(_messages.Message):
  r"""Result of the k-anonymity computation.

  Fields:
    equivalenceClassHistogramBuckets: Histogram of k-anonymity equivalence
      classes.
  """

  equivalenceClassHistogramBuckets = _messages.MessageField('GooglePrivacyDlpV2KAnonymityHistogramBucket', 1, repeated=True)


class GooglePrivacyDlpV2KMapEstimationConfig(_messages.Message):
  r"""Reidentifiability metric. This corresponds to a risk model similar to
  what is called "journalist risk" in the literature, except the attack
  dataset is statistically modeled instead of being perfectly known. This can
  be done using publicly available data (like the US Census), or using a
  custom statistical model (indicated as one or several BigQuery tables), or
  by extrapolating from the distribution of values in the input dataset. A
  column with a semantic tag attached.

  Fields:
    auxiliaryTables: Several auxiliary tables can be used in the analysis.
      Each custom_tag used to tag a quasi-identifiers column must appear in
      exactly one column of one auxiliary table.
    quasiIds: Fields considered to be quasi-identifiers. No two columns can
      have the same tag. [required]
    regionCode: ISO 3166-1 alpha-2 region code to use in the statistical
      modeling. Required if no column is tagged with a region-specific
      InfoType (like US_ZIP_5) or a region code.
  """

  auxiliaryTables = _messages.MessageField('GooglePrivacyDlpV2AuxiliaryTable', 1, repeated=True)
  quasiIds = _messages.MessageField('GooglePrivacyDlpV2TaggedField', 2, repeated=True)
  regionCode = _messages.StringField(3)


class GooglePrivacyDlpV2KMapEstimationHistogramBucket(_messages.Message):
  r"""A KMapEstimationHistogramBucket message with the following values:
  min_anonymity: 3   max_anonymity: 5   frequency: 42 means that there are 42
  records whose quasi-identifier values correspond to 3, 4 or 5 people in the
  overlying population. An important particular case is when min_anonymity =
  max_anonymity = 1: the frequency field then corresponds to the number of
  uniquely identifiable records.

  Fields:
    bucketSize: Number of records within these anonymity bounds.
    bucketValueCount: Total number of distinct quasi-identifier tuple values
      in this bucket.
    bucketValues: Sample of quasi-identifier tuple values in this bucket. The
      total number of classes returned per bucket is capped at 20.
    maxAnonymity: Always greater than or equal to min_anonymity.
    minAnonymity: Always positive.
  """

  bucketSize = _messages.IntegerField(1)
  bucketValueCount = _messages.IntegerField(2)
  bucketValues = _messages.MessageField('GooglePrivacyDlpV2KMapEstimationQuasiIdValues', 3, repeated=True)
  maxAnonymity = _messages.IntegerField(4)
  minAnonymity = _messages.IntegerField(5)


class GooglePrivacyDlpV2KMapEstimationQuasiIdValues(_messages.Message):
  r"""A tuple of values for the quasi-identifier columns.

  Fields:
    estimatedAnonymity: The estimated anonymity for these quasi-identifier
      values.
    quasiIdsValues: The quasi-identifier values.
  """

  estimatedAnonymity = _messages.IntegerField(1)
  quasiIdsValues = _messages.MessageField('GooglePrivacyDlpV2Value', 2, repeated=True)


class GooglePrivacyDlpV2KMapEstimationResult(_messages.Message):
  r"""Result of the reidentifiability analysis. Note that these results are an
  estimation, not exact values.

  Fields:
    kMapEstimationHistogram: The intervals [min_anonymity, max_anonymity] do
      not overlap. If a value doesn't correspond to any such interval, the
      associated frequency is zero. For example, the following records:
      {min_anonymity: 1, max_anonymity: 1, frequency: 17}   {min_anonymity: 2,
      max_anonymity: 3, frequency: 42}   {min_anonymity: 5, max_anonymity: 10,
      frequency: 99} mean that there are no record with an estimated anonymity
      of 4, 5, or larger than 10.
  """

  kMapEstimationHistogram = _messages.MessageField('GooglePrivacyDlpV2KMapEstimationHistogramBucket', 1, repeated=True)


class GooglePrivacyDlpV2Key(_messages.Message):
  r"""A unique identifier for a Datastore entity. If a key's partition ID or
  any of its path kinds or names are reserved/read-only, the key is reserved
  /read-only. A reserved/read-only key is forbidden in certain documented
  contexts.

  Fields:
    partitionId: Entities are partitioned into subsets, currently identified
      by a project ID and namespace ID. Queries are scoped to a single
      partition.
    path: The entity path. An entity path consists of one or more elements
      composed of a kind and a string or numerical identifier, which identify
      entities. The first element identifies a _root entity_, the second
      element identifies a _child_ of the root entity, the third element
      identifies a child of the second entity, and so forth. The entities
      identified by all prefixes of the path are called the element's
      _ancestors_.  A path can never be empty, and a path can have at most 100
      elements.
  """

  partitionId = _messages.MessageField('GooglePrivacyDlpV2PartitionId', 1)
  path = _messages.MessageField('GooglePrivacyDlpV2PathElement', 2, repeated=True)


class GooglePrivacyDlpV2KindExpression(_messages.Message):
  r"""A representation of a Datastore kind.

  Fields:
    name: The name of the kind.
  """

  name = _messages.StringField(1)


class GooglePrivacyDlpV2KmsWrappedCryptoKey(_messages.Message):
  r"""Include to use an existing data crypto key wrapped by KMS. Authorization
  requires the following IAM permissions when sending a request to perform a
  crypto transformation using a kms-wrapped crypto key: dlp.kms.encrypt

  Fields:
    cryptoKeyName: The resource name of the KMS CryptoKey to use for
      unwrapping. [required]
    wrappedKey: The wrapped data crypto key. [required]
  """

  cryptoKeyName = _messages.StringField(1)
  wrappedKey = _messages.BytesField(2)


class GooglePrivacyDlpV2LDiversityConfig(_messages.Message):
  r"""l-diversity metric, used for analysis of reidentification risk.

  Fields:
    quasiIds: Set of quasi-identifiers indicating how equivalence classes are
      defined for the l-diversity computation. When multiple fields are
      specified, they are considered a single composite key.
    sensitiveAttribute: Sensitive field for computing the l-value.
  """

  quasiIds = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1, repeated=True)
  sensitiveAttribute = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)


class GooglePrivacyDlpV2LDiversityEquivalenceClass(_messages.Message):
  r"""The set of columns' values that share the same ldiversity value.

  Fields:
    equivalenceClassSize: Size of the k-anonymity equivalence class.
    numDistinctSensitiveValues: Number of distinct sensitive values in this
      equivalence class.
    quasiIdsValues: Quasi-identifier values defining the k-anonymity
      equivalence class. The order is always the same as the original request.
    topSensitiveValues: Estimated frequencies of top sensitive values.
  """

  equivalenceClassSize = _messages.IntegerField(1)
  numDistinctSensitiveValues = _messages.IntegerField(2)
  quasiIdsValues = _messages.MessageField('GooglePrivacyDlpV2Value', 3, repeated=True)
  topSensitiveValues = _messages.MessageField('GooglePrivacyDlpV2ValueFrequency', 4, repeated=True)


class GooglePrivacyDlpV2LDiversityHistogramBucket(_messages.Message):
  r"""A GooglePrivacyDlpV2LDiversityHistogramBucket object.

  Fields:
    bucketSize: Total number of equivalence classes in this bucket.
    bucketValueCount: Total number of distinct equivalence classes in this
      bucket.
    bucketValues: Sample of equivalence classes in this bucket. The total
      number of classes returned per bucket is capped at 20.
    sensitiveValueFrequencyLowerBound: Lower bound on the sensitive value
      frequencies of the equivalence classes in this bucket.
    sensitiveValueFrequencyUpperBound: Upper bound on the sensitive value
      frequencies of the equivalence classes in this bucket.
  """

  bucketSize = _messages.IntegerField(1)
  bucketValueCount = _messages.IntegerField(2)
  bucketValues = _messages.MessageField('GooglePrivacyDlpV2LDiversityEquivalenceClass', 3, repeated=True)
  sensitiveValueFrequencyLowerBound = _messages.IntegerField(4)
  sensitiveValueFrequencyUpperBound = _messages.IntegerField(5)


class GooglePrivacyDlpV2LDiversityResult(_messages.Message):
  r"""Result of the l-diversity computation.

  Fields:
    sensitiveValueFrequencyHistogramBuckets: Histogram of l-diversity
      equivalence class sensitive value frequencies.
  """

  sensitiveValueFrequencyHistogramBuckets = _messages.MessageField('GooglePrivacyDlpV2LDiversityHistogramBucket', 1, repeated=True)


class GooglePrivacyDlpV2LargeCustomDictionaryConfig(_messages.Message):
  r"""Configuration for a custom dictionary created from a data source of any
  size up to the maximum size defined in the
  [limits](https://cloud.google.com/dlp/limits) page. The artifacts of
  dictionary creation are stored in the specified Google Cloud Storage
  location. Consider using `CustomInfoType.Dictionary` for smaller
  dictionaries that satisfy the size requirements.

  Fields:
    bigQueryField: Field in a BigQuery table where each cell represents a
      dictionary phrase.
    cloudStorageFileSet: Set of files containing newline-delimited lists of
      dictionary phrases.
    outputPath: Location to store dictionary artifacts in Google Cloud
      Storage. These files will only be accessible by project owners and the
      DLP API. If any of these artifacts are modified, the dictionary is
      considered invalid and can no longer be used.
  """

  bigQueryField = _messages.MessageField('GooglePrivacyDlpV2BigQueryField', 1)
  cloudStorageFileSet = _messages.MessageField('GooglePrivacyDlpV2CloudStorageFileSet', 2)
  outputPath = _messages.MessageField('GooglePrivacyDlpV2CloudStoragePath', 3)


class GooglePrivacyDlpV2LikelihoodAdjustment(_messages.Message):
  r"""Message for specifying an adjustment to the likelihood of a finding as
  part of a detection rule.

  Enums:
    FixedLikelihoodValueValuesEnum: Set the likelihood of a finding to a fixed
      value.

  Fields:
    fixedLikelihood: Set the likelihood of a finding to a fixed value.
    relativeLikelihood: Increase or decrease the likelihood by the specified
      number of levels. For example, if a finding would be `POSSIBLE` without
      the detection rule and `relative_likelihood` is 1, then it is upgraded
      to `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
      Likelihood may never drop below `VERY_UNLIKELY` or exceed `VERY_LIKELY`,
      so applying an adjustment of 1 followed by an adjustment of -1 when base
      likelihood is `VERY_LIKELY` will result in a final likelihood of
      `LIKELY`.
  """

  class FixedLikelihoodValueValuesEnum(_messages.Enum):
    r"""Set the likelihood of a finding to a fixed value.

    Values:
      LIKELIHOOD_UNSPECIFIED: Default value; same as POSSIBLE.
      VERY_UNLIKELY: Few matching elements.
      UNLIKELY: <no description>
      POSSIBLE: Some matching elements.
      LIKELY: <no description>
      VERY_LIKELY: Many matching elements.
    """
    LIKELIHOOD_UNSPECIFIED = 0
    VERY_UNLIKELY = 1
    UNLIKELY = 2
    POSSIBLE = 3
    LIKELY = 4
    VERY_LIKELY = 5

  fixedLikelihood = _messages.EnumField('FixedLikelihoodValueValuesEnum', 1)
  relativeLikelihood = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2ListDeidentifyTemplatesResponse(_messages.Message):
  r"""Response message for ListDeidentifyTemplates.

  Fields:
    deidentifyTemplates: List of deidentify templates, up to page_size in
      ListDeidentifyTemplatesRequest.
    nextPageToken: If the next page is available then the next page token to
      be used in following ListDeidentifyTemplates request.
  """

  deidentifyTemplates = _messages.MessageField('GooglePrivacyDlpV2DeidentifyTemplate', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GooglePrivacyDlpV2ListDlpJobsResponse(_messages.Message):
  r"""The response message for listing DLP jobs.

  Fields:
    jobs: A list of DlpJobs that matches the specified filter in the request.
    nextPageToken: The standard List next-page token.
  """

  jobs = _messages.MessageField('GooglePrivacyDlpV2DlpJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GooglePrivacyDlpV2ListInfoTypesResponse(_messages.Message):
  r"""Response to the ListInfoTypes request.

  Fields:
    infoTypes: Set of sensitive infoTypes.
  """

  infoTypes = _messages.MessageField('GooglePrivacyDlpV2InfoTypeDescription', 1, repeated=True)


class GooglePrivacyDlpV2ListInspectTemplatesResponse(_messages.Message):
  r"""Response message for ListInspectTemplates.

  Fields:
    inspectTemplates: List of inspectTemplates, up to page_size in
      ListInspectTemplatesRequest.
    nextPageToken: If the next page is available then the next page token to
      be used in following ListInspectTemplates request.
  """

  inspectTemplates = _messages.MessageField('GooglePrivacyDlpV2InspectTemplate', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GooglePrivacyDlpV2ListJobTriggersResponse(_messages.Message):
  r"""Response message for ListJobTriggers.

  Fields:
    jobTriggers: List of triggeredJobs, up to page_size in
      ListJobTriggersRequest.
    nextPageToken: If the next page is available then the next page token to
      be used in following ListJobTriggers request.
  """

  jobTriggers = _messages.MessageField('GooglePrivacyDlpV2JobTrigger', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GooglePrivacyDlpV2ListStoredInfoTypesResponse(_messages.Message):
  r"""Response message for ListStoredInfoTypes.

  Fields:
    nextPageToken: If the next page is available then the next page token to
      be used in following ListStoredInfoTypes request.
    storedInfoTypes: List of storedInfoTypes, up to page_size in
      ListStoredInfoTypesRequest.
  """

  nextPageToken = _messages.StringField(1)
  storedInfoTypes = _messages.MessageField('GooglePrivacyDlpV2StoredInfoType', 2, repeated=True)


class GooglePrivacyDlpV2Location(_messages.Message):
  r"""Specifies the location of the finding.

  Fields:
    byteRange: Zero-based byte offsets delimiting the finding. These are
      relative to the finding's containing element. Note that when the content
      is not textual, this references the UTF-8 encoded textual representation
      of the content. Omitted if content is an image.
    codepointRange: Unicode character offsets delimiting the finding. These
      are relative to the finding's containing element. Provided when the
      content is text.
    contentLocations: List of nested objects pointing to the precise location
      of the finding within the file or record.
  """

  byteRange = _messages.MessageField('GooglePrivacyDlpV2Range', 1)
  codepointRange = _messages.MessageField('GooglePrivacyDlpV2Range', 2)
  contentLocations = _messages.MessageField('GooglePrivacyDlpV2ContentLocation', 3, repeated=True)


class GooglePrivacyDlpV2NumericalStatsConfig(_messages.Message):
  r"""Compute numerical stats over an individual column, including min, max,
  and quantiles.

  Fields:
    field: Field to compute numerical stats on. Supported types are integer,
      float, date, datetime, timestamp, time.
  """

  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)


class GooglePrivacyDlpV2NumericalStatsResult(_messages.Message):
  r"""Result of the numerical stats computation.

  Fields:
    maxValue: Maximum value appearing in the column.
    minValue: Minimum value appearing in the column.
    quantileValues: List of 99 values that partition the set of field values
      into 100 equal sized buckets.
  """

  maxValue = _messages.MessageField('GooglePrivacyDlpV2Value', 1)
  minValue = _messages.MessageField('GooglePrivacyDlpV2Value', 2)
  quantileValues = _messages.MessageField('GooglePrivacyDlpV2Value', 3, repeated=True)


class GooglePrivacyDlpV2OutputStorageConfig(_messages.Message):
  r"""Cloud repository for storing output.

  Enums:
    OutputSchemaValueValuesEnum: Schema used for writing the findings for
      Inspect jobs. This field is only used for Inspect and must be
      unspecified for Risk jobs. Columns are derived from the `Finding`
      object. If appending to an existing table, any columns from the
      predefined schema that are missing will be added. No columns in the
      existing table will be deleted.  If unspecified, then all available
      columns will be used for a new table, and no changes will be made to an
      existing table.

  Fields:
    outputSchema: Schema used for writing the findings for Inspect jobs. This
      field is only used for Inspect and must be unspecified for Risk jobs.
      Columns are derived from the `Finding` object. If appending to an
      existing table, any columns from the predefined schema that are missing
      will be added. No columns in the existing table will be deleted.  If
      unspecified, then all available columns will be used for a new table,
      and no changes will be made to an existing table.
    table: Store findings in an existing table or a new table in an existing
      dataset. If table_id is not set a new one will be generated for you with
      the following format: dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific
      timezone will be used for generating the date details.  For Inspect,
      each column in an existing output table must have the same name, type,
      and mode of a field in the `Finding` object.  For Risk, an existing
      output table should be the output of a previous Risk analysis job run on
      the same source table, with the same privacy metric and quasi-
      identifiers. Risk jobs that analyze the same table but compute a
      different privacy metric, or use different sets of quasi-identifiers,
      cannot store their results in the same table.
  """

  class OutputSchemaValueValuesEnum(_messages.Enum):
    r"""Schema used for writing the findings for Inspect jobs. This field is
    only used for Inspect and must be unspecified for Risk jobs. Columns are
    derived from the `Finding` object. If appending to an existing table, any
    columns from the predefined schema that are missing will be added. No
    columns in the existing table will be deleted.  If unspecified, then all
    available columns will be used for a new table, and no changes will be
    made to an existing table.

    Values:
      OUTPUT_SCHEMA_UNSPECIFIED: <no description>
      BASIC_COLUMNS: Basic schema including only `info_type`, `quote`,
        `certainty`, and `timestamp`.
      GCS_COLUMNS: Schema tailored to findings from scanning Google Cloud
        Storage.
      DATASTORE_COLUMNS: Schema tailored to findings from scanning Google
        Datastore.
      BIG_QUERY_COLUMNS: Schema tailored to findings from scanning Google
        BigQuery.
      ALL_COLUMNS: Schema containing all columns.
    """
    OUTPUT_SCHEMA_UNSPECIFIED = 0
    BASIC_COLUMNS = 1
    GCS_COLUMNS = 2
    DATASTORE_COLUMNS = 3
    BIG_QUERY_COLUMNS = 4
    ALL_COLUMNS = 5

  outputSchema = _messages.EnumField('OutputSchemaValueValuesEnum', 1)
  table = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 2)


class GooglePrivacyDlpV2PartitionId(_messages.Message):
  r"""Datastore partition ID. A partition ID identifies a grouping of
  entities. The grouping is always by project and namespace, however the
  namespace ID may be empty.  A partition ID contains several dimensions:
  project ID and namespace ID.

  Fields:
    namespaceId: If not empty, the ID of the namespace to which the entities
      belong.
    projectId: The ID of the project to which the entities belong.
  """

  namespaceId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class GooglePrivacyDlpV2PathElement(_messages.Message):
  r"""A (kind, ID/name) pair used to construct a key path.  If either name or
  ID is set, the element is complete. If neither is set, the element is
  incomplete.

  Fields:
    id: The auto-allocated ID of the entity. Never equal to zero. Values less
      than zero are discouraged and may not be supported in the future.
    kind: The kind of the entity. A kind matching regex `__.*__` is reserved
      /read-only. A kind must not contain more than 1500 bytes when UTF-8
      encoded. Cannot be `""`.
    name: The name of the entity. A name matching regex `__.*__` is reserved
      /read-only. A name must not be more than 1500 bytes when UTF-8 encoded.
      Cannot be `""`.
  """

  id = _messages.IntegerField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)


class GooglePrivacyDlpV2PrimitiveTransformation(_messages.Message):
  r"""A rule for transforming a value.

  Fields:
    bucketingConfig: A GooglePrivacyDlpV2BucketingConfig attribute.
    characterMaskConfig: A GooglePrivacyDlpV2CharacterMaskConfig attribute.
    cryptoHashConfig: A GooglePrivacyDlpV2CryptoHashConfig attribute.
    cryptoReplaceFfxFpeConfig: A GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig
      attribute.
    dateShiftConfig: A GooglePrivacyDlpV2DateShiftConfig attribute.
    fixedSizeBucketingConfig: A GooglePrivacyDlpV2FixedSizeBucketingConfig
      attribute.
    redactConfig: A GooglePrivacyDlpV2RedactConfig attribute.
    replaceConfig: A GooglePrivacyDlpV2ReplaceValueConfig attribute.
    replaceWithInfoTypeConfig: A GooglePrivacyDlpV2ReplaceWithInfoTypeConfig
      attribute.
    timePartConfig: A GooglePrivacyDlpV2TimePartConfig attribute.
  """

  bucketingConfig = _messages.MessageField('GooglePrivacyDlpV2BucketingConfig', 1)
  characterMaskConfig = _messages.MessageField('GooglePrivacyDlpV2CharacterMaskConfig', 2)
  cryptoHashConfig = _messages.MessageField('GooglePrivacyDlpV2CryptoHashConfig', 3)
  cryptoReplaceFfxFpeConfig = _messages.MessageField('GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig', 4)
  dateShiftConfig = _messages.MessageField('GooglePrivacyDlpV2DateShiftConfig', 5)
  fixedSizeBucketingConfig = _messages.MessageField('GooglePrivacyDlpV2FixedSizeBucketingConfig', 6)
  redactConfig = _messages.MessageField('GooglePrivacyDlpV2RedactConfig', 7)
  replaceConfig = _messages.MessageField('GooglePrivacyDlpV2ReplaceValueConfig', 8)
  replaceWithInfoTypeConfig = _messages.MessageField('GooglePrivacyDlpV2ReplaceWithInfoTypeConfig', 9)
  timePartConfig = _messages.MessageField('GooglePrivacyDlpV2TimePartConfig', 10)


class GooglePrivacyDlpV2PrivacyMetric(_messages.Message):
  r"""Privacy metric to compute for reidentification risk analysis.

  Fields:
    categoricalStatsConfig: A GooglePrivacyDlpV2CategoricalStatsConfig
      attribute.
    deltaPresenceEstimationConfig: A
      GooglePrivacyDlpV2DeltaPresenceEstimationConfig attribute.
    kAnonymityConfig: A GooglePrivacyDlpV2KAnonymityConfig attribute.
    kMapEstimationConfig: A GooglePrivacyDlpV2KMapEstimationConfig attribute.
    lDiversityConfig: A GooglePrivacyDlpV2LDiversityConfig attribute.
    numericalStatsConfig: A GooglePrivacyDlpV2NumericalStatsConfig attribute.
  """

  categoricalStatsConfig = _messages.MessageField('GooglePrivacyDlpV2CategoricalStatsConfig', 1)
  deltaPresenceEstimationConfig = _messages.MessageField('GooglePrivacyDlpV2DeltaPresenceEstimationConfig', 2)
  kAnonymityConfig = _messages.MessageField('GooglePrivacyDlpV2KAnonymityConfig', 3)
  kMapEstimationConfig = _messages.MessageField('GooglePrivacyDlpV2KMapEstimationConfig', 4)
  lDiversityConfig = _messages.MessageField('GooglePrivacyDlpV2LDiversityConfig', 5)
  numericalStatsConfig = _messages.MessageField('GooglePrivacyDlpV2NumericalStatsConfig', 6)


class GooglePrivacyDlpV2Proximity(_messages.Message):
  r"""Message for specifying a window around a finding to apply a detection
  rule.

  Fields:
    windowAfter: Number of characters after the finding to consider.
    windowBefore: Number of characters before the finding to consider.
  """

  windowAfter = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  windowBefore = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2PublishSummaryToCscc(_messages.Message):
  r"""Publish the result summary of a DlpJob to the Cloud Security Command
  Center (CSCC Alpha). This action is only available for projects which are
  parts of an organization and whitelisted for the alpha Cloud Security
  Command Center. The action will publish count of finding instances and their
  info types. The summary of findings will be persisted in CSCC and are
  governed by CSCC service-specific policy, see https://cloud.google.com/terms
  /service-terms Only a single instance of this action can be specified.
  Compatible with: Inspect
  """



class GooglePrivacyDlpV2PublishToPubSub(_messages.Message):
  r"""Publish the results of a DlpJob to a pub sub channel. Compatible with:
  Inspect, Risk

  Fields:
    topic: Cloud Pub/Sub topic to send notifications to. The topic must have
      given publishing access rights to the DLP API service account executing
      the long running DlpJob sending the notifications. Format is
      projects/{project}/topics/{topic}.
  """

  topic = _messages.StringField(1)


class GooglePrivacyDlpV2QuasiId(_messages.Message):
  r"""A column with a semantic tag attached.

  Fields:
    customTag: A column can be tagged with a custom tag. In this case, the
      user must indicate an auxiliary table that contains statistical
      information on the possible values of this column (below).
    field: Identifies the column. [required]
    inferred: If no semantic tag is indicated, we infer the statistical model
      from the distribution of values in the input data
    infoType: A column can be tagged with a InfoType to use the relevant
      public dataset as a statistical model of population, if available. We
      currently support US ZIP codes, region codes, ages and genders. To
      programmatically obtain the list of supported InfoTypes, use
      ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
  """

  customTag = _messages.StringField(1)
  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)
  inferred = _messages.MessageField('GoogleProtobufEmpty', 3)
  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 4)


class GooglePrivacyDlpV2QuasiIdField(_messages.Message):
  r"""A quasi-identifier column has a custom_tag, used to know which column in
  the data corresponds to which column in the statistical model.

  Fields:
    customTag: A string attribute.
    field: A GooglePrivacyDlpV2FieldId attribute.
  """

  customTag = _messages.StringField(1)
  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)


class GooglePrivacyDlpV2QuasiIdentifierField(_messages.Message):
  r"""A quasi-identifier column has a custom_tag, used to know which column in
  the data corresponds to which column in the statistical model.

  Fields:
    customTag: A string attribute.
    field: A GooglePrivacyDlpV2FieldId attribute.
  """

  customTag = _messages.StringField(1)
  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)


class GooglePrivacyDlpV2QuoteInfo(_messages.Message):
  r"""Message for infoType-dependent details parsed from quote.

  Fields:
    dateTime: A GooglePrivacyDlpV2DateTime attribute.
  """

  dateTime = _messages.MessageField('GooglePrivacyDlpV2DateTime', 1)


class GooglePrivacyDlpV2Range(_messages.Message):
  r"""Generic half-open interval [start, end)

  Fields:
    end: Index of the last character of the range (exclusive).
    start: Index of the first character of the range (inclusive).
  """

  end = _messages.IntegerField(1)
  start = _messages.IntegerField(2)


class GooglePrivacyDlpV2RecordCondition(_messages.Message):
  r"""A condition for determining whether a transformation should be applied
  to a field.

  Fields:
    expressions: An expression.
  """

  expressions = _messages.MessageField('GooglePrivacyDlpV2Expressions', 1)


class GooglePrivacyDlpV2RecordKey(_messages.Message):
  r"""Message for a unique key indicating a record that contains a finding.

  Fields:
    bigQueryKey: A GooglePrivacyDlpV2BigQueryKey attribute.
    datastoreKey: A GooglePrivacyDlpV2DatastoreKey attribute.
  """

  bigQueryKey = _messages.MessageField('GooglePrivacyDlpV2BigQueryKey', 1)
  datastoreKey = _messages.MessageField('GooglePrivacyDlpV2DatastoreKey', 2)


class GooglePrivacyDlpV2RecordLocation(_messages.Message):
  r"""Location of a finding within a row or record.

  Fields:
    fieldId: Field id of the field containing the finding.
    recordKey: Key of the finding.
    tableLocation: Location within a `ContentItem.Table`.
  """

  fieldId = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)
  recordKey = _messages.MessageField('GooglePrivacyDlpV2RecordKey', 2)
  tableLocation = _messages.MessageField('GooglePrivacyDlpV2TableLocation', 3)


class GooglePrivacyDlpV2RecordSuppression(_messages.Message):
  r"""Configuration to suppress records whose suppression conditions evaluate
  to true.

  Fields:
    condition: A condition that when it evaluates to true will result in the
      record being evaluated to be suppressed from the transformed content.
  """

  condition = _messages.MessageField('GooglePrivacyDlpV2RecordCondition', 1)


class GooglePrivacyDlpV2RecordTransformations(_messages.Message):
  r"""A type of transformation that is applied over structured data such as a
  table.

  Fields:
    fieldTransformations: Transform the record by applying various field
      transformations.
    recordSuppressions: Configuration defining which records get suppressed
      entirely. Records that match any suppression rule are omitted from the
      output [optional].
  """

  fieldTransformations = _messages.MessageField('GooglePrivacyDlpV2FieldTransformation', 1, repeated=True)
  recordSuppressions = _messages.MessageField('GooglePrivacyDlpV2RecordSuppression', 2, repeated=True)


class GooglePrivacyDlpV2RedactConfig(_messages.Message):
  r"""Redact a given value. For example, if used with an
  `InfoTypeTransformation` transforming PHONE_NUMBER, and input 'My phone
  number is 206-555-0123', the output would be 'My phone number is '.
  """



class GooglePrivacyDlpV2RedactImageRequest(_messages.Message):
  r"""Request to search for potentially sensitive info in an image and redact
  it by covering it with a colored rectangle.

  Fields:
    byteItem: The content must be PNG, JPEG, SVG or BMP.
    imageRedactionConfigs: The configuration for specifying what content to
      redact from images.
    includeFindings: Whether the response should include findings along with
      the redacted image.
    inspectConfig: Configuration for the inspector.
  """

  byteItem = _messages.MessageField('GooglePrivacyDlpV2ByteContentItem', 1)
  imageRedactionConfigs = _messages.MessageField('GooglePrivacyDlpV2ImageRedactionConfig', 2, repeated=True)
  includeFindings = _messages.BooleanField(3)
  inspectConfig = _messages.MessageField('GooglePrivacyDlpV2InspectConfig', 4)


class GooglePrivacyDlpV2RedactImageResponse(_messages.Message):
  r"""Results of redacting an image.

  Fields:
    extractedText: If an image was being inspected and the InspectConfig's
      include_quote was set to true, then this field will include all text, if
      any, that was found in the image.
    inspectResult: The findings. Populated when include_findings in the
      request is true.
    redactedImage: The redacted image. The type will be the same as the
      original image.
  """

  extractedText = _messages.StringField(1)
  inspectResult = _messages.MessageField('GooglePrivacyDlpV2InspectResult', 2)
  redactedImage = _messages.BytesField(3)


class GooglePrivacyDlpV2Regex(_messages.Message):
  r"""Message defining a custom regular expression.

  Fields:
    pattern: Pattern defining the regular expression. Its syntax
      (https://github.com/google/re2/wiki/Syntax) can be found under the
      google/re2 repository on GitHub.
  """

  pattern = _messages.StringField(1)


class GooglePrivacyDlpV2ReidentifyContentRequest(_messages.Message):
  r"""Request to re-identify an item.

  Fields:
    inspectConfig: Configuration for the inspector.
    inspectTemplateName: Optional template to use. Any configuration directly
      specified in `inspect_config` will override those set in the template.
      Singular fields that are set in this request will replace their
      corresponding fields in the template. Repeated fields are appended.
      Singular sub-messages and groups are recursively merged.
    item: The item to re-identify. Will be treated as text.
    reidentifyConfig: Configuration for the re-identification of the content
      item. This field shares the same proto message type that is used for de-
      identification, however its usage here is for the reversal of the
      previous de-identification. Re-identification is performed by examining
      the transformations used to de-identify the items and executing the
      reverse. This requires that only reversible transformations be provided
      here. The reversible transformations are:   -
      `CryptoReplaceFfxFpeConfig`
    reidentifyTemplateName: Optional template to use. References an instance
      of `DeidentifyTemplate`. Any configuration directly specified in
      `reidentify_config` or `inspect_config` will override those set in the
      template. Singular fields that are set in this request will replace
      their corresponding fields in the template. Repeated fields are
      appended. Singular sub-messages and groups are recursively merged.
  """

  inspectConfig = _messages.MessageField('GooglePrivacyDlpV2InspectConfig', 1)
  inspectTemplateName = _messages.StringField(2)
  item = _messages.MessageField('GooglePrivacyDlpV2ContentItem', 3)
  reidentifyConfig = _messages.MessageField('GooglePrivacyDlpV2DeidentifyConfig', 4)
  reidentifyTemplateName = _messages.StringField(5)


class GooglePrivacyDlpV2ReidentifyContentResponse(_messages.Message):
  r"""Results of re-identifying a item.

  Fields:
    item: The re-identified item.
    overview: An overview of the changes that were made to the `item`.
  """

  item = _messages.MessageField('GooglePrivacyDlpV2ContentItem', 1)
  overview = _messages.MessageField('GooglePrivacyDlpV2TransformationOverview', 2)


class GooglePrivacyDlpV2ReplaceValueConfig(_messages.Message):
  r"""Replace each input value with a given `Value`.

  Fields:
    newValue: Value to replace it with.
  """

  newValue = _messages.MessageField('GooglePrivacyDlpV2Value', 1)


class GooglePrivacyDlpV2ReplaceWithInfoTypeConfig(_messages.Message):
  r"""Replace each matching finding with the name of the info_type."""


class GooglePrivacyDlpV2RequestedOptions(_messages.Message):
  r"""A GooglePrivacyDlpV2RequestedOptions object.

  Fields:
    jobConfig: A GooglePrivacyDlpV2InspectJobConfig attribute.
    snapshotInspectTemplate: If run with an InspectTemplate, a snapshot of its
      state at the time of this run.
  """

  jobConfig = _messages.MessageField('GooglePrivacyDlpV2InspectJobConfig', 1)
  snapshotInspectTemplate = _messages.MessageField('GooglePrivacyDlpV2InspectTemplate', 2)


class GooglePrivacyDlpV2Result(_messages.Message):
  r"""A GooglePrivacyDlpV2Result object.

  Fields:
    infoTypeStats: Statistics of how many instances of each info type were
      found during inspect job.
    processedBytes: Total size in bytes that were processed.
    totalEstimatedBytes: Estimate of the number of bytes to process.
  """

  infoTypeStats = _messages.MessageField('GooglePrivacyDlpV2InfoTypeStats', 1, repeated=True)
  processedBytes = _messages.IntegerField(2)
  totalEstimatedBytes = _messages.IntegerField(3)


class GooglePrivacyDlpV2RiskAnalysisJobConfig(_messages.Message):
  r"""Configuration for a risk analysis job. See
  https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.

  Fields:
    actions: Actions to execute at the completion of the job. Are executed in
      the order provided.
    privacyMetric: Privacy metric to compute.
    sourceTable: Input dataset to compute metrics over.
  """

  actions = _messages.MessageField('GooglePrivacyDlpV2Action', 1, repeated=True)
  privacyMetric = _messages.MessageField('GooglePrivacyDlpV2PrivacyMetric', 2)
  sourceTable = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 3)


class GooglePrivacyDlpV2Row(_messages.Message):
  r"""A GooglePrivacyDlpV2Row object.

  Fields:
    values: A GooglePrivacyDlpV2Value attribute.
  """

  values = _messages.MessageField('GooglePrivacyDlpV2Value', 1, repeated=True)


class GooglePrivacyDlpV2SaveFindings(_messages.Message):
  r"""If set, the detailed findings will be persisted to the specified
  OutputStorageConfig. Only a single instance of this action can be specified.
  Compatible with: Inspect, Risk

  Fields:
    outputConfig: A GooglePrivacyDlpV2OutputStorageConfig attribute.
  """

  outputConfig = _messages.MessageField('GooglePrivacyDlpV2OutputStorageConfig', 1)


class GooglePrivacyDlpV2Schedule(_messages.Message):
  r"""Schedule for triggeredJobs.

  Fields:
    recurrencePeriodDuration: With this option a job is started a regular
      periodic basis. For example: every day (86400 seconds).  A scheduled
      start time will be skipped if the previous execution has not ended when
      its scheduled time occurs.  This value must be set to a time duration
      greater than or equal to 1 day and can be no longer than 60 days.
  """

  recurrencePeriodDuration = _messages.StringField(1)


class GooglePrivacyDlpV2StatisticalTable(_messages.Message):
  r"""An auxiliary table containing statistical information on the relative
  frequency of different quasi-identifiers values. It has one or several
  quasi-identifiers columns, and one column that indicates the relative
  frequency of each quasi-identifier tuple. If a tuple is present in the data
  but not in the auxiliary table, the corresponding relative frequency is
  assumed to be zero (and thus, the tuple is highly reidentifiable).

  Fields:
    quasiIds: Quasi-identifier columns. [required]
    relativeFrequency: The relative frequency column must contain a floating-
      point number between 0 and 1 (inclusive). Null values are assumed to be
      zero. [required]
    table: Auxiliary table location. [required]
  """

  quasiIds = _messages.MessageField('GooglePrivacyDlpV2QuasiIdentifierField', 1, repeated=True)
  relativeFrequency = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)
  table = _messages.MessageField('GooglePrivacyDlpV2BigQueryTable', 3)


class GooglePrivacyDlpV2StorageConfig(_messages.Message):
  r"""Shared message indicating Cloud storage type.

  Fields:
    bigQueryOptions: BigQuery options specification.
    cloudStorageOptions: Google Cloud Storage options specification.
    datastoreOptions: Google Cloud Datastore options specification.
    timespanConfig: A GooglePrivacyDlpV2TimespanConfig attribute.
  """

  bigQueryOptions = _messages.MessageField('GooglePrivacyDlpV2BigQueryOptions', 1)
  cloudStorageOptions = _messages.MessageField('GooglePrivacyDlpV2CloudStorageOptions', 2)
  datastoreOptions = _messages.MessageField('GooglePrivacyDlpV2DatastoreOptions', 3)
  timespanConfig = _messages.MessageField('GooglePrivacyDlpV2TimespanConfig', 4)


class GooglePrivacyDlpV2StoredInfoType(_messages.Message):
  r"""StoredInfoType resource message that contains information about the
  current version and any pending updates.

  Fields:
    currentVersion: Current version of the stored info type.
    name: Resource name.
    pendingVersions: Pending versions of the stored info type. Empty if no
      versions are pending.
  """

  currentVersion = _messages.MessageField('GooglePrivacyDlpV2StoredInfoTypeVersion', 1)
  name = _messages.StringField(2)
  pendingVersions = _messages.MessageField('GooglePrivacyDlpV2StoredInfoTypeVersion', 3, repeated=True)


class GooglePrivacyDlpV2StoredInfoTypeConfig(_messages.Message):
  r"""Configuration for a StoredInfoType.

  Fields:
    description: Description of the StoredInfoType (max 256 characters).
    displayName: Display name of the StoredInfoType (max 256 characters).
    largeCustomDictionary: StoredInfoType where findings are defined by a
      dictionary of phrases.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  largeCustomDictionary = _messages.MessageField('GooglePrivacyDlpV2LargeCustomDictionaryConfig', 3)


class GooglePrivacyDlpV2StoredInfoTypeVersion(_messages.Message):
  r"""Version of a StoredInfoType, including the configuration used to build
  it, create timestamp, and current state.

  Enums:
    StateValueValuesEnum: Stored info type version state. Read-only, updated
      by the system during dictionary creation.

  Fields:
    config: StoredInfoType configuration.
    createTime: Create timestamp of the version. Read-only, determined by the
      system when the version is created.
    errors: Errors that occurred when creating this storedInfoType version, or
      anomalies detected in the storedInfoType data that render it unusable.
      Only the five most recent errors will be displayed, with the most recent
      error appearing first. <p>For example, some of the data for stored
      custom dictionaries is put in the user's Google Cloud Storage bucket,
      and if this data is modified or deleted by the user or another system,
      the dictionary becomes invalid. <p>If any errors occur, fix the problem
      indicated by the error message and use the UpdateStoredInfoType API
      method to create another version of the storedInfoType to continue using
      it, reusing the same `config` if it was not the source of the error.
    state: Stored info type version state. Read-only, updated by the system
      during dictionary creation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Stored info type version state. Read-only, updated by the system
    during dictionary creation.

    Values:
      STORED_INFO_TYPE_STATE_UNSPECIFIED: <no description>
      PENDING: StoredInfoType version is being created.
      READY: StoredInfoType version is ready for use.
      FAILED: StoredInfoType creation failed. All relevant error messages are
        returned in the `StoredInfoTypeVersion` message.
      INVALID: StoredInfoType is no longer valid because artifacts stored in
        user-controlled storage were modified. To fix an invalid
        StoredInfoType, use the `UpdateStoredInfoType` method to create a new
        version.
    """
    STORED_INFO_TYPE_STATE_UNSPECIFIED = 0
    PENDING = 1
    READY = 2
    FAILED = 3
    INVALID = 4

  config = _messages.MessageField('GooglePrivacyDlpV2StoredInfoTypeConfig', 1)
  createTime = _messages.StringField(2)
  errors = _messages.MessageField('GooglePrivacyDlpV2Error', 3, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class GooglePrivacyDlpV2StoredType(_messages.Message):
  r"""A reference to a StoredInfoType to use with scanning.

  Fields:
    createTime: Timestamp indicating when the version of the `StoredInfoType`
      used for inspection was created. Output-only field, populated by the
      system.
    name: Resource name of the requested `StoredInfoType`, for example
      `organizations/433245324/storedInfoTypes/432452342` or `projects
      /project-id/storedInfoTypes/432452342`.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)


class GooglePrivacyDlpV2SummaryResult(_messages.Message):
  r"""A collection that informs the user the number of times a particular
  `TransformationResultCode` and error details occurred.

  Enums:
    CodeValueValuesEnum:

  Fields:
    code: A CodeValueValuesEnum attribute.
    count: A string attribute.
    details: A place for warnings or errors to show up if a transformation
      didn't work as expected.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""CodeValueValuesEnum enum type.

    Values:
      TRANSFORMATION_RESULT_CODE_UNSPECIFIED: <no description>
      SUCCESS: <no description>
      ERROR: <no description>
    """
    TRANSFORMATION_RESULT_CODE_UNSPECIFIED = 0
    SUCCESS = 1
    ERROR = 2

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  count = _messages.IntegerField(2)
  details = _messages.StringField(3)


class GooglePrivacyDlpV2SurrogateType(_messages.Message):
  r"""Message for detecting output from deidentification transformations such
  as [`CryptoReplaceFfxFpeConfig`](/dlp/docs/reference/rest/v2/organizations.d
  eidentifyTemplates#cryptoreplaceffxfpeconfig). These types of
  transformations are those that perform pseudonymization, thereby producing a
  "surrogate" as output. This should be used in conjunction with a field on
  the transformation such as `surrogate_info_type`. This CustomInfoType does
  not support the use of `detection_rules`.
  """



class GooglePrivacyDlpV2Table(_messages.Message):
  r"""Structured content to inspect. Up to 50,000 `Value`s per request
  allowed. See https://cloud.google.com/dlp/docs/inspecting-
  text#inspecting_a_table to learn more.

  Fields:
    headers: A GooglePrivacyDlpV2FieldId attribute.
    rows: A GooglePrivacyDlpV2Row attribute.
  """

  headers = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1, repeated=True)
  rows = _messages.MessageField('GooglePrivacyDlpV2Row', 2, repeated=True)


class GooglePrivacyDlpV2TableLocation(_messages.Message):
  r"""Location of a finding within a table.

  Fields:
    rowIndex: The zero-based index of the row where the finding is located.
  """

  rowIndex = _messages.IntegerField(1)


class GooglePrivacyDlpV2TaggedField(_messages.Message):
  r"""A GooglePrivacyDlpV2TaggedField object.

  Fields:
    customTag: A column can be tagged with a custom tag. In this case, the
      user must indicate an auxiliary table that contains statistical
      information on the possible values of this column (below).
    field: Identifies the column. [required]
    inferred: If no semantic tag is indicated, we infer the statistical model
      from the distribution of values in the input data
    infoType: A column can be tagged with a InfoType to use the relevant
      public dataset as a statistical model of population, if available. We
      currently support US ZIP codes, region codes, ages and genders. To
      programmatically obtain the list of supported InfoTypes, use
      ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
  """

  customTag = _messages.StringField(1)
  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 2)
  inferred = _messages.MessageField('GoogleProtobufEmpty', 3)
  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 4)


class GooglePrivacyDlpV2TimePartConfig(_messages.Message):
  r"""For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a
  portion of the value.

  Enums:
    PartToExtractValueValuesEnum:

  Fields:
    partToExtract: A PartToExtractValueValuesEnum attribute.
  """

  class PartToExtractValueValuesEnum(_messages.Enum):
    r"""PartToExtractValueValuesEnum enum type.

    Values:
      TIME_PART_UNSPECIFIED: <no description>
      YEAR: [0-9999]
      MONTH: [1-12]
      DAY_OF_MONTH: [1-31]
      DAY_OF_WEEK: [1-7]
      WEEK_OF_YEAR: [1-52]
      HOUR_OF_DAY: [0-23]
    """
    TIME_PART_UNSPECIFIED = 0
    YEAR = 1
    MONTH = 2
    DAY_OF_MONTH = 3
    DAY_OF_WEEK = 4
    WEEK_OF_YEAR = 5
    HOUR_OF_DAY = 6

  partToExtract = _messages.EnumField('PartToExtractValueValuesEnum', 1)


class GooglePrivacyDlpV2TimeZone(_messages.Message):
  r"""A GooglePrivacyDlpV2TimeZone object.

  Fields:
    offsetMinutes: Set only if the offset can be determined. Positive for time
      ahead of UTC. E.g. For "UTC-9", this value is -540.
  """

  offsetMinutes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GooglePrivacyDlpV2TimespanConfig(_messages.Message):
  r"""Configuration of the timespan of the items to include in scanning.
  Currently only supported when inspecting Google Cloud Storage and BigQuery.

  Fields:
    enableAutoPopulationOfTimespanConfig: When the job is started by a
      JobTrigger we will automatically figure out a valid start_time to avoid
      scanning files that have not been modified since the last time the
      JobTrigger executed. This will be based on the time of the execution of
      the last run of the JobTrigger.
    endTime: Exclude files or rows newer than this value. If set to zero, no
      upper time limit is applied.
    startTime: Exclude files or rows older than this value.
    timestampField: Specification of the field containing the timestamp of
      scanned items. Used for data sources like Datastore or BigQuery. If not
      specified for BigQuery, table last modification timestamp is checked
      against given time span. The valid data types of the timestamp field
      are: for BigQuery - timestamp, date, datetime; for Datastore -
      timestamp. Datastore entity will be scanned if the timestamp property
      does not exist or its value is empty or invalid.
  """

  enableAutoPopulationOfTimespanConfig = _messages.BooleanField(1)
  endTime = _messages.StringField(2)
  startTime = _messages.StringField(3)
  timestampField = _messages.MessageField('GooglePrivacyDlpV2FieldId', 4)


class GooglePrivacyDlpV2TransformationOverview(_messages.Message):
  r"""Overview of the modifications that occurred.

  Fields:
    transformationSummaries: Transformations applied to the dataset.
    transformedBytes: Total size in bytes that were transformed in some way.
  """

  transformationSummaries = _messages.MessageField('GooglePrivacyDlpV2TransformationSummary', 1, repeated=True)
  transformedBytes = _messages.IntegerField(2)


class GooglePrivacyDlpV2TransformationSummary(_messages.Message):
  r"""Summary of a single tranformation. Only one of 'transformation',
  'field_transformation', or 'record_suppress' will be set.

  Fields:
    field: Set if the transformation was limited to a specific FieldId.
    fieldTransformations: The field transformation that was applied. If
      multiple field transformations are requested for a single field, this
      list will contain all of them; otherwise, only one is supplied.
    infoType: Set if the transformation was limited to a specific info_type.
    recordSuppress: The specific suppression option these stats apply to.
    results: A GooglePrivacyDlpV2SummaryResult attribute.
    transformation: The specific transformation these stats apply to.
    transformedBytes: Total size in bytes that were transformed in some way.
  """

  field = _messages.MessageField('GooglePrivacyDlpV2FieldId', 1)
  fieldTransformations = _messages.MessageField('GooglePrivacyDlpV2FieldTransformation', 2, repeated=True)
  infoType = _messages.MessageField('GooglePrivacyDlpV2InfoType', 3)
  recordSuppress = _messages.MessageField('GooglePrivacyDlpV2RecordSuppression', 4)
  results = _messages.MessageField('GooglePrivacyDlpV2SummaryResult', 5, repeated=True)
  transformation = _messages.MessageField('GooglePrivacyDlpV2PrimitiveTransformation', 6)
  transformedBytes = _messages.IntegerField(7)


class GooglePrivacyDlpV2TransientCryptoKey(_messages.Message):
  r"""Use this to have a random data crypto key generated. It will be
  discarded after the request finishes.

  Fields:
    name: Name of the key. [required] This is an arbitrary string used to
      differentiate different keys. A unique key is generated per name: two
      separate `TransientCryptoKey` protos share the same generated key if
      their names are the same. When the data crypto key is generated, this
      name is not used in any way (repeating the api call will result in a
      different key being generated).
  """

  name = _messages.StringField(1)


class GooglePrivacyDlpV2Trigger(_messages.Message):
  r"""What event needs to occur for a new job to be started.

  Fields:
    schedule: Create a job on a repeating basis based on the elapse of time.
  """

  schedule = _messages.MessageField('GooglePrivacyDlpV2Schedule', 1)


class GooglePrivacyDlpV2UnwrappedCryptoKey(_messages.Message):
  r"""Using raw keys is prone to security risks due to accidentally leaking
  the key. Choose another type of key if possible.

  Fields:
    key: The AES 128/192/256 bit key. [required]
  """

  key = _messages.BytesField(1)


class GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest(_messages.Message):
  r"""Request message for UpdateDeidentifyTemplate.

  Fields:
    deidentifyTemplate: New DeidentifyTemplate value.
    updateMask: Mask to control which fields get updated.
  """

  deidentifyTemplate = _messages.MessageField('GooglePrivacyDlpV2DeidentifyTemplate', 1)
  updateMask = _messages.StringField(2)


class GooglePrivacyDlpV2UpdateInspectTemplateRequest(_messages.Message):
  r"""Request message for UpdateInspectTemplate.

  Fields:
    inspectTemplate: New InspectTemplate value.
    updateMask: Mask to control which fields get updated.
  """

  inspectTemplate = _messages.MessageField('GooglePrivacyDlpV2InspectTemplate', 1)
  updateMask = _messages.StringField(2)


class GooglePrivacyDlpV2UpdateJobTriggerRequest(_messages.Message):
  r"""Request message for UpdateJobTrigger.

  Fields:
    jobTrigger: New JobTrigger value.
    updateMask: Mask to control which fields get updated.
  """

  jobTrigger = _messages.MessageField('GooglePrivacyDlpV2JobTrigger', 1)
  updateMask = _messages.StringField(2)


class GooglePrivacyDlpV2UpdateStoredInfoTypeRequest(_messages.Message):
  r"""Request message for UpdateStoredInfoType.

  Fields:
    config: Updated configuration for the storedInfoType. If not provided, a
      new version of the storedInfoType will be created with the existing
      configuration.
    updateMask: Mask to control which fields get updated.
  """

  config = _messages.MessageField('GooglePrivacyDlpV2StoredInfoTypeConfig', 1)
  updateMask = _messages.StringField(2)


class GooglePrivacyDlpV2Value(_messages.Message):
  r"""Set of primitive values supported by the system. Note that for the
  purposes of inspection or transformation, the number of bytes considered to
  comprise a 'Value' is based on its representation as a UTF-8 encoded string.
  For example, if 'integer_value' is set to 123456789, the number of bytes
  would be counted as 9, even though an int64 only holds up to 8 bytes of
  data.

  Enums:
    DayOfWeekValueValueValuesEnum:

  Fields:
    booleanValue: A boolean attribute.
    dateValue: A GoogleTypeDate attribute.
    dayOfWeekValue: A DayOfWeekValueValueValuesEnum attribute.
    floatValue: A number attribute.
    integerValue: A string attribute.
    stringValue: A string attribute.
    timeValue: A GoogleTypeTimeOfDay attribute.
    timestampValue: A string attribute.
  """

  class DayOfWeekValueValueValuesEnum(_messages.Enum):
    r"""DayOfWeekValueValueValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The unspecified day-of-week.
      MONDAY: The day-of-week of Monday.
      TUESDAY: The day-of-week of Tuesday.
      WEDNESDAY: The day-of-week of Wednesday.
      THURSDAY: The day-of-week of Thursday.
      FRIDAY: The day-of-week of Friday.
      SATURDAY: The day-of-week of Saturday.
      SUNDAY: The day-of-week of Sunday.
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  booleanValue = _messages.BooleanField(1)
  dateValue = _messages.MessageField('GoogleTypeDate', 2)
  dayOfWeekValue = _messages.EnumField('DayOfWeekValueValueValuesEnum', 3)
  floatValue = _messages.FloatField(4)
  integerValue = _messages.IntegerField(5)
  stringValue = _messages.StringField(6)
  timeValue = _messages.MessageField('GoogleTypeTimeOfDay', 7)
  timestampValue = _messages.StringField(8)


class GooglePrivacyDlpV2ValueFrequency(_messages.Message):
  r"""A value of a field, including its frequency.

  Fields:
    count: How many times the value is contained in the field.
    value: A value contained in the field in question.
  """

  count = _messages.IntegerField(1)
  value = _messages.MessageField('GooglePrivacyDlpV2Value', 2)


class GooglePrivacyDlpV2WordList(_messages.Message):
  r"""Message defining a list of words or phrases to search for in the data.

  Fields:
    words: Words or phrases defining the dictionary. The dictionary must
      contain at least one phrase and every phrase must contain at least 2
      characters that are letters or digits. [required]
  """

  words = _messages.StringField(1, repeated=True)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeDate(_messages.Message):
  r"""Represents a whole calendar date, for example date of birth. The time of
  day and time zone are either specified elsewhere or are not significant. The
  date is relative to the Proleptic Gregorian Calendar. The day can be 0 to
  represent a year and month where the day is not significant, for example
  credit card expiration date. The year can be 0 to represent a month and day
  independent of year, for example anniversary date. Related types are
  google.type.TimeOfDay and `google.protobuf.Timestamp`.

  Fields:
    day: Day of month. Must be from 1 to 31 and valid for the year and month,
      or 0 if specifying a year/month where the day is not significant.
    month: Month of year. Must be from 1 to 12, or 0 if specifying a date
      without a month.
    year: Year of date. Must be from 1 to 9999, or 0 if specifying a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleTypeTimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
